/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class OrbitVectorDataSet
implements VectorDataSet {
    static double[][] data;
    private double[][] idata;
    private static OrbitVectorDataSet xview;
    private static OrbitVectorDataSet yview;
    Units xunits;
    Units yunits;
    Units tunits;
    int view;

    private OrbitVectorDataSet(int view) {
        data = new double[3][40];
        for (int i = 0; i < data[0].length; ++i) {
            OrbitVectorDataSet.data[0][i] = 5.0 * Math.sin((double)(i * 1 * 2) * Math.PI / 40.0);
            OrbitVectorDataSet.data[1][i] = 5.0 * Math.cos((double)i * 1.55 * 2.0 * Math.PI / 40.0);
            OrbitVectorDataSet.data[2][i] = i;
        }
        this.yunits = this.tunits = Units.dimensionless;
        this.xunits = this.tunits;
        this.view = view;
    }

    public static OrbitVectorDataSet create() {
        return xview;
    }

    public Datum getDatum(int i) {
        return this.yunits.createDatum(this.getDouble(i, this.yunits));
    }

    public double getDouble(int i, Units units) {
        return data[this.view][i];
    }

    public int getInt(int i, Units units) {
        return (int)this.getDouble(i, units);
    }

    public DataSet getPlanarView(String planeID) {
        if ("x".equals(planeID)) {
            return xview;
        }
        if ("y".equals(planeID)) {
            return yview;
        }
        throw new IllegalArgumentException("No such plane");
    }

    public String[] getPlaneIds() {
        return new String[]{"x", "y"};
    }

    public Object getProperty(String name) {
        return null;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public int getXLength() {
        return data[0].length;
    }

    public Datum getXTagDatum(int i) {
        return this.tunits.createDatum(this.getXTagDouble(i, this.tunits));
    }

    public double getXTagDouble(int i, Units units) {
        return this.tunits.convertDoubleTo(units, data[2][i]);
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.getXTagDouble(i, this.tunits);
    }

    public Units getXUnits() {
        return this.tunits;
    }

    public Units getYUnits() {
        if (this.view == 0) {
            return this.xunits;
        }
        return this.yunits;
    }

    static {
        xview = new OrbitVectorDataSet(0);
        yview = new OrbitVectorDataSet(1);
    }
}

