/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.XSliceDataSet;
import org.das2.dataset.YSliceDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class WritableTableDataSet
implements TableDataSet {
    double[] z;
    double[] x;
    double[] y;
    final int nx;
    final int ny;
    Units xunits;
    Units yunits;
    Units zunits;
    Map properties;

    public static WritableTableDataSet newSimple(int nx, Units xunits, int ny, Units yunits, Units zunits) {
        double[] z = new double[nx * ny];
        double[] x = new double[nx];
        double[] y = new double[ny];
        return new WritableTableDataSet(x, xunits, y, yunits, z, zunits, new HashMap());
    }

    public static WritableTableDataSet newEmpty(TableDataSet tds) {
        if (tds.tableCount() > 1) {
            throw new IllegalArgumentException("only supported for simple tables");
        }
        int nx = tds.tableEnd(0);
        int ny = tds.getYLength(0);
        WritableTableDataSet result = WritableTableDataSet.newSimple(nx, tds.getXUnits(), ny, tds.getYUnits(), tds.getZUnits());
        for (int i = 0; i < nx; ++i) {
            result.setXTagDouble(i, tds.getXTagDouble(i, tds.getXUnits()), tds.getXUnits());
        }
        for (int j = 0; j < ny; ++j) {
            result.setYTagDouble(0, j, tds.getYTagDouble(0, j, tds.getYUnits()), tds.getYUnits());
        }
        if (tds.getProperty("xTagWidth") != null) {
            result.setProperty("xTagWidth", tds.getProperty("xTagWidth"));
        }
        if (tds.getProperty("yTagWidth") != null) {
            result.setProperty("yTagWidth", tds.getProperty("yTagWidth"));
        }
        return result;
    }

    public static WritableTableDataSet newCopy(TableDataSet tds) {
        if (tds.tableCount() > 1) {
            throw new IllegalArgumentException("only supported for simple tables");
        }
        int nx = tds.tableEnd(0);
        int ny = tds.getYLength(0);
        WritableTableDataSet result = WritableTableDataSet.newEmpty(tds);
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                result.setDouble(i, j, tds.getDouble(i, j, tds.getZUnits()), tds.getZUnits());
            }
        }
        result.properties = new HashMap(tds.getProperties());
        return result;
    }

    private WritableTableDataSet(double[] x, Units xunits, double[] y, Units yunits, double[] z, Units zunits, Map properties) {
        this.z = z;
        this.x = x;
        this.y = y;
        this.nx = x.length;
        this.ny = y.length;
        this.zunits = zunits;
        this.yunits = yunits;
        this.xunits = xunits;
        this.properties = properties;
    }

    private final int indexOf(int i, int j) {
        return i * this.ny + j;
    }

    public Datum getDatum(int i, int j) {
        return Datum.create(this.z[this.indexOf(i, j)], this.zunits);
    }

    public void setDatum(int i, int j, Datum datum) {
        this.z[this.indexOf((int)i, (int)j)] = datum.doubleValue(this.zunits);
    }

    public double getDouble(int i, int j, Units units) {
        if (units == this.zunits) {
            return this.z[this.indexOf(i, j)];
        }
        return this.zunits.convertDoubleTo(units, this.z[this.indexOf(i, j)]);
    }

    public void setDouble(int i, int j, double zvalue, Units units) {
        this.z[this.indexOf((int)i, (int)j)] = units == this.zunits ? zvalue : units.convertDoubleTo(this.zunits, zvalue);
    }

    public double[] getDoubleScan(int i, Units units) {
        throw new UnsupportedOperationException();
    }

    public int getInt(int i, int j, Units units) {
        throw new UnsupportedOperationException();
    }

    public DataSet getPlanarView(String planeID) {
        return null;
    }

    public String[] getPlaneIds() {
        return new String[0];
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(int table, String name) {
        return this.properties.get(name);
    }

    public void setProperty(int table, String name, Object value) {
        this.properties.put(name, value);
    }

    public DatumVector getScan(int i) {
        throw new UnsupportedOperationException();
    }

    public int getXLength() {
        return this.x.length;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public Datum getXTagDatum(int i) {
        return Datum.create(this.x[i], this.xunits);
    }

    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x[i]);
    }

    public void setXTagDouble(int i, double xvalue, Units units) {
        this.x[i] = units.convertDoubleTo(this.xunits, xvalue);
    }

    public int getXTagInt(int i, Units units) {
        throw new UnsupportedOperationException();
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public int getYLength(int table) {
        return this.y.length;
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public Datum getYTagDatum(int table, int j) {
        return Datum.create(this.y[j], this.yunits);
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.yunits.convertDoubleTo(units, this.y[j]);
    }

    public void setYTagDouble(int table, int j, double yvalue, Units units) {
        this.y[j] = units.convertDoubleTo(this.yunits, yvalue);
    }

    public int getYTagInt(int table, int j, Units units) {
        throw new UnsupportedOperationException();
    }

    public DatumVector getYTags(int table) {
        return DatumVector.newDatumVector(this.y, this.yunits);
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Units getZUnits() {
        return this.zunits;
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int table) {
        return this.x.length;
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return 0;
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

