/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamMultiYDescriptor;
import org.das2.stream.StreamProducer;
import org.das2.stream.StreamXDescriptor;
import org.das2.util.FixedWidthFormatter;

public class VectorUtil {
    public static double[] getXTagArrayDouble(DataSet vds, Units units) {
        int ixmax = vds.getXLength();
        double[] xx = new double[ixmax];
        for (int i = 0; i < ixmax; ++i) {
            xx[i] = vds.getXTagDouble(i, units);
        }
        return xx;
    }

    private static int closest(double[] xx, double x) {
        int result;
        for (result = 0; result < xx.length - 1 && xx[result] < x; ++result) {
        }
        while (result > 0 && xx[result] > x) {
            --result;
        }
        if (result < xx.length - 2) {
            result = (x - xx[result]) / (xx[result + 1] - xx[result]) < 0.5 ? result : result + 1;
        }
        return result;
    }

    public static int closestXTag(DataSet ds, Datum datum) {
        return VectorUtil.closestXTag(ds, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestXTag(DataSet ds, double x, Units units) {
        double[] xx = VectorUtil.getXTagArrayDouble(ds, units);
        return VectorUtil.closest(xx, x);
    }

    public static Datum median(VectorDataSet ds) {
        double[] data = new double[ds.getXLength()];
        int idata = 0;
        Units units = ds.getYUnits();
        for (int i = 0; i < ds.getXLength(); ++i) {
            double zz = ds.getDouble(i, units);
            if (units.isFill(zz)) continue;
            data[idata++] = zz;
        }
        if (idata == 0) {
            return Datum.create(units.getFillDouble(), units);
        }
        Arrays.sort(data, 0, idata);
        int n = idata / 2;
        return Datum.create(data[n], units);
    }

    public static void dumpToAsciiStream(VectorDataSet vds, Datum xmin, Datum xmax, OutputStream out) {
        List<String> planeIDs;
        PrintStream pout = new PrintStream(out);
        Datum base = null;
        Units offsetUnits = null;
        pout.print("[00]");
        pout.println("<stream start=\"" + vds.getXTagDatum(0) + "\" end=\"" + vds.getXTagDatum(vds.getXLength() - 1) + "\" >");
        pout.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        pout.print("</stream>");
        if (vds.getXUnits() instanceof LocationUnits && (offsetUnits = ((LocationUnits)(base = xmin).getUnits()).getOffsetUnits()) == Units.microseconds) {
            offsetUnits = Units.seconds;
        }
        pout.print("[01]<packet>\n");
        pout.print("<x type=\"asciiTab10\" ");
        if (base != null) {
            pout.print("base=\"" + base + "\" ");
            pout.print(" xUnits=\"" + offsetUnits + "\" ");
        } else {
            pout.print(" xUnits=\"" + vds.getXUnits() + "\"");
        }
        pout.println(" />");
        if (vds.getProperty("plane-list") != null) {
            planeIDs = (List)vds.getProperty("plane-list");
        } else {
            planeIDs = new ArrayList();
            planeIDs.add("");
        }
        for (int i = 0; i < planeIDs.size(); ++i) {
            String plid = (String)planeIDs.get(i);
            pout.println("<y type=\"asciiTab10\" name=\"" + plid + "\" yUnits=\"" + vds.getPlanarView(plid).getYUnits() + "\" />");
        }
        pout.print("</packet>");
        DecimalFormat xnf = new DecimalFormat("00000.000");
        DecimalFormat ynf = new DecimalFormat("0.00E00");
        double dx = xmax.subtract(xmin).doubleValue(offsetUnits);
        for (int i = 0; i < vds.getXLength(); ++i) {
            double x = base != null ? vds.getXTagDatum(i).subtract(base).doubleValue(offsetUnits) : vds.getXTagDouble(i, vds.getXUnits());
            if (!(x >= 0.0) || !(x < dx)) continue;
            pout.print(":01:");
            pout.print(xnf.format(x) + " ");
            for (int iplane = 0; iplane < planeIDs.size(); ++iplane) {
                VectorDataSet vds1 = (VectorDataSet)vds.getPlanarView((String)planeIDs.get(iplane));
                pout.print(FixedWidthFormatter.format(ynf.format(vds1.getDouble(i, vds1.getYUnits())), 9));
                if (iplane == planeIDs.size() - 1) {
                    pout.print("\n");
                    continue;
                }
                pout.print(" ");
            }
        }
        pout.close();
    }

    public static void dumpToAsciiStream(VectorDataSet vds, OutputStream out) {
        VectorUtil.dumpToAsciiStream(vds, Channels.newChannel(out));
    }

    public static void dumpToAsciiStream(VectorDataSet vds, WritableByteChannel out) {
        VectorUtil.dumpToDas2Stream(vds, out, true);
    }

    public static void dumpToStream(VectorDataSet vds, OutputStream out) {
        VectorUtil.dumpToAsciiStream(vds, out);
    }

    public static void dumpToBinaryStream(VectorDataSet vds, OutputStream out) {
        VectorUtil.dumpToDas2Stream(vds, Channels.newChannel(out), false);
    }

    private static void dumpToDas2Stream(VectorDataSet vds, WritableByteChannel out, boolean asciiTransferTypes) {
        if (vds.getXLength() == 0) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        try {
            int i;
            DataTransferType yTransferType;
            DataTransferType xTransferType;
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            Map properties = vds.getProperties();
            if (properties != null) {
                for (String key : properties.keySet()) {
                    sd.setProperty(key, properties.get(key));
                }
            }
            if (asciiTransferTypes) {
                xTransferType = UnitsUtil.isTimeLocation(vds.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii14");
                yTransferType = DataTransferType.getByName("ascii14");
            } else {
                xTransferType = DataTransferType.getByName("sun_real8");
                yTransferType = DataTransferType.getByName("sun_real4");
            }
            producer.streamDescriptor(sd);
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setUnits(vds.getXUnits());
            xDescriptor.setDataTransferType(xTransferType);
            PacketDescriptor pd = new PacketDescriptor();
            pd.setXDescriptor(xDescriptor);
            String[] planeIds = DataSetUtil.getAllPlaneIds(vds);
            DatumVector[] yValues = new DatumVector[planeIds.length];
            for (i = 0; i < planeIds.length; ++i) {
                StreamMultiYDescriptor yDescriptor = new StreamMultiYDescriptor();
                yDescriptor.setName(planeIds[i]);
                yDescriptor.setDataTransferType(yTransferType);
                yDescriptor.setUnits(((VectorDataSet)vds.getPlanarView(planeIds[i])).getYUnits());
                pd.addYDescriptor(yDescriptor);
            }
            producer.packetDescriptor(pd);
            for (i = 0; i < vds.getXLength(); ++i) {
                Datum xTag = vds.getXTagDatum(i);
                for (int j = 0; j < planeIds.length; ++j) {
                    yValues[j] = VectorUtil.toDatumVector(((VectorDataSet)vds.getPlanarView(planeIds[j])).getDatum(i));
                }
                producer.packet(pd, xTag, yValues);
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    private static DatumVector toDatumVector(Datum d) {
        double[] array = new double[]{d.doubleValue(d.getUnits())};
        return DatumVector.newDatumVector(array, d.getUnits());
    }

    public static String toString(VectorDataSet ds) {
        return "[VectorDataSet " + ds.getXLength() + " xTags ]";
    }

    public static VectorDataSet finiteDerivative(VectorDataSet ds, int n) {
        VectorDataSetBuilder builder = new VectorDataSetBuilder(ds.getXUnits(), Units.dimensionless);
        Units xunits = ds.getXUnits();
        Units yunits = ds.getYUnits();
        for (int i = n; i < ds.getXLength(); ++i) {
            double dx = ds.getXTagDouble(i, xunits) - ds.getXTagDouble(i - n, xunits);
            double dy = ds.getDouble(i, yunits) - ds.getDouble(i - n, yunits);
            builder.insertY(ds.getXTagDouble(i - n, xunits) + dx / 2.0, dy / dx);
        }
        for (String key : ds.getProperties().keySet()) {
            builder.setProperty(key, ds.getProperty(key));
        }
        return builder.toVectorDataSet();
    }
}

