/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.AbstractDataSetCache;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;

public class LimitCountDataSetCache
extends AbstractDataSetCache {
    protected AbstractDataSetCache.Entry[] buffer;

    public LimitCountDataSetCache(int count) {
        this.buffer = new AbstractDataSetCache.Entry[count];
    }

    public void store(DataSetDescriptor dsd, CacheTag cacheTag, DataSet data) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, data);
        int iMin = -1;
        for (int i = this.buffer.length - 1; i >= 0; --i) {
            if (this.buffer[i] != null) continue;
            iMin = i;
        }
        if (iMin == -1) {
            long oldestAccess = Long.MAX_VALUE;
            int oldest = -1;
            for (int i = this.buffer.length - 1; i >= 0; --i) {
                if (this.buffer[i].lastAccess >= oldestAccess) continue;
                oldest = i;
                oldestAccess = this.buffer[i].lastAccess;
            }
            iMin = oldest;
        }
        this.buffer[iMin] = entry;
    }

    private int findStored(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, null);
        int iHit = -1;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null || !this.buffer[i].satifies(entry)) continue;
            iHit = i;
        }
        return iHit;
    }

    public boolean haveStoredImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, null);
        int iHit = this.findStored(dsd, cacheTag);
        return iHit != -1;
    }

    public DataSet retrieveImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        int iHit = this.findStored(dsd, cacheTag);
        if (iHit != -1) {
            ++this.buffer[iHit].nhits;
            this.buffer[iHit].lastAccess = System.currentTimeMillis();
            return this.buffer[iHit].data;
        }
        throw new IllegalArgumentException("Data not found in buffer");
    }

    public void reset() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
    }

    public double calcHitRate() {
        return (double)this.hits * 100.0 / (double)(this.hits + this.misses);
    }

    public String toString() {
        String result = "\n---DataSetCache---\n";
        for (int i = 0; i < this.buffer.length; ++i) {
            result = result + "Buffer " + i + ": ";
            result = this.buffer[i] != null ? result + this.buffer[i].toString() : result + "";
            result = result + "\n";
        }
        result = result + "-------------------";
        return result;
    }
}

