/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.DasServer;
import org.das2.client.DataSetDescriptorNotAvailableException;
import org.das2.client.NoSuchDataSetException;
import org.das2.client.StreamDataSetDescriptor;
import org.das2.components.propertyeditor.Displayable;
import org.das2.dataset.CacheTag;
import org.das2.dataset.ConstantDataSetDescriptor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetCache;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.stream.StreamDescriptor;
import org.das2.system.DasLogger;
import org.das2.system.RequestProcessor;
import org.das2.util.URLBuddy;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public abstract class DataSetDescriptor
implements Displayable {
    protected Map properties = new HashMap();
    private boolean defaultCaching = true;
    private DataSetCache dataSetCache = DasApplication.getDefaultApplication().getDataSetCache();
    private String dataSetID;
    private EventListenerList listenerList;
    private static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private static final Pattern CLASS_ID = Pattern.compile("class:([a-zA-Z0-9_\\.]+)(?:\\?(.*))?");
    private static final Pattern NAME_VALUE = Pattern.compile("([_0-9a-zA-Z%+.-]+)=([_0-9a-zA-Z%+.-]+)");

    protected DataSetDescriptor(String dataSetID) {
        this.dataSetID = dataSetID;
    }

    protected DataSetDescriptor() {
        this("");
    }

    protected abstract DataSet getDataSetImpl(Datum var1, Datum var2, Datum var3, ProgressMonitor var4) throws DasException;

    public abstract Units getXUnits();

    public void requestDataSet(final Datum start, final Datum end, final Datum resolution, final ProgressMonitor monitor, Object lockObject) {
        Runnable request = new Runnable(){

            public void run() {
                logger.fine("requestDataSet: " + start + " " + end + " " + resolution);
                try {
                    DataSet ds = DataSetDescriptor.this.getDataSet(start, end, resolution, monitor);
                    if (ds == null) {
                        throw new NoDataInIntervalException(new DatumRange(start, end).toString());
                    }
                    DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)DataSetDescriptor.this, ds);
                    dsue.setMonitor(monitor);
                    DataSetDescriptor.this.fireDataSetUpdateEvent(dsue);
                }
                catch (DasException e) {
                    DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)DataSetDescriptor.this, (Exception)e);
                    dsue.setMonitor(monitor);
                    DataSetDescriptor.this.fireDataSetUpdateEvent(dsue);
                }
            }

            public String toString() {
                return "loadDataSet " + new DatumRange(start, end);
            }
        };
        logger.fine("submit data request");
        CacheTag tag = new CacheTag(start, end, resolution);
        if (this.dataSetCache.haveStored(this, tag)) {
            request.run();
        } else {
            RequestProcessor.invokeLater(request, lockObject);
        }
    }

    public void requestDataSet(final Datum start, final Datum end, final Datum resolution, final ProgressMonitor monitor, Object lockObject, final DataSetUpdateListener listener) {
        if (lockObject == null) {
            lockObject = listener;
        }
        if (this instanceof ConstantDataSetDescriptor) {
            try {
                DataSet ds = this.getDataSet(null, null, null, null);
                DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)this, ds);
                dsue.setMonitor(monitor);
            }
            catch (DasException e) {
                DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)this, (Exception)e);
                dsue.setMonitor(monitor);
                listener.dataSetUpdated(dsue);
            }
        } else {
            Runnable request = new Runnable(){

                public void run() {
                    logger.fine("request data from dsd: " + start + " " + end + " " + resolution);
                    try {
                        DataSet ds = DataSetDescriptor.this.getDataSet(start, end, resolution, monitor);
                        DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)DataSetDescriptor.this, ds);
                        dsue.setMonitor(monitor);
                        listener.dataSetUpdated(dsue);
                    }
                    catch (DasException e) {
                        DataSetUpdateEvent dsue = new DataSetUpdateEvent((Object)DataSetDescriptor.this, (Exception)e);
                        dsue.setMonitor(monitor);
                        listener.dataSetUpdated(dsue);
                    }
                }

                public String toString() {
                    return "loadDataSet " + new DatumRange(start, end);
                }
            };
            RequestProcessor.invokeLater(request, lockObject);
        }
    }

    public DataSet getDataSet(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CacheTag tag = null;
        if (this.defaultCaching) {
            tag = new CacheTag(start, end, resolution);
            DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).fine("getDataSet " + this + " " + tag);
        }
        if (this.defaultCaching && this.dataSetCache.haveStored(this, tag)) {
            return this.dataSetCache.retrieve(this, tag);
        }
        try {
            DataSet ds = this.getDataSetImpl(start, end, resolution, monitor);
            if (ds != null) {
                if (ds.getProperty("cacheTag") != null) {
                    tag = (CacheTag)ds.getProperty("cacheTag");
                }
                if (this.defaultCaching) {
                    this.dataSetCache.store(this, tag, ds);
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        catch (DasException e) {
            throw e;
        }
        finally {
            monitor.finished();
        }
    }

    public void reset() {
        this.dataSetCache.reset();
    }

    public void setDefaultCaching(boolean value) {
        if (!value) {
            this.defaultCaching = value;
        }
    }

    public void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataSetUpdateListener.class, listener);
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(DataSetUpdateListener.class, listener);
    }

    protected void fireDataSetUpdateEvent(DataSetUpdateEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    public static DataSetDescriptor create(String dataSetID) throws DasException {
        DataSetDescriptor result;
        Matcher classMatcher = CLASS_ID.matcher(dataSetID);
        if (classMatcher.matches()) {
            result = DataSetDescriptor.createFromClassName(dataSetID, classMatcher);
        } else {
            try {
                result = DataSetDescriptor.createFromServerAddress(new URL(dataSetID));
            }
            catch (MalformedURLException mue) {
                throw new DasIOException(mue.getMessage());
            }
        }
        result.dataSetID = dataSetID;
        return result;
    }

    private static DataSetDescriptor createFromServerAddress(URL url) throws DasException {
        DasServer server = DasServer.create(url);
        StreamDescriptor sd = server.getStreamDescriptor(url);
        return new StreamDataSetDescriptor(sd, server.getStandardDataStreamSource(url));
    }

    private static DataSetDescriptor createFromClassName(String dataSetID, Matcher matcher) throws DasException {
        try {
            String className = matcher.group(1);
            String argString = matcher.group(2);
            Map argMap = argString == null ? Collections.EMPTY_MAP : URLBuddy.parseQueryString(argString);
            Class<?> dsdClass = Class.forName(className);
            Method method = dsdClass.getMethod("newDataSetDescriptor", Map.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchDataSetException("newDataSetDescriptor must be static");
            }
            return (DataSetDescriptor)method.invoke(null, argMap);
        }
        catch (ClassNotFoundException cnfe) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(cnfe.getMessage());
            dsdnae.initCause(cnfe);
            throw dsdnae;
        }
        catch (NoSuchMethodException nsme) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(nsme.getMessage());
            dsdnae.initCause(nsme);
            throw dsdnae;
        }
        catch (InvocationTargetException ite) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(ite.getTargetException().getMessage());
            dsdnae.initCause(ite.getTargetException());
            throw dsdnae;
        }
        catch (IllegalAccessException iae) {
            DataSetDescriptorNotAvailableException dsdnae = new DataSetDescriptorNotAvailableException(iae.getMessage());
            dsdnae.initCause(iae);
            throw dsdnae;
        }
    }

    protected void setProperties(Map properties) {
        this.properties.putAll(properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Icon getListIcon() {
        return null;
    }

    public String getListLabel() {
        return this.dataSetID;
    }

    public DataSetCache getDataSetCache() {
        return this.dataSetCache;
    }
}

