/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.WeightsTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.system.DasLogger;

public class AverageTableRebinner
implements DataSetRebinner {
    private static Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    private boolean interpolate = true;
    private boolean enlargePixels = true;
    protected Interpolate interpolateType = Interpolate.Linear;
    public static final String PROP_INTERPOLATETYPE = "interpolateType";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        Units resultYUnits;
        Object yTags;
        int i;
        double[] xTagMax;
        double[] xTagMin;
        double[] xTags;
        logger.finest("enter AverageTableRebinner.rebin");
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + ds.getClass().getName());
        }
        TableDataSet tds = (TableDataSet)ds;
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        if (ddX != null && tds.getXLength() > 0) {
            double start = tds.getXTagDouble(0, ddX.getUnits());
            double end = tds.getXTagDouble(tds.getXLength() - 1, ddX.getUnits());
            if (start > ddX.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (end < ddX.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        long timer = System.currentTimeMillis();
        Units xunits = ddX.getUnits();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        logger.finest("Allocating rebinData and rebinWeights: " + nx + " x " + ny);
        double[][] rebinData = new double[nx][ny];
        double[][] rebinWeights = new double[nx][ny];
        AverageTableRebinner.average(tds, weights, rebinData, rebinWeights, ddX, ddY);
        if (this.interpolate) {
            AverageTableRebinner.doBoundaries2RL(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
            AverageTableRebinner.doBoundaries2TB(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
            AverageTableRebinner.doCorners(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
        }
        if (ddX != null) {
            xTags = ddX.binCenters();
            xTagMin = ddX.binStops();
            xTagMax = ddX.binStarts();
            for (i = 0; i < tds.getXLength(); ++i) {
                double xt = tds.getXTagDouble(i, xunits);
                int ibin = ddX.whichBin(xt, xunits);
                if (ibin <= -1 || ibin >= nx) continue;
                xTagMin[ibin] = Math.min(xTagMin[ibin], xt);
                xTagMax[ibin] = Math.max(xTagMax[ibin], xt);
            }
        } else {
            xTags = new double[nx];
            for (i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
            xTagMin = xTags;
            xTagMax = xTags;
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        Units resultXUnits = ddX == null ? tds.getXUnits() : ddX.getUnits();
        Units units = resultYUnits = ddY == null ? tds.getYUnits() : ddY.getUnits();
        if (this.interpolate) {
            Datum xTagWidth = (Datum)ds.getProperty("xTagWidth");
            if (xTagWidth == null) {
                xTagWidth = DataSetUtil.guessXTagWidth(tds);
            }
            double xTagWidthDouble = xTagWidth.doubleValue(ddX.getUnits().getOffsetUnits());
            Datum yTagWidth = (Datum)ds.getProperty("yTagWidth");
            if (ddX != null) {
                AverageTableRebinner.fillInterpolateX(rebinData, rebinWeights, xTags, xTagMin, xTagMax, xTagWidthDouble, this.interpolateType);
            }
            if (ddY != null) {
                if (yTagWidth == null && this.interpolateType == Interpolate.NearestNeighbor) {
                    yTagWidth = TableUtil.guessYTagWidth(tds);
                }
                AverageTableRebinner.fillInterpolateY(rebinData, rebinWeights, ddY, yTagWidth, this.interpolateType);
            }
        } else if (this.enlargePixels) {
            this.enlargePixels(rebinData, rebinWeights);
        }
        double[][][] zValues = new double[][][]{rebinData, rebinWeights};
        int[] tableOffsets = new int[]{0};
        Units[] zUnits = new Units[]{tds.getZUnits(), Units.dimensionless};
        String[] planeIDs = new String[]{"", "weights"};
        HashMap<String, Datum> properties = new HashMap<String, Datum>(ds.getProperties());
        if (ddX != null) {
            properties.put("xTagWidth", ddX.binWidthDatum());
        }
        if (ddY != null) {
            properties.put("yTagWidth", ddY.binWidthDatum());
        }
        DefaultTableDataSet result = new DefaultTableDataSet(xTags, resultXUnits, (double[][])yTags, resultYUnits, (double[][][])zValues, zUnits, planeIDs, tableOffsets, (Map)properties);
        logger.finest("done, AverageTableRebinner.rebin");
        return result;
    }

    static void doBoundaries2RL(TableDataSet tds, TableDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        Units yunits = tds.getYUnits();
        Units zunits = tds.getZUnits();
        Units wunits = Units.dimensionless;
        TableDataSet wds = WeightsTableDataSet.create(tds);
        for (int i = 0; i < 2; ++i) {
            DatumRange dr;
            int ix = i == 0 ? 0 : ddX.numberOfBins() - 1;
            Datum xx = i == 0 ? ddX.binCenter(0) : ddX.binCenter(ix);
            int i0 = DataSetUtil.getPreviousColumn(tds, xx);
            int i1 = DataSetUtil.getNextColumn(tds, xx);
            int itable = tds.tableOfIndex(i0);
            if (itable != tds.tableOfIndex(i1) || i1 == i0 || !(dr = new DatumRange(tds.getXTagDatum(i0), tds.getXTagDatum(i1))).width().gt(DataSetUtil.guessXTagWidth(tds).multiply(0.9))) continue;
            double alpha = DatumRangeUtil.normalize(dr, xx);
            if (interpolateType == Interpolate.NearestNeighbor) {
                alpha = alpha < 0.5 ? 0.0 : 1.0;
            }
            int ny = ddY == null ? tds.getYLength(itable) : ddY.numberOfBins();
            for (int j = 0; j < tds.getYLength(itable); ++j) {
                int jj;
                int n = jj = ddY == null ? j : ddY.whichBin(tds.getYTagDouble(itable, j, yunits), yunits);
                if (jj < 0 || jj >= ny || rebinWeights[ix][jj] > 0.0 || wds.getDouble(i0, j, wunits) * wds.getDouble(i1, j, wunits) == 0.0) continue;
                rebinData[ix][jj] = (1.0 - alpha) * tds.getDouble(i0, j, zunits) + alpha * tds.getDouble(i1, j, zunits);
                rebinWeights[ix][jj] = 1.0;
            }
        }
    }

    static void doBoundaries2TB(TableDataSet tds, TableDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        if (ddY == null) {
            return;
        }
        Units yunits = tds.getYUnits();
        Units zunits = tds.getZUnits();
        Units xunits = tds.getXUnits();
        Units wunits = Units.dimensionless;
        TableDataSet wds = WeightsTableDataSet.create(tds);
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            for (int i = 0; i < 2; ++i) {
                int iy = i == 0 ? 0 : ddY.numberOfBins() - 1;
                Datum yy = i == 0 ? ddY.binCenter(0) : ddY.binCenter(iy);
                int j0 = TableUtil.getPreviousRow(tds, itable, yy);
                int j1 = TableUtil.getNextRow(tds, itable, yy);
                if (j1 == j0) continue;
                DatumRange dr = new DatumRange(tds.getYTagDatum(itable, j0), tds.getYTagDatum(itable, j1));
                Datum dsWidth = TableUtil.guessYTagWidth(tds, itable);
                if (ddY.isLog()) {
                    Units u = dr.getUnits();
                    double d = dr.min().doubleValue(u);
                    double d0 = Math.log(dr.min().doubleValue(u) / d);
                    double d1 = Math.log(dr.max().doubleValue(u) / d);
                    dr = new DatumRange(d0, d1, Units.logERatio);
                    yy = Units.logERatio.createDatum(Math.log(yy.doubleValue(u) / d));
                }
                DatumRange xdr = new DatumRange(ddX.binCenter(0), ddX.binCenter(ddX.numberOfBins() - 1));
                double alpha = DatumRangeUtil.normalize(dr, yy);
                if (interpolateType == Interpolate.NearestNeighbor) {
                    alpha = alpha < 0.5 ? 0.0 : 1.0;
                }
                int nx = ddX.numberOfBins();
                for (int ix = tds.tableStart(itable); ix < tds.tableEnd(itable); ++ix) {
                    int ii = ddX.whichBin(tds.getXTagDouble(ix, xunits), xunits);
                    if (ii < 0 || ii >= nx || rebinWeights[ii][iy] > 0.0 || wds.getDouble(ix, j0, wunits) * wds.getDouble(ix, j1, wunits) == 0.0) continue;
                    rebinData[ii][iy] = (1.0 - alpha) * tds.getDouble(ix, j0, zunits) + alpha * tds.getDouble(ix, j1, zunits);
                    rebinWeights[ii][iy] = 1.0;
                }
            }
        }
    }

    static void doCorners(TableDataSet tds, TableDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        if (ddY == null) {
            return;
        }
        Units yunits = tds.getYUnits();
        Units zunits = tds.getZUnits();
        Units xunits = tds.getXUnits();
        Units wunits = Units.dimensionless;
        TableDataSet wds = WeightsTableDataSet.create(tds);
        for (int i = 0; i < 2; ++i) {
            int ix = i == 0 ? 0 : ddX.numberOfBins() - 1;
            Datum xx = ddX.binCenter(ix);
            int i0 = DataSetUtil.getPreviousColumn(tds, xx);
            int i1 = DataSetUtil.getNextColumn(tds, xx);
            int itable = tds.tableOfIndex(i0);
            if (itable != tds.tableOfIndex(i1) || i0 == i1) continue;
            DatumRange xdr = new DatumRange(tds.getXTagDatum(i0), tds.getXTagDatum(i1));
            double xalpha = DatumRangeUtil.normalize(xdr, xx);
            if (interpolateType == Interpolate.NearestNeighbor) {
                xalpha = xalpha < 0.5 ? 0.0 : 1.0;
            }
            for (int j = 0; j < 2; ++j) {
                int j1;
                int iy = j == 0 ? 0 : ddY.numberOfBins() - 1;
                Datum yy = ddY.binCenter(iy);
                int j0 = TableUtil.getPreviousRow(tds, itable, yy);
                if (j0 == (j1 = TableUtil.getNextRow(tds, itable, yy))) continue;
                DatumRange ydr = new DatumRange(tds.getYTagDatum(itable, j0), tds.getYTagDatum(itable, j1));
                if (!xdr.width().lt(DataSetUtil.guessXTagWidth(tds).multiply(1.1))) continue;
                DatumRange xdr1 = new DatumRange(ddX.binCenter(0), ddX.binCenter(ddX.numberOfBins() - 1));
                double yalpha = DatumRangeUtil.normalize(ydr, yy);
                if (interpolateType == Interpolate.NearestNeighbor) {
                    double d = yalpha = yalpha < 0.5 ? 0.0 : 1.0;
                }
                if (rebinWeights[ix][iy] > 0.0 || wds.getDouble(i1, j1, wunits) * wds.getDouble(i0, j0, wunits) * wds.getDouble(i1, j0, wunits) * wds.getDouble(i0, j1, wunits) == 0.0) continue;
                rebinData[ix][iy] = tds.getDouble(i1, j1, zunits) * xalpha * yalpha + tds.getDouble(i0, j0, zunits) * (1.0 - xalpha) * (1.0 - yalpha) + tds.getDouble(i1, j0, zunits) * xalpha * (1.0 - yalpha) + tds.getDouble(i0, j1, zunits) * (1.0 - xalpha) * yalpha;
                rebinWeights[ix][iy] = 1.0;
            }
        }
    }

    static void average(TableDataSet tds, TableDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY) {
        double[] ycoordinate;
        int ny;
        Units xUnits = tds.getXUnits();
        Units zUnits = tds.getZUnits();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int n = ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        if (ddY != null) {
            ycoordinate = ddY.binCenters();
        } else {
            ycoordinate = new double[tds.getYLength(0)];
            for (int j = 0; j < ycoordinate.length; ++j) {
                ycoordinate[j] = tds.getDouble(0, j, zUnits);
            }
        }
        int nTables = tds.tableCount();
        for (int iTable = 0; iTable < nTables; ++iTable) {
            int[] ibiny = new int[tds.getYLength(iTable)];
            for (int j = 0; j < ibiny.length; ++j) {
                ibiny[j] = ddY != null ? ddY.whichBin(tds.getYTagDouble(iTable, j, tds.getYUnits()), tds.getYUnits()) : j;
            }
            for (int i = tds.tableStart(iTable); i < tds.tableEnd(iTable); ++i) {
                int ibinx = ddX != null ? ddX.whichBin(tds.getXTagDouble(i, xUnits), xUnits) : i;
                if (ibinx < 0 || ibinx >= nx) continue;
                for (int j = 0; j < tds.getYLength(iTable); ++j) {
                    double w;
                    double z = tds.getDouble(i, j, zUnits);
                    double d = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : (w = weights.getDouble(i, j, Units.dimensionless));
                    if (ibiny[j] < 0 || ibiny[j] >= ny) continue;
                    double[] dArray = rebinData[ibinx];
                    int n2 = ibiny[j];
                    dArray[n2] = dArray[n2] + z * w;
                    double[] dArray2 = rebinWeights[ibinx];
                    int n3 = ibiny[j];
                    dArray2[n3] = dArray2[n3] + w;
                }
            }
        }
        AverageTableRebinner.multiplyWeights(rebinData, rebinWeights, zUnits.getFillDouble());
    }

    private static final double linearlyInterpolate(int i0, double z0, int i1, double z1, int i) {
        double r = (double)(i - i0) / (double)(i1 - i0);
        return z0 + r * (z1 - z0);
    }

    private static final void multiplyWeights(double[][] data, double[][] weights, double fill) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = weights[i][j] > 0.0 ? data[i][j] / weights[i][j] : fill;
            }
        }
    }

    static void fillInterpolateX(double[][] data, double[][] weights, double[] xTags, double[] xTagMin, double[] xTagMax, double xSampleWidth, Interpolate interpolateType) {
        int nx = xTags.length;
        int ny = data[0].length;
        int[] i1 = new int[nx];
        int[] i2 = new int[nx];
        for (int j = 0; j < ny; ++j) {
            double a2;
            int i;
            int ii1 = -1;
            int ii2 = -1;
            for (i = 0; i < nx; ++i) {
                if (weights[i][j] > 0.0 && ii1 == i - 1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 == -1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    if (interpolateType != Interpolate.NearestNeighbor) continue;
                    for (int jjj = 0; jjj < i; ++jjj) {
                        i2[jjj] = ii1;
                    }
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 < i - 1) {
                    if (ii1 <= -1) continue;
                    i1[i] = -1;
                    i2[i] = -1;
                    ii2 = i;
                    for (int ii = ii1 + 1; ii < i; ++ii) {
                        i1[ii] = ii1;
                        i2[ii] = ii2;
                    }
                    ii1 = i;
                    continue;
                }
                i1[i] = -1;
                i2[i] = -1;
            }
            if (interpolateType == Interpolate.NearestNeighbor && ii1 > -1) {
                for (int jjj = ii1; jjj < nx; ++jjj) {
                    i1[jjj] = ii1;
                }
            }
            if (interpolateType == Interpolate.NearestNeighbor) {
                for (i = 0; i < nx; ++i) {
                    double d = i1[i] == -1 ? Double.MAX_VALUE : xTags[i] - xTagMin[i1[i]];
                    double d2 = i2[i] == -1 ? Double.MAX_VALUE : xTagMax[i2[i]] - xTags[i];
                    if (!(Math.min(d, d2) < xSampleWidth / 2.0)) continue;
                    int idx = -1;
                    if (i1[i] == -1) {
                        if (i2[i] == -1) continue;
                        idx = i2[i];
                    } else {
                        idx = i2[i] == -1 ? i1[i] : ((a2 = (xTags[i] - xTagMax[i1[i]]) / (xTagMin[i2[i]] - xTags[i1[i]])) < 0.5 ? i1[i] : i2[i]);
                    }
                    data[i][j] = data[idx][j];
                    weights[i][j] = weights[idx][j];
                }
                continue;
            }
            for (i = 0; i < nx; ++i) {
                if (i1[i] <= -1 || i2[i] <= -1 || !(xTagMin[i2[i]] - xTagMax[i1[i]] <= xSampleWidth * 1.5)) continue;
                a2 = (xTags[i] - xTagMax[i1[i]]) / (xTagMin[i2[i]] - xTags[i1[i]]);
                double a1 = 1.0 - a2;
                data[i][j] = data[i1[i]][j] * a1 + data[i2[i]][j] * a2;
                weights[i][j] = weights[i1[i]][j] * a1 + weights[i2[i]][j] * a2;
            }
        }
    }

    static void fillInterpolateY(double[][] data, double[][] weights, RebinDescriptor ddY, Datum yTagWidth, Interpolate interpolateType) {
        double ySampleWidth;
        double d;
        int j;
        int nx = data.length;
        int ny = ddY.numberOfBins();
        int[] i1 = new int[ny];
        int[] i2 = new int[ny];
        double[] yTagTemp = new double[ddY.numberOfBins()];
        double[] yTags = ddY.binCenters();
        Units yTagUnits = ddY.getUnits();
        boolean log = ddY.isLog();
        if (log) {
            for (j = 0; j < ny; ++j) {
                yTagTemp[j] = Math.log(yTags[j]);
            }
        } else {
            for (j = 0; j < ny; ++j) {
                yTagTemp[j] = yTags[j];
            }
        }
        double fudge = 1.5;
        if (interpolateType == Interpolate.NearestNeighbor) {
            fudge = 1.1;
        }
        if (yTagWidth == null) {
            ySampleWidth = d = 4.4942328371557893E307;
        } else if (UnitsUtil.isRatiometric(yTagWidth.getUnits())) {
            double p = yTagWidth.doubleValue(Units.logERatio);
            ySampleWidth = p * fudge;
        } else {
            d = yTagWidth.doubleValue(yTagUnits.getOffsetUnits());
            ySampleWidth = d * fudge;
        }
        for (int i = 0; i < nx; ++i) {
            double a2;
            int j2;
            int ii1 = -1;
            int ii2 = -1;
            for (j2 = 0; j2 < ny; ++j2) {
                if (weights[i][j2] > 0.0 && ii1 == j2 - 1) {
                    i1[j2] = -1;
                    i2[j2] = -1;
                    ii1 = j2;
                    continue;
                }
                if (weights[i][j2] > 0.0 && ii1 == -1) {
                    i1[j2] = -1;
                    i2[j2] = -1;
                    ii1 = j2;
                    if (interpolateType != Interpolate.NearestNeighbor) continue;
                    for (int jjj = 0; jjj < j2; ++jjj) {
                        i2[jjj] = ii1;
                    }
                    continue;
                }
                if (weights[i][j2] > 0.0 && ii1 < j2 - 1) {
                    if (ii1 <= -1) continue;
                    i1[j2] = -1;
                    i2[j2] = -1;
                    ii2 = j2;
                    for (int jj = j2 - 1; jj >= ii1; --jj) {
                        i1[jj] = ii1;
                        i2[jj] = ii2;
                    }
                    ii1 = j2;
                    continue;
                }
                i1[j2] = -1;
                i2[j2] = -1;
            }
            if (interpolateType == Interpolate.NearestNeighbor && ii1 > -1) {
                for (int jjj = ii1; jjj < ny; ++jjj) {
                    i1[jjj] = ii1;
                }
            }
            if (interpolateType == Interpolate.NearestNeighbor) {
                for (j2 = 0; j2 < ny; ++j2) {
                    boolean doInterp;
                    if (i1[j2] != -1 && i2[j2] != -1) {
                        doInterp = yTagTemp[i2[j2]] - yTagTemp[i1[j2]] < ySampleWidth * 2.0;
                    } else {
                        boolean bl = doInterp = Math.min(i1[j2] == -1 ? Double.MAX_VALUE : yTagTemp[j2] - yTagTemp[i1[j2]], i2[j2] == -1 ? Double.MAX_VALUE : yTagTemp[i2[j2]] - yTagTemp[j2]) < ySampleWidth / 2.0;
                    }
                    if (doInterp) {
                        int idx = i1[j2] == -1 ? i2[j2] : (i2[j2] == -1 ? i1[j2] : ((a2 = (yTagTemp[j2] - yTagTemp[i1[j2]]) / (yTagTemp[i2[j2]] - yTagTemp[i1[j2]])) < 0.5 ? i1[j2] : i2[j2]));
                        data[i][j2] = data[i][idx];
                        weights[i][j2] = weights[i][idx];
                    }
                    if (i != 1 || j2 != 34) continue;
                    boolean jkk = false;
                }
                continue;
            }
            for (j2 = 0; j2 < ny; ++j2) {
                if (i1[j2] == -1 || !(yTagTemp[i2[j2]] - yTagTemp[i1[j2]] < ySampleWidth) && i2[j2] - i1[j2] != 2) continue;
                a2 = (yTagTemp[j2] - yTagTemp[i1[j2]]) / (yTagTemp[i2[j2]] - yTagTemp[i1[j2]]);
                double a1 = 1.0 - a2;
                data[i][j2] = data[i][i1[j2]] * a1 + data[i][i2[j2]] * a2;
                weights[i][j2] = weights[i][i1[j2]] * a1 + weights[i][i2[j2]] * a2;
            }
        }
    }

    private void enlargePixels(double[][] rebinData, double[][] rebinWeights) {
        int enlargeSize = 5;
        for (int aa = 0; aa < enlargeSize; ++aa) {
            int ii;
            int jj;
            int jj2;
            int ii2;
            for (ii2 = 0; ii2 < rebinData.length - 1; ++ii2) {
                for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                    if (rebinWeights[ii2][jj2] != 0.0) continue;
                    rebinData[ii2][jj2] = rebinData[ii2 + 1][jj2];
                    rebinWeights[ii2][jj2] = rebinWeights[ii2 + 1][jj2];
                }
            }
            for (ii2 = rebinData.length - 1; ii2 > 0; --ii2) {
                for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                    if (rebinWeights[ii2][jj2] != 0.0) continue;
                    rebinData[ii2][jj2] = rebinData[ii2 - 1][jj2];
                    rebinWeights[ii2][jj2] = rebinWeights[ii2 - 1][jj2];
                }
            }
            for (jj = 0; jj < rebinData[0].length - 1; ++jj) {
                for (ii = 0; ii < rebinData.length; ++ii) {
                    if (rebinWeights[ii][jj] != 0.0) continue;
                    rebinData[ii][jj] = rebinData[ii][jj + 1];
                    rebinWeights[ii][jj] = rebinWeights[ii][jj + 1];
                }
            }
            for (jj = rebinData[0].length - 1; jj > 0; --jj) {
                for (ii = 0; ii < rebinData.length; ++ii) {
                    if (rebinWeights[ii][jj] != 0.0) continue;
                    rebinData[ii][jj] = rebinData[ii][jj - 1];
                    rebinWeights[ii][jj] = rebinWeights[ii][jj - 1];
                }
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setEnlargePixels(boolean enlargePixels) {
        this.enlargePixels = enlargePixels;
    }

    public boolean isEnlargePixels() {
        return this.enlargePixels;
    }

    public Interpolate getInterpolateType() {
        return this.interpolateType;
    }

    public void setInterpolateType(Interpolate interpolateType) {
        Interpolate oldInterpolateType = this.interpolateType;
        this.interpolateType = interpolateType;
        this.propertyChangeSupport.firePropertyChange(PROP_INTERPOLATETYPE, (Object)oldInterpolateType, (Object)interpolateType);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpolate {
        None,
        Linear,
        NearestNeighbor;

    }
}

