/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.PeakTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class AveragePeakTableRebinner
implements DataSetRebinner {
    private boolean debug = false;

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException {
        Object yTags;
        int i;
        double[] xTagMax;
        double[] xTagMin;
        double[] xTags;
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tds = (TableDataSet)ds;
        if (ddY == null && tds.tableCount() == 0) {
            throw new IllegalArgumentException("empty table and null RebinDescriptor for Y, so result YTags are undefined.");
        }
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        TableDataSet peaks = (TableDataSet)ds.getPlanarView("peaks");
        long timer = System.currentTimeMillis();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        double[][] averageData = new double[nx][ny];
        double[][] averageWeights = new double[nx][ny];
        double[][] peakData = new double[nx][ny];
        AverageTableRebinner.average(tds, weights, averageData, averageWeights, ddX, ddY);
        if (ddX != null) {
            xTags = ddX.binCenters();
            xTagMin = ddX.binStops();
            xTagMax = ddX.binStarts();
            for (i = 0; i < tds.getXLength(); ++i) {
                double xt = tds.getXTagDouble(i, tds.getXUnits());
                int ibin = ddX.whichBin(xt, tds.getXUnits());
                if (ibin <= -1 || ibin >= nx) continue;
                xTagMin[ibin] = Math.min(xTagMin[ibin], xt);
                xTagMax[ibin] = Math.max(xTagMax[ibin], xt);
            }
        } else {
            xTags = new double[nx];
            for (i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
            xTagMin = xTags;
            xTagMax = xTags;
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        Datum xTagWidth = DataSetUtil.guessXTagWidth(ds);
        double xTagWidthDouble = xTagWidth.doubleValue(ddX.getUnits().getOffsetUnits());
        AverageTableRebinner.fillInterpolateX(averageData, averageWeights, xTags, xTagMin, xTagMax, xTagWidthDouble, AverageTableRebinner.Interpolate.Linear);
        if (ddY != null) {
            Datum yTagWidth = (Datum)ds.getProperty("yTagWidth");
            AverageTableRebinner.fillInterpolateY(averageData, averageWeights, ddY, yTagWidth, AverageTableRebinner.Interpolate.Linear);
        }
        if (peaks == null) {
            PeakTableRebinner.peaks(tds, peakData, ddX, ddY);
        } else {
            PeakTableRebinner.peaks(peaks, peakData, ddX, ddY);
        }
        HashMap<String, Datum> properties = new HashMap<String, Datum>(ds.getProperties());
        if (ddX != null) {
            properties.put("xTagWidth", ddX.binWidthDatum());
        }
        if (ddY != null) {
            properties.put("yTagWidth", ddY.binWidthDatum());
        }
        int[] tableOffsets = new int[]{0};
        String[] planeIDs = new String[]{"", "peaks", "weights"};
        double[][][] zValues = new double[][][]{averageData, peakData, averageWeights};
        Units[] zUnits = new Units[]{tds.getZUnits(), tds.getZUnits(), Units.dimensionless};
        return new DefaultTableDataSet(xTags, tds.getXUnits(), (double[][])yTags, tds.getYUnits(), (double[][][])zValues, zUnits, planeIDs, tableOffsets, (Map)properties);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

