/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.das2.components.propertyeditor.Displayable;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetCache;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.datum.Datum;
import org.das2.system.DasLogger;

public abstract class AbstractDataSetCache
implements DataSetCache {
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    public int hits = 0;
    public int misses = 0;

    public abstract void store(DataSetDescriptor var1, CacheTag var2, DataSet var3);

    abstract boolean haveStoredImpl(DataSetDescriptor var1, CacheTag var2);

    public boolean haveStored(DataSetDescriptor dsd, CacheTag cacheTag) {
        boolean result = this.haveStoredImpl(dsd, cacheTag);
        if (result) {
            logger.fine("cache hit " + dsd + " " + cacheTag);
            ++this.hits;
        } else {
            logger.fine("cache miss " + dsd + " " + cacheTag);
            ++this.misses;
        }
        return result;
    }

    protected long cacheValue(Entry e) {
        return e.lastAccess;
    }

    abstract DataSet retrieveImpl(DataSetDescriptor var1, CacheTag var2);

    public DataSet retrieve(DataSetDescriptor dsd, CacheTag cacheTag) {
        return this.retrieveImpl(dsd, cacheTag);
    }

    public abstract void reset();

    public DataSet coalese(List result) {
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Entry)o1).cacheTag.range.compareTo(((Entry)o2).cacheTag.range);
            }
        });
        Entry e0 = (Entry)result.get(0);
        CacheTag ct = e0.cacheTag;
        Datum t1 = ct.range.max();
        Datum resolution = ct.resolution;
        DataSet ds = e0.data;
        for (int i = 1; i < result.size(); ++i) {
            Entry entryTest = (Entry)result.get(i);
            CacheTag ctTest = entryTest.cacheTag;
            if (!ctTest.range.min().equals(t1) || (ct.resolution != null || ctTest.resolution != null) && !ct.resolution.equals(ctTest.resolution)) continue;
            ds = DataSetUtil.append(ds, entryTest.data);
            t1 = ctTest.range.max();
        }
        return ds;
    }

    public boolean isResetCache() {
        return false;
    }

    public void setResetCache(boolean resetCache) {
        if (resetCache) {
            this.reset();
        }
    }

    protected class Entry
    implements Displayable {
        protected DataSetDescriptor dsd;
        protected CacheTag cacheTag;
        protected DataSet data;
        protected int nhits;
        protected long birthTime;
        protected long lastAccess;

        Entry() {
            this(null, null, null);
        }

        Entry(DataSetDescriptor dsd, CacheTag cacheTag, DataSet data) {
            this.dsd = dsd;
            this.cacheTag = cacheTag;
            this.data = data;
            this.nhits = 0;
            this.lastAccess = this.birthTime = System.currentTimeMillis();
        }

        protected DataSet getData() {
            this.lastAccess = System.currentTimeMillis();
            return this.data;
        }

        protected boolean satifies(Entry entry) {
            boolean result = this.dsd != null && entry.dsd != null;
            result = result && this.dsd.equals(entry.dsd);
            result = result && this.cacheTag.contains(entry.cacheTag);
            return result;
        }

        public String toString() {
            long sizeBytes = DataSetUtil.guessSizeBytes(this.data);
            String sizeBytesString = " (" + NumberFormat.getIntegerInstance().format(sizeBytes) + " bytes)";
            return this.dsd.toString() + " " + this.cacheTag + " [" + this.nhits + " hits]" + sizeBytesString;
        }

        public Icon getListIcon() {
            return null;
        }

        public String getListLabel() {
            return this.toString();
        }

        public CacheTag getCacheTag() {
            return this.cacheTag;
        }
    }
}

