/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public abstract class AbstractDataSet
implements DataSet {
    private Map properties;
    private double[] xTags;
    private Units xUnits;
    private Units yUnits;

    protected AbstractDataSet(double[] xTags, Units xUnits, Units yUnits, Map properties) throws IllegalArgumentException {
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            if (i.next() instanceof String) continue;
            throw new IllegalArgumentException("Non-String key found in property map");
        }
        this.properties = new HashMap(properties);
        this.xTags = (double[])xTags.clone();
        this.xUnits = xUnits;
        this.yUnits = yUnits;
    }

    private AbstractDataSet() {
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }

    public int getXLength() {
        return this.xTags.length;
    }

    public Datum getXTagDatum(int i) {
        return Datum.create(this.xTags[i], this.getXUnits());
    }

    public double getXTagDouble(int i, Units units) {
        double xTag = this.xTags[i];
        xTag = this.getXUnits().getConverter(units).convert(xTag);
        return xTag;
    }

    public int getXTagInt(int i, Units units) {
        return (int)Math.round(this.getXTagDouble(i, units));
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    protected abstract class ViewDataSet
    extends AbstractDataSet
    implements DataSet {
        protected ViewDataSet() {
        }

        public Object getProperty(String name) {
            return AbstractDataSet.this.properties.get(name);
        }

        public Map getProperties() {
            return new HashMap(AbstractDataSet.this.properties);
        }

        public int getXLength() {
            return AbstractDataSet.this.xTags.length;
        }

        public Datum getXTagDatum(int i) {
            return Datum.create(AbstractDataSet.this.xTags[i], this.getXUnits());
        }

        public double getXTagDouble(int i, Units units) {
            double xTag = AbstractDataSet.this.xTags[i];
            xTag = this.getXUnits().getConverter(units).convert(xTag);
            return xTag;
        }

        public int getXTagInt(int i, Units units) {
            return (int)Math.round(this.getXTagDouble(i, units));
        }

        public Units getXUnits() {
            return AbstractDataSet.this.xUnits;
        }

        public Units getYUnits() {
            return AbstractDataSet.this.yUnits;
        }
    }
}

