/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.dasml.FormButton;
import org.das2.dasml.FormCheckBox;
import org.das2.dasml.FormChoice;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormList;
import org.das2.dasml.FormPanel;
import org.das2.dasml.FormRadioButton;
import org.das2.dasml.FormRadioButtonGroup;
import org.das2.dasml.FormTab;
import org.das2.dasml.FormText;
import org.das2.dasml.FormTextField;
import org.das2.dasml.FormWindow;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class TransferableFormComponent
implements Transferable {
    public static final DataFlavor COMPONENT_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormComponent");
    public static final DataFlavor PANEL_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormPanel");
    public static final DataFlavor TEXT_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormText");
    public static final DataFlavor TEXTFIELD_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormTextField");
    public static final DataFlavor BUTTON_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormButton");
    public static final DataFlavor CHECKBOX_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormCheckBox");
    public static final DataFlavor BUTTONGROUP_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormRadioButtonGroup");
    public static final DataFlavor RADIOBUTTON_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormRadioButton");
    public static final DataFlavor TAB_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormTab");
    public static final DataFlavor CHOICE_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormChoice");
    public static final DataFlavor LIST_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormList");
    public static final DataFlavor WINDOW_FLAVOR = TransferableFormComponent.createJVMLocalDataFlavor("org.das2.dasml.FormWindow");
    public static final DataFlavor DASML_FRAGMENT_FLAVOR;
    private final FormComponent formComponent;
    private final DataFlavor moreSpecificDataFlavor;
    private DataFlavor[] flavorList;

    public TransferableFormComponent(FormPanel panel) {
        this.formComponent = panel;
        this.moreSpecificDataFlavor = PANEL_FLAVOR;
    }

    public TransferableFormComponent(FormText text) {
        this.formComponent = text;
        this.moreSpecificDataFlavor = TEXT_FLAVOR;
    }

    public TransferableFormComponent(FormTextField textField) {
        this.formComponent = textField;
        this.moreSpecificDataFlavor = TEXTFIELD_FLAVOR;
    }

    public TransferableFormComponent(FormButton button) {
        this.formComponent = button;
        this.moreSpecificDataFlavor = BUTTON_FLAVOR;
    }

    public TransferableFormComponent(FormCheckBox checkBox) {
        this.formComponent = checkBox;
        this.moreSpecificDataFlavor = CHECKBOX_FLAVOR;
    }

    public TransferableFormComponent(FormRadioButtonGroup buttonGroup) {
        this.formComponent = buttonGroup;
        this.moreSpecificDataFlavor = BUTTONGROUP_FLAVOR;
    }

    public TransferableFormComponent(FormRadioButton radioButton) {
        this.formComponent = radioButton;
        this.moreSpecificDataFlavor = RADIOBUTTON_FLAVOR;
    }

    public TransferableFormComponent(FormTab form) {
        this.formComponent = form;
        this.moreSpecificDataFlavor = TAB_FLAVOR;
    }

    public TransferableFormComponent(FormChoice choice) {
        this.formComponent = choice;
        this.moreSpecificDataFlavor = CHOICE_FLAVOR;
    }

    public TransferableFormComponent(FormList list) {
        this.formComponent = list;
        this.moreSpecificDataFlavor = LIST_FLAVOR;
    }

    public TransferableFormComponent(FormWindow window) {
        this.formComponent = window;
        this.moreSpecificDataFlavor = WINDOW_FLAVOR;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.moreSpecificDataFlavor) || flavor.equals(COMPONENT_FLAVOR)) {
            return this.formComponent;
        }
        if (flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DASML_FRAGMENT_FLAVOR)) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                document.appendChild(this.formComponent.getDOMElement(document));
                StringWriter writer = new StringWriter();
                DOMImplementationLS ls = (DOMImplementationLS)document.getFeature("LS", "3.0");
                LSOutput output = ls.createLSOutput();
                output.setEncoding("UTF-8");
                output.setCharacterStream(writer);
                LSSerializer serializer = ls.createLSSerializer();
                serializer.write(document, output);
                return writer.toString();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.flavorList == null) {
            this.flavorList = new DataFlavor[]{this.moreSpecificDataFlavor, COMPONENT_FLAVOR, DASML_FRAGMENT_FLAVOR, DataFlavor.stringFlavor};
        }
        return this.flavorList;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(COMPONENT_FLAVOR) || flavor.equals(this.moreSpecificDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    private static DataFlavor createJVMLocalDataFlavor(String classname) {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=" + classname;
            return new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    static {
        try {
            DASML_FRAGMENT_FLAVOR = new DataFlavor("x-text/dasml-fragment;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

