/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.das2.components.propertyeditor.PropertyTreeNode;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;

public class PeerPropertyTreeNode
implements PropertyTreeNodeInterface {
    PeerPropertyTreeNode parent;
    PropertyTreeNode leader;
    PropertyTreeNode[] peers;

    public PeerPropertyTreeNode(PeerPropertyTreeNode parent, PropertyTreeNode leader, PropertyTreeNode[] peers) {
        this.parent = parent;
        this.leader = leader;
        this.peers = peers;
    }

    public Enumeration children() {
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < PeerPropertyTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return PeerPropertyTreeNode.this.getChildAt(this.index++);
            }
        };
    }

    public boolean getAllowsChildren() {
        return this.leader.getAllowsChildren();
    }

    public TreeNode getChildAt(int childIndex) {
        PropertyTreeNode[] peerChildren = new PropertyTreeNode[this.peers.length];
        for (int i = 0; i < this.peers.length; ++i) {
            peerChildren[i] = (PropertyTreeNode)this.peers[i].getChildAt(childIndex);
        }
        return new PeerPropertyTreeNode(this, (PropertyTreeNode)this.leader.getChildAt(childIndex), peerChildren);
    }

    public int getChildCount() {
        return this.leader.getChildCount();
    }

    public Class getColumnClass(int columnIndex) {
        return this.leader.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return this.leader.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.leader.getColumnName(columnIndex);
    }

    public int getIndex(TreeNode node) {
        return this.leader.getIndex(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.leader.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + column);
    }

    public boolean isCellEditable(int column) {
        return this.leader.isCellEditable(column);
    }

    public boolean isDirty() {
        return this.leader.isDirty();
    }

    public boolean isLeaf() {
        return this.leader.isLeaf();
    }

    public void refresh() {
        this.leader.refresh();
    }

    public void setValueAt(Object value, int column) {
        switch (column) {
            case 0: {
                throw new IllegalArgumentException("Cell is not editable");
            }
            case 1: {
                this.setValue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such column: " + column);
            }
        }
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setTreeModel(treeModel);
        }
        this.leader.setTreeModel(treeModel);
    }

    public Object getValue() {
        return this.leader.getValue();
    }

    public Object getDisplayValue() {
        Object value = this.leader.getDisplayValue();
        boolean warn = false;
        for (int i = 0; i < this.peers.length; ++i) {
            Object peerValue = this.peers[i].getDisplayValue();
            if (peerValue != null) {
                if (this.peers[i].getDisplayValue().equals(value)) continue;
                warn = true;
                continue;
            }
            if (value == null) continue;
            warn = true;
        }
        return value;
    }

    public void flush() {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].flush();
        }
        this.leader.flush();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.leader.getPropertyDescriptor();
    }

    public String toString() {
        return this.leader.getDisplayName() + " ++";
    }

    public void setValue(Object value) {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setValue(value);
        }
        this.leader.setValue(value);
    }
}

