/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DocumentFilter;
import org.das2.components.propertyeditor.FloatingPointDocumentFilter;

class FloatingPointFormatter
extends JFormattedTextField.AbstractFormatter {
    FloatingPointFormatter() {
    }

    public Object stringToValue(String text) throws ParseException {
        try {
            Double d = new Double(text);
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == Double.NaN) {
                throw new ParseException("+/-infinity and NaN are not allowed", 0);
            }
            return d;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(nfe.getMessage(), 0);
        }
    }

    public String valueToString(Object value) throws ParseException {
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            return value.toString();
        }
        throw new ParseException("value must be of type Number", 0);
    }

    protected DocumentFilter getDocumentFilter() {
        return new FloatingPointDocumentFilter();
    }
}

