/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.das2.components.propertyeditor.ColorCellRenderer;

public class ColorEditor
extends AbstractCellEditor
implements PropertyEditor,
TableCellEditor {
    private static List colors = new ArrayList();
    private JColorChooser custom;
    private PropertyEditorSupport editorSupport = new PropertyEditorSupport(this){};
    private JComboBox choice;

    public ColorEditor() {
        this.custom = new JColorChooser();
        this.choice = new JComboBox(new ColorChoiceModel()){

            public void setBounds(int x, int y, int width, int height) {
                Dimension preferred = this.getPreferredSize();
                super.setBounds(x, y, width, preferred.height);
            }
        };
        this.choice.setRenderer(new ColorCellRenderer());
        this.choice.setBorder(null);
        this.choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ColorEditor.this.choice.isDisplayable()) {
                    ColorEditor.this.stopCellEditing();
                }
            }
        });
        this.custom.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ColorEditor.this.setValue(e.getNewValue());
            }
        });
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getAsText() {
        int rgb = ((Color)this.editorSupport.getValue()).getRGB();
        String hex = rgb == 0 ? "#000000" : "#" + Integer.toHexString(rgb).substring(2);
        return hex;
    }

    public Component getCustomEditor() {
        Color c = (Color)this.getValue();
        this.custom.setColor(c);
        return this.custom;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.editorSupport.addPropertyChangeListener(l);
    }

    public Object getCellEditorValue() {
        return this.editorSupport.getValue();
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.editorSupport.getValue();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.editorSupport.removePropertyChangeListener(l);
    }

    public void setAsText(String str) throws IllegalArgumentException {
        Color c = Color.decode(str);
        this.setValue(c);
    }

    public void setValue(Object obj) {
        Object oldValue = this.editorSupport.getValue();
        this.editorSupport.setValue(obj);
        if (oldValue != obj) {
            this.choice.setSelectedItem(obj);
            this.choice.repaint();
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        this.setValue(value);
        this.choice.setSelectedItem(value);
        this.choice.setForeground(table.getForeground());
        this.choice.setBackground(table.getBackground());
        return this.choice;
    }

    public Component getSmallEditor() {
        this.choice.setSelectedItem(this.getValue());
        return this.choice;
    }

    static {
        colors.add(Color.BLACK);
        colors.add(Color.WHITE);
        colors.add(Color.BLUE);
        colors.add(Color.CYAN);
        colors.add(Color.DARK_GRAY);
        colors.add(Color.GRAY);
        colors.add(Color.GREEN);
        colors.add(Color.LIGHT_GRAY);
        colors.add(Color.MAGENTA);
        colors.add(Color.ORANGE);
        colors.add(Color.PINK);
        colors.add(Color.RED);
        colors.add(Color.YELLOW);
        colors.add(new Color(0, true));
    }

    private class ColorChoiceModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final String CUSTOM_LABEL = "custom...";

        private ColorChoiceModel() {
        }

        public Object getElementAt(int index) {
            if (index < colors.size()) {
                return colors.get(index);
            }
            if (index == colors.size()) {
                return "custom...";
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        public Object getSelectedItem() {
            return ColorEditor.this.getValue();
        }

        public int getSize() {
            return colors.size() + 1;
        }

        public void setSelectedItem(Object obj) {
            if (obj instanceof Color) {
                ColorEditor.this.setValue(obj);
            } else if ("custom...".equals(obj)) {
                ColorEditor.this.custom;
                Color c = JColorChooser.showDialog(ColorEditor.this.choice, "Color Editor", (Color)ColorEditor.this.getValue());
                if (c != null) {
                    ColorEditor.this.setValue(c);
                }
            } else {
                throw new IllegalArgumentException(String.valueOf(obj));
            }
        }
    }
}

