/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class ColorCellRenderer
implements ListCellRenderer,
TableCellRenderer,
Icon {
    private static Map names = new HashMap();
    private JLabel label;
    private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Color iconColor;

    ColorCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Color f = isSelected ? table.getSelectionForeground() : table.getForeground();
        Color b = isSelected ? table.getSelectionBackground() : table.getBackground();
        return this.getLabel(table, f, b, value, isSelected, hasFocus);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        Color f = isSelected ? list.getSelectionForeground() : list.getForeground();
        Color b = isSelected ? list.getSelectionBackground() : list.getBackground();
        return this.getLabel(list, f, b, value, isSelected, hasFocus);
    }

    public Component getLabel(JComponent c, Color f, Color b, Object value, boolean isSelected, boolean hasFocus) {
        this.initLabel();
        this.label.setForeground(f);
        this.label.setBackground(b);
        this.label.setEnabled(c.isEnabled());
        this.label.setFont(c.getFont());
        this.label.setBorder(hasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
        if (value instanceof Color) {
            String name = (String)names.get(value);
            if (name == null) {
                name = ((Color)value).getAlpha() == 0 ? "none" : ColorCellRenderer.toString((Color)value);
            }
            this.label.setIcon(this);
            this.label.setText(name);
            this.iconColor = (Color)value;
        } else {
            this.label.setIcon(null);
            this.label.setText(String.valueOf(value));
        }
        return this.label;
    }

    private static String toString(Color c) {
        return "[" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]";
    }

    private void initLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBorder(this.noFocusBorder);
        }
    }

    public int getIconHeight() {
        return 16;
    }

    public int getIconWidth() {
        return 16;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color save = g.getColor();
        if (this.iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(x + i * 4, y + j * 4, 4, 4);
                }
            }
        }
        g.setColor(this.iconColor);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        g.setColor(save);
    }

    static {
        names.put(Color.BLACK, "black");
        names.put(Color.WHITE, "white");
        names.put(Color.BLUE, "blue");
        names.put(Color.CYAN, "cyan");
        names.put(Color.DARK_GRAY, "dark gray");
        names.put(Color.GRAY, "gray");
        names.put(Color.GREEN, "green");
        names.put(Color.LIGHT_GRAY, "light gray");
        names.put(Color.MAGENTA, "magenta");
        names.put(Color.ORANGE, "orange");
        names.put(Color.PINK, "pink");
        names.put(Color.RED, "red");
        names.put(Color.YELLOW, "yellow");
    }
}

