/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DasUpdateEvent;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.SymbolLineRenderer;

public class HorizontalSpectrogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private Datum xValue;
    private SymbolLineRenderer renderer;
    private DasPlot parentPlot;

    private HorizontalSpectrogramSlicer(DasPlot plot, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.parentPlot = plot;
        this.renderer = new SymbolLineRenderer();
        this.addRenderer(this.renderer);
    }

    public static HorizontalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceXAxis = plot.getXAxis();
        DasAxis xAxis = sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = dataSetConsumer.getZAxis().createAttachedAxis(3);
        return new HorizontalSpectrogramSlicer(plot, xAxis, yAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    HorizontalSpectrogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HorizontalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Horizontal Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y + height);
    }

    public void dataPointSelected(DataPointSelectionEvent e) {
        DataSet ds = e.getDataSet();
        if (ds == null || !(ds instanceof TableDataSet)) {
            return;
        }
        Datum yValue = e.getY();
        this.xValue = e.getX();
        TableDataSet tds = (TableDataSet)ds;
        int itable = TableUtil.tableIndexAt(tds, DataSetUtil.closestColumn(tds, e.getX()));
        VectorDataSet sliceDataSet = tds.getYSlice(TableUtil.closestRow(tds, itable, e.getY()), itable);
        this.renderer.setDataSet(sliceDataSet);
        DatumFormatter formatter = this.xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : this.xValue.getFormatter();
        this.setTitle("x: " + formatter.format(this.xValue) + " y: " + yValue);
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        }
    }

    public void drawContent(Graphics2D g) {
        super.drawContent(g);
        int ix = (int)this.getXAxis().transform(this.xValue);
        DasRow row = this.getRow();
        int iy0 = row.getDMinimum();
        int iy1 = row.getDMaximum();
        g.drawLine(ix + 3, iy0, ix, iy0 + 3);
        g.drawLine(ix - 3, iy0, ix, iy0 + 3);
        g.drawLine(ix + 3, iy1, ix, iy1 - 3);
        g.drawLine(ix - 3, iy1, ix, iy1 - 3);
        g.setColor(new Color(230, 230, 230));
        g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void processDasUpdateEvent(DasUpdateEvent e) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }
}

