/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JTextArea;

public class FixedColumnTextArea
extends JTextArea {
    int[] cols;
    int[] colPixel;
    String spaces;

    public FixedColumnTextArea() {
        this.setFont(Font.decode("courier-12"));
        this.setLineWrap(false);
        StringBuffer spacesBuf = new StringBuffer(500);
        for (int i = 0; i < 500; ++i) {
            spacesBuf.append(' ');
        }
        this.spaces = spacesBuf.toString();
    }

    public void setColumnDivider(int col) {
        this.setColumnDividers(new int[]{col});
    }

    public void setColumnDividers(int[] col) {
        this.cols = col;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.colPixel = new int[col.length];
        for (int i = 0; i < col.length; ++i) {
            int ix;
            this.colPixel[i] = ix = fm.stringWidth(this.spaces.substring(0, this.cols[i]));
        }
    }

    public int columnAt(int pixelX) {
        for (int i = 1; i < this.cols.length; ++i) {
            if (pixelX >= this.colPixel[i]) continue;
            return i - 1;
        }
        return this.cols.length - 1;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        int leftMargin = 4;
        g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.1f));
        if (this.cols != null) {
            for (int i = 0; i < this.cols.length; ++i) {
                int ix = this.colPixel[i];
                g.drawLine(ix, 0, ix, this.getHeight());
            }
        }
    }
}

