/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class FavoritesSelector {
    List favoritesList = new ArrayList();
    String favoritesType;
    FavoritesListener listener = null;
    ActionListener actionListener;
    JPopupMenu popupMenu;
    boolean nextSelectionDeletes = false;

    private FavoritesSelector(String _favoritesType) {
        this.favoritesType = _favoritesType;
        this.readFromPersistentPrefs();
    }

    public void addFavoritesListener(FavoritesListener _listener) {
        if (this.listener != null) {
            throw new IllegalArgumentException("only one listener supported");
        }
        this.listener = _listener;
    }

    public ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        String cmd = ev.getActionCommand();
                        System.out.println(cmd);
                        if (cmd.equals("delete")) {
                            FavoritesSelector.this.popupMenu.setVisible(true);
                            FavoritesSelector.this.nextSelectionDeletes = true;
                        } else if (cmd.equals("add")) {
                            Object o;
                            if (FavoritesSelector.this.listener != null && (o = FavoritesSelector.this.listener.addFavoriteSelected()) != null) {
                                FavoritesSelector.this.addFavorite(o);
                            }
                        } else if (FavoritesSelector.this.nextSelectionDeletes) {
                            FavoritesSelector.this.removeFavorite(FavoritesSelector.this.favoritesList.get(Integer.parseInt(cmd)));
                            FavoritesSelector.this.nextSelectionDeletes = false;
                        } else {
                            FavoritesSelector.this.listener.itemSelected(FavoritesSelector.this.favoritesList.get(Integer.parseInt(cmd)));
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return this.actionListener;
    }

    private void resetPopupMenu() {
        JPopupMenu pm = this.getMenu();
        JMenuItem item = this.popupMenu.add("Add to favorites");
        item.setActionCommand("add");
        item.addActionListener(this.getActionListener());
        for (int i = 0; i < this.favoritesList.size(); ++i) {
            item = this.popupMenu.add(this.favoritesList.get(i).toString());
            item.setActionCommand("" + i);
            item.addActionListener(this.getActionListener());
        }
        item = this.popupMenu.add("Add to favorites");
        item.setActionCommand("delete");
        item.addActionListener(this.getActionListener());
    }

    public JPopupMenu getMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.resetPopupMenu();
        }
        return this.popupMenu;
    }

    private void resetMenuActionCommands() {
        MenuElement[] items = this.popupMenu.getSubElements();
        for (int i = 1; i < items.length - 2; ++i) {
            ((JMenuItem)items[i]).setActionCommand("" + (i - 1));
        }
    }

    public void addFavorite(Object o) {
        String s = o.toString();
        if (s.indexOf(";;") != -1) {
            throw new IllegalArgumentException("o.toString() contains ;;");
        }
        this.favoritesList.add(o);
        JMenuItem item = new JMenuItem(o.toString());
        item.addActionListener(this.getActionListener());
        if (this.popupMenu != null) {
            this.popupMenu.add((Component)item, this.favoritesList.size() + 1);
            this.resetMenuActionCommands();
        }
        this.writeToPersistentPrefs();
    }

    public void removeFavorite(Object o) {
        int index = this.favoritesList.indexOf(o);
        this.favoritesList.remove(index);
        if (this.popupMenu != null) {
            this.popupMenu.remove(index + 1);
            this.resetMenuActionCommands();
        }
        this.writeToPersistentPrefs();
    }

    public void removeAll() {
        int i;
        Object[] objs = new Object[this.favoritesList.size()];
        for (i = 0; i < this.favoritesList.size(); ++i) {
            objs[i] = this.favoritesList.get(i);
        }
        for (i = 0; i < objs.length; ++i) {
            this.removeFavorite(objs[i]);
        }
    }

    private void readFromPersistentPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(FavoritesSelector.class);
        String listString = prefs.get(this.favoritesType, "");
        String[] itemsString = listString.split(";;");
        this.favoritesList.clear();
        for (int i = 0; i < itemsString.length; ++i) {
            this.favoritesList.add(itemsString[i]);
        }
    }

    private void writeToPersistentPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(FavoritesSelector.class);
        StringBuffer listString = new StringBuffer();
        if (this.favoritesList.size() > 0) {
            listString.append(this.favoritesList.get(0).toString());
        }
        for (int i = 1; i < this.favoritesList.size(); ++i) {
            listString.append(";;" + this.favoritesList.get(i));
        }
        prefs.put(this.favoritesType, listString.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.favoritesList.size();
    }

    public static FavoritesSelector getInstance(String _favoritesType) {
        FavoritesSelector fs = new FavoritesSelector(_favoritesType);
        fs.removeAll();
        fs.addFavorite("Strawberry");
        fs.addFavorite("Bananna");
        fs.addFavorite("Kiwi");
        return fs;
    }

    public static interface FavoritesListener
    extends EventListener {
        public void itemSelected(Object var1);

        public Object addFavoriteSelected();
    }
}

