/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;

public class DatumRangeEditor
extends JComponent
implements PropertyEditor,
TableCellEditor {
    private JTextField editor;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;
    private DatumRange value;
    private EventListenerList listeners;
    private ChangeEvent evt;

    public DatumRangeEditor() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.setFocusable(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        this.editor.setFocusable(false);
        this.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.unitsButton.setToolTipText("units selection");
        this.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener ul = new UniversalListener();
        this.editor.addMouseListener(ul);
        this.unitsButton.addMouseListener(ul);
        this.addKeyListener(ul);
        this.addFocusListener(ul);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setColumns(int columns) {
        this.editor.setColumns(columns);
    }

    public void setValue(Object value) {
        if (!(value instanceof DatumRange)) {
            throw new IllegalArgumentException();
        }
        this.setDatumRange((DatumRange)value);
    }

    private void setDatumRange(DatumRange datumRange) {
        DatumRange oldValue = this.value;
        this.value = datumRange;
        Units u = datumRange.getUnits();
        this.editor.setText(datumRange.toString());
        this.setUnits(u);
        if (oldValue != this.value && oldValue != null && !oldValue.equals(this.value)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setDatumRange(this.parseText(text));
        }
        catch (ParseException pe) {
            IllegalArgumentException iae = new IllegalArgumentException(pe.getMessage());
            iae.initCause(pe);
            throw iae;
        }
    }

    public Object getValue() {
        return this.getDatumRange();
    }

    private DatumRange parseText(String text) throws ParseException {
        DatumRange result = null;
        result = this.units instanceof TimeLocationUnits ? DatumRangeUtil.parseTimeRange(text) : DatumRangeUtil.parseDatumRange(text, this.value);
        return result;
    }

    public DatumRange getDatumRange() {
        try {
            String text = this.editor.getText();
            DatumRange dr = this.parseText(text);
            if (!dr.equals(this.value)) {
                DatumRange oldValue = this.value;
                this.value = dr;
                this.firePropertyChange("value", oldValue, this.value);
            }
            return this.value;
        }
        catch (ParseException e) {
            if (this.value != null) {
                this.setDatumRange(this.value);
                return this.value;
            }
            return null;
        }
    }

    public String getAsText() {
        DatumRange value = this.getDatumRange();
        if (value == null) {
            return null;
        }
        return this.editor.getText();
    }

    public void setUnits(Units units) {
        if (units instanceof TimeLocationUnits) {
            this.unitsButton.setVisible(false);
        } else {
            this.unitsButton.setVisible(true);
            this.unitsButton.setText(units.toString());
            this.unitsButton.setToolTipText("units selection");
        }
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    private void fireActionPerformed() {
        this.setDatumRange(this.getDatumRange());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.unitsButton.getBounds().contains(event.getX(), event.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setValue(value);
        return this;
    }

    public void addCellEditorListener(CellEditorListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        if (this.listeners != null) {
            this.listeners.remove(CellEditorListener.class, l);
        }
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.getDatumRange();
    }

    public boolean stopCellEditing() {
        if (this.getDatumRange() == null) {
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private void fireEditingStopped() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingCanceled(this.evt);
        }
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        public void focusGained(FocusEvent e) {
            DatumRangeEditor.this.editor.getCaret().setVisible(true);
            DatumRangeEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        public void focusLost(FocusEvent e) {
            DatumRangeEditor.this.editor.getCaret().setVisible(false);
            DatumRangeEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DatumRangeEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        private void forwardKeyEvent(KeyEvent e) {
            e.setSource(DatumRangeEditor.this.editor);
            DatumRangeEditor.this.editor.dispatchEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            DatumRangeEditor.this.requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

