/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.das2.datum.Datum;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;

public class DatumEditor
implements PropertyEditor,
TableCellEditor {
    private JTextField editor;
    private JPanel panel;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;
    private Datum value;
    private EventListenerList listeners;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ChangeEvent evt;

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    private synchronized void initGui() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.panel.setFocusable(true);
    }

    private synchronized void maybeInitGui() {
        if (this.panel == null) {
            this.initGui();
        }
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        if (this.value != null) {
            this.setDatum(this.value);
        }
        this.editor.setFocusable(false);
        this.panel.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.unitsButton.setToolTipText("units selection");
        if (this.units != null) {
            this.setUnits(this.units);
        }
        this.panel.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener ul = new UniversalListener();
        this.editor.addMouseListener(ul);
        this.unitsButton.addMouseListener(ul);
        this.panel.addKeyListener(ul);
        this.panel.addFocusListener(ul);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this.panel);
    }

    public void setColumns(int columns) {
        this.editor.setColumns(columns);
    }

    public void setValue(Object value) {
        if (!(value instanceof Datum)) {
            throw new IllegalArgumentException();
        }
        this.setDatum((Datum)value);
    }

    private void setDatum(Datum datum) {
        Datum oldValue = this.value;
        this.value = datum;
        Units u = datum.getUnits();
        if (this.editor != null) {
            if (datum.getUnits() instanceof TimeLocationUnits) {
                this.editor.setText(TimeDatumFormatter.DEFAULT.format(datum, u));
            } else {
                this.editor.setText(datum.getFormatter().format(datum, u));
            }
        }
        this.setUnits(u);
        if (oldValue != this.value && oldValue != null && !oldValue.equals(this.value)) {
            this.pcs.firePropertyChange("value", oldValue, this.value);
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setDatum(this.units.parse(text));
        }
        catch (ParseException pe) {
            IllegalArgumentException iae = new IllegalArgumentException(pe.getMessage());
            iae.initCause(pe);
            throw iae;
        }
    }

    public Object getValue() {
        return this.getDatum();
    }

    public Datum getDatum() {
        try {
            String text;
            Datum d;
            if (this.editor != null && !(d = this.units.parse(text = this.editor.getText())).equals(this.value)) {
                Datum oldValue = this.value;
                this.value = d;
                this.pcs.firePropertyChange("value", oldValue, this.value);
            }
            return this.value;
        }
        catch (ParseException e) {
            if (this.value != null) {
                this.setDatum(this.value);
                return this.value;
            }
            return null;
        }
    }

    public String getAsText() {
        Datum v = this.getDatum();
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public void setUnits(Units units) {
        if (this.unitsButton != null) {
            if (units instanceof TimeLocationUnits) {
                this.unitsButton.setVisible(false);
            } else {
                this.unitsButton.setVisible(true);
                this.unitsButton.setText(units.toString());
                this.unitsButton.setToolTipText("units selection");
            }
        }
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    private void fireActionPerformed() {
        this.setDatum(this.getDatum());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.unitsButton.getBounds().contains(event.getX(), event.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.maybeInitGui();
        return this.panel;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setValue(value);
        this.maybeInitGui();
        return this.panel;
    }

    public void addCellEditorListener(CellEditorListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        if (this.listeners != null) {
            this.listeners.remove(CellEditorListener.class, l);
        }
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.getDatum();
    }

    public boolean stopCellEditing() {
        if (this.getDatum() == null) {
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private void fireEditingStopped() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingCanceled(this.evt);
        }
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        public void focusGained(FocusEvent e) {
            DatumEditor.this.editor.getCaret().setVisible(true);
            DatumEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        public void focusLost(FocusEvent e) {
            DatumEditor.this.editor.getCaret().setVisible(false);
            DatumEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DatumEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.forwardKeyEvent(e);
        }

        private void forwardKeyEvent(KeyEvent e) {
            e.setSource(DatumEditor.this.editor);
            DatumEditor.this.editor.dispatchEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            DatumEditor.this.panel.requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

