/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;

public class DasTimeRangeSelector
extends JPanel
implements TimeRangeSelectionListener {
    public static final String PROP_RANGE = "range";
    private DatumRange range = null;
    JTextField idStart = null;
    JTextField idStop = null;
    JButton viewButton = null;
    JPanel startStopModePane = null;
    CardLayout cardLayout = null;
    boolean updateRangeString = false;
    private EventListenerList listenerList = null;
    protected final Action previousAction = new AbstractAction("<<"){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedPrevious();
        }
    };
    protected final Action nextAction = new AbstractAction(">>"){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelectedNext();
        }
    };
    protected final Action rangeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            DasTimeRangeSelector.this.fireTimeRangeSelected();
        }
    };
    private boolean favoritesEnabled = false;
    private List favoritesList = null;
    private JPopupMenu favoritesMenu = null;
    private final int FAVORITES_LIST_SIZE = 5;
    private String favoritesGroup;
    private JButton favoritesButton;
    private JPanel timesPane;
    private JComboBox rangeComboBox;
    private boolean pref = !DasApplication.getDefaultApplication().isApplet();

    public DasTimeRangeSelector() {
        this.updateRangeString = this.pref ? Preferences.userNodeForPackage(this.getClass()).getBoolean("updateRangeString", false) : false;
        this.buildComponents();
    }

    private Action getModeAction() {
        return new AbstractAction("mode"){

            public void actionPerformed(ActionEvent e) {
                boolean bl = DasTimeRangeSelector.this.updateRangeString = !DasTimeRangeSelector.this.updateRangeString;
                if (DasTimeRangeSelector.this.pref) {
                    Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", DasTimeRangeSelector.this.updateRangeString);
                }
                DasTimeRangeSelector.this.revalidateUpdateMode();
                DasTimeRangeSelector.this.update();
            }
        };
    }

    private void revalidateUpdateMode() {
        if (this.updateRangeString) {
            this.idStart.setColumns(28);
            this.idStop.setVisible(false);
            this.viewButton.setVisible(true);
        } else {
            this.idStart.setColumns(18);
            this.idStop.setVisible(true);
        }
        this.startStopModePane.revalidate();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout());
        JButton b = new JButton();
        b.setAction(this.previousAction);
        b.setActionCommand("previous");
        b.setToolTipText("Scan back in time");
        this.add(b);
        this.startStopModePane = new JPanel(new FlowLayout());
        this.cardLayout = new CardLayout();
        this.timesPane = new JPanel(this.cardLayout);
        JPanel startStopPane2 = new JPanel(new FlowLayout());
        this.idStart = new JTextField(18);
        this.idStart.setAction(this.rangeAction);
        this.idStart.setActionCommand("startTime");
        startStopPane2.add(this.idStart);
        this.idStop = new JTextField(18);
        this.idStop.addActionListener(this.rangeAction);
        this.idStop.setActionCommand("endTime");
        startStopPane2.add(this.idStop);
        this.timesPane.add((Component)startStopPane2, "startStop");
        this.startStopModePane.add(this.timesPane);
        this.favoritesButton = new JButton("v");
        this.favoritesButton.setToolTipText("recently entries times");
        this.favoritesButton.setPreferredSize(new Dimension(20, 20));
        this.favoritesButton.setVisible(false);
        this.startStopModePane.add(this.favoritesButton);
        this.viewButton = new JButton(this.getModeAction());
        this.viewButton.setToolTipText("input mode: start/end vs time range string");
        this.viewButton.setPreferredSize(new Dimension(20, 20));
        this.startStopModePane.add(this.viewButton);
        this.add(this.startStopModePane);
        b = new JButton();
        b.setAction(this.nextAction);
        b.setActionCommand("next");
        b.setToolTipText("Scan forward in time");
        this.add(b);
        this.revalidateUpdateMode();
    }

    public DasTimeRangeSelector(Datum startTime, Datum endTime) {
        this(new DatumRange(startTime, endTime));
    }

    public DasTimeRangeSelector(DatumRange range) {
        this();
        this.range = range;
        this.update();
    }

    private void parseRange() {
        boolean updateRangeString0 = this.updateRangeString;
        if (this.idStop.getText().equals("")) {
            try {
                String rangeString = this.idStart.getText();
                if (rangeString.equals("")) {
                    rangeString = (String)this.rangeComboBox.getEditor().getItem();
                }
                DatumRange dr = DatumRangeUtil.parseTimeRange(rangeString);
                DatumRange oldRange = this.range;
                this.range = dr;
                this.updateRangeString = true;
                this.firePropertyChange(PROP_RANGE, oldRange, this.range);
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        } else {
            this.updateRangeString = false;
            try {
                Datum s1 = TimeUtil.create(this.idStart.getText());
                Datum s2 = TimeUtil.create(this.idStop.getText());
                DatumRange oldRange = this.range;
                this.range = new DatumRange(s1, s2);
                this.firePropertyChange(PROP_RANGE, oldRange, this.range);
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        }
        if (this.updateRangeString != updateRangeString0 && this.pref) {
            Preferences.userNodeForPackage(this.getClass()).putBoolean("updateRangeString", this.updateRangeString);
        }
    }

    private void refreshFavorites() {
        this.favoritesMenu.removeAll();
        for (final String fav : this.favoritesList) {
            AbstractAction favAction = new AbstractAction(fav){

                public void actionPerformed(ActionEvent e) {
                    DasTimeRangeSelector.this.setRange(DatumRangeUtil.parseTimeRangeValid(fav));
                    DasTimeRangeSelector.this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, DasTimeRangeSelector.this.range));
                }
            };
            this.favoritesMenu.add(favAction);
        }
    }

    private void buildFavorites() {
        String favorites = "";
        if (this.pref) {
            favorites = Preferences.userNodeForPackage(this.getClass()).get("timeRangeSelector.favorites." + this.favoritesGroup, "");
        }
        String[] ss = favorites.split("\\|\\|");
        this.favoritesList = new ArrayList();
        for (int i = 0; i < ss.length; ++i) {
            if ("".equals(ss[i])) continue;
            this.favoritesList.add(ss[i]);
        }
        this.favoritesMenu = new JPopupMenu();
        this.refreshFavorites();
        this.favoritesButton.add(this.favoritesMenu);
        this.favoritesButton.addActionListener(this.getFavoritesListener());
    }

    private ActionListener getFavoritesListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasTimeRangeSelector.this.favoritesMenu.show(DasTimeRangeSelector.this, DasTimeRangeSelector.this.favoritesButton.getX(), DasTimeRangeSelector.this.favoritesButton.getY());
            }
        };
    }

    public void enableFavorites(String group) {
        if (group == null) {
            group = "default";
        }
        this.favoritesGroup = group;
        this.favoritesEnabled = true;
        this.favoritesButton.setVisible(true);
        this.buildFavorites();
    }

    public Datum getStartTime() {
        this.parseRange();
        return this.range.min();
    }

    public Datum getEndTime() {
        this.parseRange();
        return this.range.max();
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange range) {
        DatumRange oldRange = this.range;
        this.range = range;
        this.update();
        this.firePropertyChange(PROP_RANGE, oldRange, range);
    }

    private void update() {
        if (this.range != null) {
            if (this.updateRangeString) {
                String rangeString = DatumRangeUtil.formatTimeRange(this.range);
                this.idStart.setText(rangeString);
                this.idStop.setText("");
            } else {
                this.idStart.setText(this.range.min().toString());
                this.idStop.setText(this.range.max().toString());
            }
        }
    }

    public void setStartTime(Datum s1) {
        if (this.range == null) {
            return;
        }
        Datum endTime = this.range.max();
        if (endTime.le(s1)) {
            endTime = s1.add(1.0, Units.seconds);
        }
        this.range = new DatumRange(s1, endTime);
        this.update();
    }

    public void setEndTime(Datum s2) {
        if (this.range == null) {
            return;
        }
        Datum startTime = this.range.min();
        if (startTime.ge(s2)) {
            startTime = s2.subtract(1.0, Units.seconds);
        }
        this.range = new DatumRange(startTime, s2);
        this.update();
    }

    public boolean isWithin(Datum s1, Datum s2) {
        Datum startTime = this.getStartTime();
        Datum endTime = this.getEndTime();
        return s1.compareTo(startTime) <= 0 && endTime.compareTo(s2) <= 0;
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        DatumRange range = e.getRange();
        if (!range.equals(this.range)) {
            this.setRange(e.getRange());
            this.fireTimeRangeSelected(e);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.listenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    protected void fireTimeRangeSelectedPrevious() {
        DatumRange oldRange = this.range;
        this.setRange(this.range.previous());
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelectedNext() {
        DatumRange oldRange = this.range;
        this.setRange(this.range.next());
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected() {
        this.parseRange();
        this.update();
        if (this.favoritesEnabled) {
            String store = this.range.toString();
            if (this.favoritesList.contains(store)) {
                this.favoritesList.remove(store);
            }
            this.favoritesList.add(0, store);
            for (int i = 5; i < this.favoritesList.size(); ++i) {
                this.favoritesList.remove(i);
            }
            this.refreshFavorites();
            this.saveFavorites();
        }
        this.fireTimeRangeSelected(new TimeRangeSelectionEvent(this, this.range));
    }

    protected void fireTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void saveFavorites() {
        if (this.favoritesList.size() == 0) {
            return;
        }
        StringBuffer favorites = new StringBuffer((String)this.favoritesList.get(0));
        for (int i = 1; i < this.favoritesList.size(); ++i) {
            favorites.append("||" + this.favoritesList.get(i));
        }
        if (this.pref) {
            Preferences.userNodeForPackage(this.getClass()).put("timeRangeSelector." + this.favoritesGroup, favorites.toString());
        }
    }
}

