/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.graph.DasCanvas;

public class ComponentsUtil {
    public static DasCanvas createPopupCanvas(Component parent, String title, int width, int height) {
        DasCanvas canvas = new DasCanvas(width, height);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(parent);
        final JDialog popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        popupWindow.setTitle(title);
        popupWindow.setDefaultCloseOperation(2);
        popupWindow.setContentPane(content);
        popupWindow.pack();
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                popupWindow.setVisible(false);
            }
        });
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, parent);
        popupWindow.setLocation(parentLocation.x + parent.getWidth(), parentLocation.y);
        return canvas;
    }
}

