/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import org.das2.components.FixedColumnTextArea;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.DasExceptionHandler;
import org.jdesktop.layout.GroupLayout;

public class AsciiFileParser
extends JPanel {
    AsciiTableModel model;
    File file;
    private JComboBox delimSelector;
    private JCheckBox firstColumnTimeCheckBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextField jTextField1;

    public AsciiFileParser() {
        this.initComponents();
        this.jTextField1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AsciiFileParser.this.updateSkipLines();
            }
        });
        this.model = new AsciiTableModel();
    }

    public DataSet parse() throws FileNotFoundException, IOException, ParseException {
        ArrayList<Integer> usableColumns = new ArrayList<Integer>();
        for (int i = 0; i < this.model.columnCount; ++i) {
            if (this.model.units[i] == null) continue;
            usableColumns.add(new Integer(i));
        }
        if (usableColumns.size() < 2) {
            throw new IllegalArgumentException("not enough columns");
        }
        int[] iu = new int[usableColumns.size()];
        for (int i = 0; i < iu.length; ++i) {
            iu[i] = (Integer)usableColumns.get(i);
        }
        int col0 = (Integer)usableColumns.get(0);
        int col1 = (Integer)usableColumns.get(1);
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.model.units[col0], this.model.units[col1]);
        for (int i = 2; i < iu.length; ++i) {
            builder.addPlane(this.model.names[iu[i]], this.model.units[iu[i]]);
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        for (int iskip = 0; iskip < this.model.skipLines; ++iskip) {
            reader.readLine();
        }
        int iline = this.model.skipLines;
        String s = reader.readLine();
        ++iline;
        while (s != null) {
            try {
                Datum d0 = this.model.units[col0].parse(s.substring(this.model.columnOffsets[col0], this.model.columnOffsets[col0] + this.model.columnWidths[col0]));
                Datum d1 = this.model.units[col1].parse(s.substring(this.model.columnOffsets[col1], this.model.columnOffsets[col1] + this.model.columnWidths[col1]));
                builder.insertY(d0, d1);
                for (int i = 2; i < iu.length; ++i) {
                    Datum di = this.model.units[iu[i]].parse(s.substring(this.model.columnOffsets[iu[i]], this.model.columnOffsets[iu[i]] + this.model.columnWidths[iu[i]]));
                    builder.insertY(d0, di, this.model.names[iu[i]]);
                }
                s = reader.readLine();
                ++iline;
            }
            catch (ParseException ex) {
                throw new ParseException("Parse error at line " + iline, iline);
            }
        }
        reader.close();
        return builder.toVectorDataSet();
    }

    private void updateSkipLines() {
        try {
            this.model.skipLines = Integer.parseInt(this.jTextField1.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.jTextField1.setText("" + this.model.skipLines);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.delimSelector = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.firstColumnTimeCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jTextArea1 = new FixedColumnTextArea();
        this.jTextArea2 = new FixedColumnTextArea();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel1.setText("File:");
        this.jLabel2.setText("f:\\myfile.txt");
        this.delimSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"WhiteSpace", "Comma", "RegExp (\\s\\s+)"}));
        this.delimSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiFileParser.this.delimSelectorActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Delimiter:");
        this.jButton1.setText("choose");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiFileParser.this.jButton1ActionPerformed(evt);
            }
        });
        this.firstColumnTimeCheckBox.setText("FirstColumnTime");
        this.firstColumnTimeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.firstColumnTimeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jPanel1.add((Component)this.jTextArea1, "Center");
        this.jTextArea2.setBackground(new Color(238, 238, 255));
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(1);
        ColumnMouseInputAdapter mia = new ColumnMouseInputAdapter((FixedColumnTextArea)this.jTextArea2);
        this.jTextArea2.addMouseListener(mia);
        this.jPanel1.add((Component)this.jTextArea2, "North");
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jLabel4.setText("SkipLines:");
        this.jTextField1.setText("0");
        this.jTextField1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AsciiFileParser.this.jTextField1PropertyChange(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, this.jScrollPane1, -1, 453, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jLabel1, -2, 45, -2).addPreferredGap(0).add(this.jButton1).addPreferredGap(0).add(this.jLabel2, -2, 264, -2)).add(layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.delimSelector, -2, -1, -2)).add(layout.createSequentialGroup().add(this.firstColumnTimeCheckBox).add(77, 77, 77).add(this.jLabel4).addPreferredGap(0).add(this.jTextField1, -2, 47, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel1).add(this.jButton1)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.delimSelector, -2, -1, -2).add(this.jLabel3)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.firstColumnTimeCheckBox).add(this.jLabel4).add(this.jTextField1, -2, -1, -2)).addPreferredGap(0).add(this.jScrollPane1, -1, 335, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTextField1PropertyChange(PropertyChangeEvent evt) {
        this.updateSkipLines();
    }

    private void delimSelectorActionPerformed(ActionEvent evt) {
        try {
            this.resetDelims();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        int retVal = chooser.showOpenDialog(this);
        if (retVal == 0) {
            try {
                this.setFile(chooser.getSelectedFile());
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
    }

    private void handleException(Throwable t) {
        DasExceptionHandler.handle(t);
    }

    private void setFile(File file) throws IOException {
        this.file = file;
        this.resetDelims();
    }

    public String getDelimRegex() {
        String result;
        switch (this.delimSelector.getSelectedIndex()) {
            case 0: {
                result = "\\s+";
                break;
            }
            case 1: {
                result = ",";
                break;
            }
            case 2: {
                result = "\\s\\s+";
                break;
            }
            default: {
                throw new IllegalStateException("not implemented");
            }
        }
        return result;
    }

    public void resetDelims() throws IOException {
        String regex = this.getDelimRegex();
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        for (int i = 0; i < this.model.skipLines; ++i) {
            reader.readLine();
        }
        String line = reader.readLine();
        String[] ss = line.split(regex);
        this.model.columnCount = ss.length;
        int col = 0;
        this.model.columnOffsets[0] = 0;
        for (int i = 1; i < ss.length; ++i) {
            this.model.columnOffsets[i] = col = line.indexOf(ss[i], col + ss[i - 1].length());
            this.model.columnWidths[i - 1] = this.model.columnOffsets[i] - this.model.columnOffsets[i - 1];
        }
        this.model.columnWidths[ss.length - 1] = line.length() - this.model.columnOffsets[ss.length - 1];
        StringBuffer text = new StringBuffer(line + '\n');
        for (int linenum = 1; line != null && linenum < 100; ++linenum) {
            text.append(line + '\n');
            line = reader.readLine();
        }
        this.jTextArea1.setText(text.toString());
        int[] colDiv = new int[this.model.columnCount];
        for (int i = 0; i < this.model.columnCount; ++i) {
            colDiv[i] = this.model.columnOffsets[i];
        }
        ((FixedColumnTextArea)this.jTextArea1).setColumnDividers(colDiv);
        ((FixedColumnTextArea)this.jTextArea2).setColumnDividers(colDiv);
        this.jTextArea1.setCaretPosition(0);
        reader.close();
    }

    void resetColumnLabels() {
        int i;
        StringBuffer buf = new StringBuffer(256);
        for (i = 0; i < 256; ++i) {
            buf.append(" ");
        }
        for (i = 0; i < this.model.columnCount; ++i) {
            if (this.model.units[i] == null) continue;
            if (this.model.units[i] == Units.dimensionless) {
                buf.insert(this.model.columnOffsets[i], "(dim)");
                continue;
            }
            buf.insert(this.model.columnOffsets[i], this.model.units[i].toString());
        }
        this.jTextArea2.setText(buf.toString());
        this.jTextArea2.setCaretPosition(0);
    }

    class ColumnMouseInputAdapter
    extends MouseInputAdapter {
        JPopupMenu unitsMenu;
        final FixedColumnTextArea parent;
        int contextColumn;

        ColumnMouseInputAdapter(final FixedColumnTextArea parent) {
            this.parent = parent;
            this.unitsMenu = new JPopupMenu();
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    if (command.equals("ignore")) {
                        AsciiFileParser.this.model.units[ColumnMouseInputAdapter.this.contextColumn] = null;
                    } else if (command.startsWith("units=")) {
                        Units u;
                        AsciiFileParser.this.model.units[ColumnMouseInputAdapter.this.contextColumn] = u = Units.getByName(command.substring(6));
                    } else if (command.equals("name")) {
                        JOptionPane j = new JOptionPane();
                        String result = JOptionPane.showInputDialog(parent, "Enter a column name", "Column Name", -1);
                        if (result != null) {
                            AsciiFileParser.this.model.names[ColumnMouseInputAdapter.this.contextColumn] = result;
                        }
                    }
                    AsciiFileParser.this.resetColumnLabels();
                }
            };
            JMenuItem item = new JMenuItem("(ignore)");
            item.setActionCommand("ignore");
            item.addActionListener(listener);
            this.unitsMenu.add(item);
            item = new JMenuItem("dimensionless Datum");
            item.setActionCommand("units=");
            item.addActionListener(listener);
            this.unitsMenu.add(item);
            item = new JMenuItem("time Datum (us2000)");
            item.setActionCommand("units=us2000");
            item.addActionListener(listener);
            this.unitsMenu.add(item);
            item = new JMenuItem("Datum (KHz)");
            item.setActionCommand("units=kHz");
            item.addActionListener(listener);
            this.unitsMenu.add(item);
            item = new JMenuItem("name this column");
            item.setActionCommand("name");
            item.addActionListener(listener);
            this.unitsMenu.add(item);
        }

        public void mousePressed(MouseEvent me) {
            this.contextColumn = ((FixedColumnTextArea)AsciiFileParser.this.jTextArea2).columnAt(me.getX());
            this.unitsMenu.show(this.parent, me.getX(), me.getY());
        }
    }

    class AsciiTableModel {
        int columnCount = 0;
        int[] columnOffsets = new int[50];
        int[] columnWidths = new int[50];
        Units[] units = new Units[50];
        String[] names = new String[50];
        int skipLines = 0;

        AsciiTableModel() {
        }
    }
}

