/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.DasUpdateEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.SymbolLineRenderer;

public class AngleSpectrogramSlicer
extends DasPlot
implements BoxSelectionListener {
    private JDialog popupWindow;
    private SymbolLineRenderer renderer;
    private DasPlot parentPlot;
    private TableDataSetConsumer consumer;
    private Datum xstart;
    private Datum ystart;
    private DatumRange xrange;
    private DatumRange yrange;
    private int sliceDir;
    private final int SLICEDIR_HORIZ = 0;
    private final int SLICEDIR_VERTICAL = 1;

    private AngleSpectrogramSlicer(DasPlot plot, DasAxis xAxis, DasAxis yAxis, TableDataSetConsumer consumer) {
        super(xAxis, yAxis);
        this.parentPlot = plot;
        this.renderer = new SymbolLineRenderer();
        this.consumer = consumer;
        this.addRenderer(this.renderer);
    }

    public static AngleSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceXAxis = plot.getXAxis();
        DasAxis xAxis = sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = dataSetConsumer.getZAxis().createAttachedAxis(3);
        return new AngleSpectrogramSlicer(plot, xAxis, yAxis, dataSetConsumer);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AngleSpectrogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AngleSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Angle Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y + height);
    }

    private VectorDataSet angleSliceHoriz(TableDataSet tds, DatumRange xlimit, Datum xbase, Datum ybase, Datum slope) {
        VectorDataSetBuilder builder = new VectorDataSetBuilder(tds.getXUnits(), tds.getZUnits());
        int i0 = DataSetUtil.closestColumn(tds, xlimit.min());
        int i1 = DataSetUtil.closestColumn(tds, xlimit.max());
        int irow0 = 0;
        int irow1 = 0;
        Units zunits = tds.getZUnits();
        Units yunits = tds.getYUnits();
        for (int i = i0; i < i1; ++i) {
            Datum x = tds.getXTagDatum(i);
            Datum y = ybase.add(slope.multiply(x.subtract(xbase)));
            int itable = tds.tableOfIndex(i);
            while (irow0 > 0 && tds.getYTagDatum(itable, irow0).gt(y)) {
                --irow0;
            }
            irow1 = irow0 + 1;
            while (irow1 + 1 < tds.getYLength(itable) && tds.getYTagDatum(itable, irow1).lt(y)) {
                ++irow1;
            }
            irow0 = irow1 - 1;
            if (irow0 <= 0) continue;
            double z0 = tds.getDouble(i, irow0, zunits);
            double z1 = tds.getDouble(i, irow1, zunits);
            double y0 = tds.getYTagDouble(itable, irow0, yunits);
            double y1 = tds.getYTagDouble(itable, irow1, yunits);
            double yy = y.doubleValue(yunits);
            double alpha = (yy - y0) / (y1 - y0);
            double zinterp = z0 + (z1 - z0) * alpha;
            builder.insertY(x, Datum.create(zinterp, zunits));
        }
        return builder.toVectorDataSet();
    }

    public void drawContent(Graphics2D g) {
        double ix;
        double[] ixs;
        if (this.sliceDir == 0) {
            ixs = GraphUtil.transformRange(this.getXAxis(), this.xrange);
            ix = this.getXAxis().transform(this.xstart);
        } else {
            ixs = GraphUtil.transformRange(this.getYAxis(), this.yrange);
            ix = this.getYAxis().transform(this.ystart);
        }
        DasRow row = this.getRow();
        g.setColor(new Color(230, 230, 230));
        g.fillRect((int)ixs[0], row.getDMinimum(), (int)(ixs[1] - ixs[0]), row.getHeight());
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine((int)ix, row.getDMinimum(), (int)ix, row.getDMaximum());
        super.drawContent(g);
    }

    protected void processDasUpdateEvent(DasUpdateEvent e) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }

    public void BoxSelected(BoxSelectionEvent e) {
        Datum xbase = e.getStartX();
        Datum ybase = e.getStartY();
        this.xstart = e.getStartX();
        this.ystart = e.getStartY();
        this.xrange = e.getXRange();
        this.yrange = e.getYRange();
        Datum slope = e.getFinishY().subtract(ybase).divide(e.getFinishX().subtract(xbase));
        DataSet ds = this.consumer.getConsumedDataSet();
        if (ds == null || !(ds instanceof TableDataSet)) {
            return;
        }
        TableDataSet tds = (TableDataSet)ds;
        VectorDataSet sliceDataSet = this.angleSliceHoriz(tds, this.getXAxis().getDatumRange(), xbase, ybase, slope);
        this.sliceDir = 0;
        this.renderer.setDataSet(sliceDataSet);
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        }
    }
}

