/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.AccessDeniedException;
import org.das2.client.Authenticator;
import org.das2.client.DasServer;
import org.das2.client.DasServerException;
import org.das2.client.Key;
import org.das2.client.NoSuchDataSetException;
import org.das2.client.StandardDataStreamSource;
import org.das2.client.StreamDataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.NoKeyProvidedException;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.DasDie;
import org.das2.util.URLBuddy;

public class WebStandardDataStreamSource
implements StandardDataStreamSource {
    private DasServer server;
    private boolean legacyStream = true;
    private String extraParameters;
    private boolean compress;
    private String lastRequestURL;
    private boolean redirect = false;
    private Key key = null;
    private String devel = "";

    public WebStandardDataStreamSource(DasServer server, URL url) {
        String[] query;
        this.server = server;
        String[] stringArray = query = url.getQuery() == null ? new String[]{} : url.getQuery().split("&");
        if (query.length >= 2) {
            this.extraParameters = query[1];
        }
    }

    public boolean isLegacyStream() {
        return this.legacyStream;
    }

    public InputStream getInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end) throws DasException {
        String serverType = "dataset";
        StringBuffer formData = new StringBuffer();
        formData.append("server=").append(serverType);
        InputStream in = this.openURLConnection(dsd, start, end, formData);
        in = DasApplication.getDefaultApplication().getInputStreamMeter().meterInputStream(in);
        return in;
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end, Datum timeResolution) throws DasException {
        StringBuffer formData = new StringBuffer();
        String form = (String)dsd.getProperty("form");
        if ("true".equals(dsd.getProperty("legacy")) && "x_tagged_y_scan".equals(form)) {
            formData.append("server=compactdataset");
            StreamYScanDescriptor y = (StreamYScanDescriptor)dsd.getDefaultPacketDescriptor().getYDescriptors().get(0);
            formData.append("&nitems=").append(y.getNItems() + 1);
            if (timeResolution != null) {
                formData.append("&resolution=").append(timeResolution.doubleValue(Units.seconds));
            }
        } else if ("x_multi_y".equals(form) && dsd.getProperty("items") != null) {
            formData.append("server=dataset");
            if (timeResolution != null) {
                formData.append("&interval=").append(timeResolution.doubleValue(Units.seconds));
            }
        } else {
            formData.append("server=compactdataset");
            if (timeResolution != null) {
                formData.append("&resolution=").append(timeResolution.doubleValue(Units.seconds));
            }
        }
        if (this.extraParameters != null) {
            formData.append("&params=").append(this.extraParameters);
        }
        if (this.compress) {
            formData.append("&compress=true");
        }
        if (!this.devel.equals("")) {
            formData.append("&devel=" + this.devel);
        }
        InputStream in = this.openURLConnection(dsd, start, end, formData);
        in = DasApplication.getDefaultApplication().getInputStreamMeter().meterInputStream(in);
        return in;
    }

    private String createFormDataString(String dataSetID, Datum start, Datum end, StringBuffer additionalFormData) throws UnsupportedEncodingException {
        DatumFormatter formatter = start.getUnits().getDatumFormatterFactory().defaultFormatter();
        String startStr = formatter.format(start);
        String endStr = formatter.format(end);
        StringBuffer formData = new StringBuffer("dataset=");
        formData.append(URLBuddy.encodeUTF8(dataSetID));
        formData.append("&start_time=").append(URLBuddy.encodeUTF8(startStr));
        formData.append("&end_time=").append(URLBuddy.encodeUTF8(endStr));
        formData.append("&").append(additionalFormData);
        return formData.toString();
    }

    protected synchronized InputStream openURLConnection(StreamDataSetDescriptor dsd, Datum start, Datum end, StringBuffer additionalFormData) throws DasException {
        String[] tokens = dsd.getDataSetID().split("\\?|\\&");
        String dataSetID = tokens[1];
        try {
            String formData = this.createFormDataString(dataSetID, start, end, additionalFormData);
            if (dsd.isRestrictedAccess()) {
                this.key = this.server.getKey("");
                if (this.key != null) {
                    formData = formData + "&key=" + URLEncoder.encode(this.key.toString(), "UTF-8");
                }
            }
            if (this.redirect) {
                formData = formData + "&redirect=1";
            }
            URL serverURL = this.server.getURL(formData);
            this.lastRequestURL = String.valueOf(serverURL);
            DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).fine("opening " + serverURL.toString());
            URLConnection urlConnection = serverURL.openConnection();
            urlConnection.connect();
            String contentType = urlConnection.getContentType();
            if (!contentType.equalsIgnoreCase("application/octet-stream")) {
                BufferedReader bin = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                String line = bin.readLine();
                String message = "";
                while (line != null) {
                    message = message.concat(line);
                    line = bin.readLine();
                }
                throw new DasIOException(message);
            }
            InputStream in = urlConnection.getInputStream();
            if (this.isLegacyStream()) {
                return this.processLegacyStream(in);
            }
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new DasIOException(e);
        }
    }

    private InputStream processLegacyStream(InputStream in) throws IOException, DasException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(Integer.MAX_VALUE);
        String serverResponse = this.readServerResponse(bin);
        if (serverResponse.equals("")) {
            return bin;
        }
        if (serverResponse.equals("<noDataInInterval/>")) {
            throw new NoDataInIntervalException("no data in interval");
        }
        String errorTag = "error";
        if (serverResponse.startsWith("<" + errorTag + ">")) {
            int index2 = serverResponse.indexOf("</" + errorTag + ">");
            String error = serverResponse.substring(errorTag.length() + 2, serverResponse.length() - (errorTag.length() + 3));
            DasDie.println("error=" + error);
            if (error.equals("<needKey/>")) {
                throw new NoKeyProvidedException("");
            }
            if (error.equals("<accessDenied/>")) {
                this.server.setKey(null);
                this.server.getKey("");
                throw new AccessDeniedException("");
            }
            if (error.equals("<invalidKey/>")) {
                throw new NoKeyProvidedException("invalid Key");
            }
            if (error.equals("<noSuchDataSet/>")) {
                throw new NoSuchDataSetException("");
            }
            throw new DasServerException("Error response from server: " + error);
        }
        return bin;
    }

    private String readServerResponse(InputStream in) {
        String das2Response;
        byte[] data = new byte[4096];
        int lastBytesRead = -1;
        int offset = 0;
        try {
            int bytesRead = in.read(data, offset, 4096 - offset);
            String das2ResponseTag = "das2Response";
            if (bytesRead < das2ResponseTag.length() + 2) {
                offset += bytesRead;
                bytesRead = in.read(data, offset, 4096 - offset);
            }
            if (new String(data, 0, 14, "UTF-8").equals("<" + das2ResponseTag + ">")) {
                while (new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">") == -1 && offset < 4096) {
                    bytesRead = in.read(data, offset += bytesRead, 4096 - offset);
                }
                int index = new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">");
                das2Response = new String(data, 14, index - 14);
                DasDie.println("das2Response=" + das2Response);
                in.reset();
                in.skip(das2Response.length() + 2 * das2ResponseTag.length() + 5);
            } else {
                in.reset();
                das2Response = "";
            }
        }
        catch (IOException e) {
            das2Response = "";
        }
        return das2Response;
    }

    public void reset() {
    }

    public void authenticate(String restrictedResourceLabel) {
        Authenticator authenticator = new Authenticator(this.server, restrictedResourceLabel);
        Key key = authenticator.authenticate();
        if (key != null) {
            this.server.setKey(key);
        }
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getLastRequestURL() {
        return this.lastRequestURL;
    }

    public void setLastRequestURL(String url) {
    }

    public DasServer getDasServer() {
        return this.server;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public Key getKey() {
        return this.key;
    }

    public String getDevel() {
        return this.devel;
    }

    public void setDevel(String devel) {
        this.devel = devel;
    }
}

