/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.Authenticator;
import org.das2.client.DasServerException;
import org.das2.client.DasServerNotFoundException;
import org.das2.client.DataSetDescriptorNotAvailableException;
import org.das2.client.Key;
import org.das2.client.StandardDataStreamSource;
import org.das2.client.WebStandardDataStreamSource;
import org.das2.stream.DasStreamFormatException;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.system.DasLogger;
import org.das2.util.Crypt;
import org.das2.util.DasDie;
import org.das2.util.DasExceptionHandler;
import org.das2.util.URLBuddy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasServer {
    private String host;
    private String path;
    private int port;
    private HashMap keys;
    private Key key;
    private static Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private static HashMap instanceHashMap = new HashMap();
    public static DasServer plasmaWaveGroup;
    public static DasServer sarahandjeremy;

    private DasServer(String host, String path) {
        String[] s = host.split(":");
        if (s.length > 1) {
            this.port = Integer.parseInt(s[1]);
            host = s[0];
        } else {
            this.port = -1;
        }
        this.host = host;
        this.path = path;
        this.keys = new HashMap();
    }

    public String getURL() {
        if (this.port == -1) {
            return "http://" + this.host + this.path;
        }
        return "http://" + this.host + ":" + this.port + this.path;
    }

    public static DasServer create(URL url) {
        String key;
        String host = url.getHost();
        int port = url.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        if (instanceHashMap.containsKey(key = "http://" + host + url.getPath())) {
            logger.fine("Using existing DasServer for " + url);
            return (DasServer)instanceHashMap.get(key);
        }
        String path = url.getPath();
        logger.fine("Creating DasServer for " + url);
        DasServer result = new DasServer(host, path);
        instanceHashMap.put(key, result);
        return result;
    }

    public String getName() {
        String formData = "server=id";
        try {
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            URLConnection urlConnection = server.openConnection();
            urlConnection.connect();
            String contentType = urlConnection.getContentType();
            InputStream in = urlConnection.getInputStream();
            String result = new String(this.read(in));
            logger.fine("response=" + result);
            return result;
        }
        catch (IOException e) {
            return "";
        }
    }

    public ImageIcon getLogo() {
        String formData = "server=logo";
        try {
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            URLConnection urlConnection = server.openConnection();
            urlConnection.connect();
            String contentType = urlConnection.getContentType();
            InputStream in = urlConnection.getInputStream();
            byte[] data = this.read(in);
            logger.fine("response=" + data.length + " bytes");
            return new ImageIcon(data);
        }
        catch (IOException e) {
            return new ImageIcon();
        }
    }

    public TreeModel getDataSetList() throws DasException {
        String formData = "server=list";
        try {
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            URLConnection urlConnection = server.openConnection();
            urlConnection.connect();
            String contentType = urlConnection.getContentType();
            InputStream in = urlConnection.getInputStream();
            TreeModel result = this.createModel(in);
            logger.fine("response->" + result);
            return result;
        }
        catch (IOException e) {
            throw new DasIOException(e.getMessage());
        }
    }

    private TreeModel createModel(InputStream uin) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(uin));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getURL(), true);
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        String line = in.readLine();
        while (line != null) {
            DefaultMutableTreeNode current = root;
            StringTokenizer tokenizer = new StringTokenizer(line, "/");
            block1: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                for (int index = 0; index < current.getChildCount(); ++index) {
                    String str = current.getChildAt(index).toString();
                    if (!str.equals(tok)) continue;
                    current = (DefaultMutableTreeNode)current.getChildAt(index);
                    continue block1;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(tok, tokenizer.hasMoreElements() ? true : line.endsWith("/"));
                current.add(node);
                current = node;
            }
            line = in.readLine();
        }
        return model;
    }

    public StandardDataStreamSource getStandardDataStreamSource(URL url) {
        return new WebStandardDataStreamSource(this, url);
    }

    public StreamDescriptor getStreamDescriptor(URL dataSetID) throws DasException {
        try {
            String dsdf = dataSetID.getQuery().split("&")[0];
            URL url = new URL("http", this.host, this.port, this.path + "?server=dsdf&dataset=" + dsdf);
            logger.fine("connecting to " + url);
            URLConnection connection = url.openConnection();
            connection.connect();
            String contentType = connection.getContentType();
            String[] s1 = contentType.split(";");
            contentType = s1[0];
            if (contentType.equalsIgnoreCase("text/plain")) {
                PushbackReader reader = new PushbackReader(new InputStreamReader(connection.getInputStream()), 4);
                char[] four = new char[4];
                reader.read(four);
                if (new String(four).equals("[00]")) {
                    logger.fine("response is a das2Stream");
                    reader.skip(6L);
                    Document header = StreamDescriptor.parseHeader(reader);
                    Element root = header.getDocumentElement();
                    if (root.getTagName().equals("stream")) {
                        return new StreamDescriptor(root);
                    }
                    if (root.getTagName().equals("exception")) {
                        logger.fine("response is an exception");
                        String type = root.getAttribute("type");
                        StreamException se = new StreamException("stream exception: " + type);
                        DasException de = new DasException("stream exception: " + type);
                        de.initCause(se);
                        throw de;
                    }
                    if (root.getTagName().equals("")) {
                        throw new DasStreamFormatException();
                    }
                    throw new DasStreamFormatException();
                }
                logger.fine("response is a legacy descriptor");
                reader.unread(four);
                BufferedReader in = new BufferedReader(reader);
                StreamDescriptor result = StreamDescriptor.createLegacyDescriptor(in);
                return result;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer message = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                message.append(line).append('\n');
                line = in.readLine();
            }
            throw new IOException(message.toString());
        }
        catch (MalformedURLException e) {
            throw new DataSetDescriptorNotAvailableException("malformed URL");
        }
        catch (FileNotFoundException e) {
            throw new DasServerNotFoundException(e.getMessage());
        }
        catch (IOException e) {
            throw new DasIOException(e.toString());
        }
    }

    public Key authenticate(String user, String passCrypt) {
        try {
            Key result = null;
            String formData = "server=authenticator";
            formData = formData + "&user=" + URLBuddy.encodeUTF8(user);
            formData = formData + "&passwd=" + URLBuddy.encodeUTF8(passCrypt);
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String errTag = "error";
            String keyTag = "key";
            if (serverResponse.substring(0, keyTag.length() + 2).equals("<" + keyTag + ">")) {
                int index = serverResponse.indexOf("</" + keyTag + ">");
                String keyString = serverResponse.substring(keyTag.length() + 2, index);
                result = new Key(keyString);
            } else {
                result = null;
            }
            return result;
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException e) {
            return null;
        }
    }

    public List groups(Key key) {
        try {
            String formData = "server=groups";
            formData = formData + "&key=" + URLBuddy.encodeUTF8(key.toString());
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String[] groups = serverResponse.split(",");
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = groups[i].trim();
                if ("".equals(groups[i])) continue;
                result.add(groups[i]);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void changePassword(String user, String oldPass, String newPass) throws DasServerException {
        try {
            String formData = "server=changePassword";
            formData = formData + "&user=" + URLBuddy.encodeUTF8(user);
            String cryptPass = Crypt.crypt(oldPass);
            formData = formData + "&passwd=" + URLBuddy.encodeUTF8(cryptPass);
            String cryptNewPass = Crypt.crypt(newPass);
            formData = formData + "&newPasswd=" + URLBuddy.encodeUTF8(cryptNewPass);
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.fine("connecting to " + server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String errTag = "error";
            String keyTag = "key";
            if (serverResponse.substring(0, errTag.length() + 2).equals("<" + errTag + ">")) {
                int index = serverResponse.indexOf("</" + errTag + ">");
                String errString = serverResponse.substring(errTag.length() + 2, index);
                if (errString.equals("<badAuthentication/>")) {
                    throw new DasServerException("Bad User/Pass");
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException e) {
            throw new DasServerException("Failed Connection");
        }
    }

    public String readServerResponse(BufferedInputStream in) {
        String das2Response;
        in.mark(Integer.MAX_VALUE);
        byte[] data = new byte[4096];
        int lastBytesRead = -1;
        int offset = 0;
        try {
            int bytesRead = in.read(data, offset, 4096 - offset);
            String das2ResponseTag = "das2Response";
            if (bytesRead < das2ResponseTag.length() + 2) {
                offset += bytesRead;
                bytesRead = in.read(data, offset, 4096 - offset);
            }
            if (new String(data, 0, 14, "UTF-8").equals("<" + das2ResponseTag + ">")) {
                while (new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">") == -1 && offset < 4096) {
                    bytesRead = in.read(data, offset += bytesRead, 4096 - offset);
                }
                int index = new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">");
                das2Response = new String(data, 14, index - 14);
                DasDie.println("das2Response=" + das2Response);
                in.reset();
                in.skip(das2Response.length() + 2 * das2ResponseTag.length() + 5);
            } else {
                in.reset();
                das2Response = "";
            }
        }
        catch (IOException e) {
            das2Response = "";
        }
        logger.fine("response=" + das2Response);
        return das2Response;
    }

    private byte[] read(InputStream uin) throws IOException {
        int i;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int bytesRead = 0;
        int totalBytesRead = 0;
        InputStream in = uin;
        long time = System.currentTimeMillis();
        byte[] data = new byte[4096];
        int lastBytesRead = -1;
        int offset = 0;
        bytesRead = in.read(data, offset, 4096 - offset);
        while (bytesRead != -1) {
            int bytesSoFar = totalBytesRead;
            lastBytesRead = offset += bytesRead;
            if (offset == 4096) {
                list.addLast(data);
                data = new byte[4096];
                offset = 0;
            }
            totalBytesRead += bytesRead;
            bytesRead = in.read(data, offset, 4096 - offset);
        }
        if (lastBytesRead < 4096) {
            list.addLast(data);
        }
        if (list.size() == 0) {
            return new byte[0];
        }
        int dataLength = (list.size() - 1) * 4096 + lastBytesRead;
        data = new byte[dataLength];
        Iterator iterator = list.iterator();
        for (i = 0; i < list.size() - 1; ++i) {
            System.arraycopy(iterator.next(), 0, data, i * 4096, 4096);
        }
        System.arraycopy(iterator.next(), 0, data, i * 4096, lastBytesRead);
        return data;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL(String formData) throws MalformedURLException {
        return new URL("http", this.host, this.port, this.path + "?" + formData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getKey(String resource) {
        DasServer dasServer = this;
        synchronized (dasServer) {
            Authenticator authenticator;
            Key key;
            if (this.keys.get(resource) == null && (key = (authenticator = new Authenticator(this, resource)).authenticate()) != null) {
                this.keys.put(resource, key);
            }
        }
        return (Key)this.keys.get(resource);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String toString() {
        return this.getURL();
    }

    static {
        try {
            plasmaWaveGroup = DasServer.create(new URL("http://www-pw.physics.uiowa.edu/das/das2Server"));
            sarahandjeremy = DasServer.create(new URL("http://www.sarahandjeremy.net/das/dasServer.cgi"));
        }
        catch (MalformedURLException e) {
            DasExceptionHandler.handle(e);
        }
    }
}

