/*
 * Decompiled with CFR 0.152.
 */
package org.das2;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.beans.BeansUtil;
import org.das2.dasml.ParsedExpression;
import org.das2.dasml.ParsedExpressionException;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;

public class NameContext {
    private static final String SIMPLE_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*";
    private static final String INDEX_STRING = "0|[1-9][0-9]*";
    private static final String INDEXED_NAME_STRING = "([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]";
    private static final String QUALIFIED_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*";
    public static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    public static final Pattern INDEXED_NAME = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]");
    public static final Pattern QUALIFIED_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*");
    public static final Pattern refPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
    public static final Pattern intPattern = Pattern.compile("-?(0|[1-9][0-9]*)");
    public static final Pattern floatPattern = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private Map nameMap = new HashMap();
    private Map propertyMap = new HashMap();

    NameContext() {
    }

    public void put(String name, Object value) throws DasNameException {
        Matcher m = SIMPLE_NAME.matcher(name);
        if (!m.matches()) {
            throw new DasNameException(name + " must match " + SIMPLE_NAME_STRING);
        }
        this.nameMap.put(name, new WeakReference<Object>(value));
    }

    public Object get(String name) throws DasPropertyException, InvocationTargetException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Matcher m = SIMPLE_NAME.matcher(name);
        if (m.matches()) {
            return ((WeakReference)this.nameMap.get(name)).get();
        }
        int index = name.lastIndexOf(46);
        Object obj = this.get(name.substring(0, index));
        String property = name.substring(index + 1);
        m = INDEXED_NAME.matcher(property);
        if (m.matches()) {
            property = m.group(1);
            index = Integer.parseInt(m.group(2));
            return this.getIndexedPropertyValue(obj, property, index);
        }
        return this.getPropertyValue(obj, property);
    }

    public void set(String name, Object value) throws InvocationTargetException, ParsedExpressionException, DasPropertyException, DasNameException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Matcher m = SIMPLE_NAME.matcher(name);
        if (m.matches()) {
            this.put(name, value);
        }
        int index = name.lastIndexOf(46);
        Object obj = this.get(name.substring(0, index));
        String property = name.substring(index + 1);
        m = INDEXED_NAME.matcher(property);
        if (m.matches()) {
            property = m.group(1);
            index = Integer.parseInt(m.group(2));
            this.setIndexedPropertyValue(obj, property, index, value);
        } else {
            this.setPropertyValue(obj, property, value);
        }
    }

    public Object getPropertyValue(Object obj, String property) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            Method readMethod = pd.getReadMethod();
            return readMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Object getIndexedPropertyValue(Object obj, String property, int index) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, property);
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method readMethod = ipd.getIndexedReadMethod();
            return readMethod.invoke(obj, new Integer(index));
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void setPropertyValue(Object obj, String property, Object value) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, property);
            }
            Class<?> propertyType = pd.getPropertyType();
            if (value instanceof String) {
                value = this.parseValue((String)value, propertyType);
            }
            if (!(propertyType.isInstance(value) || propertyType == Boolean.TYPE && value instanceof Boolean || propertyType == Character.TYPE && value instanceof Character || propertyType == Double.TYPE && value instanceof Double || propertyType == Short.TYPE && value instanceof Short || propertyType == Integer.TYPE && value instanceof Integer || propertyType == Float.TYPE && value instanceof Float || propertyType == Byte.TYPE && value instanceof Byte || propertyType == Long.TYPE && value instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, property);
            }
            writeMethod.invoke(obj, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public void setIndexedPropertyValue(Object obj, String property, int index, Object value) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        try {
            Class<?> type = obj.getClass();
            this.maybeLoadPropertiesForClass(type);
            Map map = (Map)this.propertyMap.get(type);
            PropertyDescriptor pd = (PropertyDescriptor)map.get(property);
            if (pd == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, property);
            }
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, property);
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method writeMethod = ipd.getIndexedWriteMethod();
            if (writeMethod == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, property);
            }
            Class<?> propertyType = pd.getPropertyType();
            if (value instanceof String) {
                value = this.parseValue((String)value, propertyType);
            }
            if (!(propertyType.isInstance(value) || propertyType == Boolean.TYPE && value instanceof Boolean || propertyType == Character.TYPE && value instanceof Character || propertyType == Double.TYPE && value instanceof Double || propertyType == Short.TYPE && value instanceof Short || propertyType == Integer.TYPE && value instanceof Integer || propertyType == Float.TYPE && value instanceof Float || propertyType == Byte.TYPE && value instanceof Byte || propertyType == Long.TYPE && value instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, property);
            }
            writeMethod.invoke(obj, new Integer(index), value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private void maybeLoadPropertiesForClass(Class cl) {
        try {
            if (this.propertyMap.get(cl) == null) {
                BeanInfo info = BeansUtil.getBeanInfo(cl);
                HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] properties = info.getPropertyDescriptors();
                for (int i = 0; i < properties.length; ++i) {
                    IndexedPropertyDescriptor ipd;
                    if (properties[i].getReadMethod() == null || properties[i] instanceof IndexedPropertyDescriptor && (ipd = (IndexedPropertyDescriptor)properties[i]).getIndexedReadMethod() == null) continue;
                    map.put(properties[i].getName(), properties[i]);
                }
                this.propertyMap.put(cl, map);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void remove(String name) {
        this.nameMap.remove(name);
    }

    public Object parseValue(String valueString, Class type) throws ParsedExpressionException, InvocationTargetException, DasPropertyException {
        valueString = this.replaceReferences(valueString);
        if (type == String.class) {
            return valueString;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (valueString.equals("true")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("false")) {
                return Boolean.FALSE;
            }
            ParsedExpression exp = new ParsedExpression(valueString);
            Object o = exp.evaluate(this);
            if (!(o instanceof Boolean)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a boolean value");
            }
            return o;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (intPattern.matcher(valueString).matches()) {
                return new Integer(valueString);
            }
            ParsedExpression exp = new ParsedExpression(valueString);
            Object o = exp.evaluate(this);
            if (!(o instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return o instanceof Integer ? (Integer)o : new Integer(((Number)o).intValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            ParsedExpression exp;
            Object o;
            if (intPattern.matcher(valueString).matches()) {
                Long l = new Long(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return new Long(((Number)o).longValue());
        }
        if (type == Float.TYPE || type == Float.class) {
            ParsedExpression exp;
            Object o;
            if (floatPattern.matcher(valueString).matches()) {
                Float f = new Float(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return new Float(((Number)o).floatValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            ParsedExpression exp;
            Object o;
            if (floatPattern.matcher(valueString).matches()) {
                Double d = new Double(valueString);
            }
            if (!((o = (exp = new ParsedExpression(valueString)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + valueString + "' does not evaluate to a numeric value");
            }
            return o instanceof Double ? (Double)o : new Double(((Number)o).doubleValue());
        }
        if (type == Datum.class) {
            try {
                return TimeUtil.create(valueString);
            }
            catch (ParseException ex) {
                try {
                    return Datum.create(Double.parseDouble(valueString));
                }
                catch (NumberFormatException iae) {
                    throw new ParsedExpressionException(valueString + " cannot be parsed as a Datum");
                }
            }
        }
        throw new IllegalStateException(type.getName() + " is not a recognized type");
    }

    protected String replaceReferences(String str) throws DasPropertyException, InvocationTargetException {
        Matcher matcher = refPattern.matcher(str);
        while (matcher.find()) {
            String name = matcher.group(1).trim();
            Object value = this.get(name);
            str = matcher.replaceFirst(value.toString());
            matcher.reset(str);
        }
        return str;
    }

    public String toString() {
        return this.getClass().getName() + this.nameMap.keySet().toString();
    }
}

