/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultErrorHandler;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.XmlWriter;
import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphics2D
extends AbstractGraphics2D
implements Cloneable,
SVGSyntax,
XMLConstants,
ErrorConstants {
    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_MAX_GC_OVERRIDES = 3;
    private DOMTreeManager domTreeManager;
    private DOMGroupManager domGroupManager;
    private SVGGeneratorContext generatorCtx;
    private SVGShape shapeConverter;
    private Dimension svgCanvasSize;
    private Graphics2D fmg;

    public final Dimension getSVGCanvasSize() {
        return this.svgCanvasSize;
    }

    public final void setSVGCanvasSize(Dimension svgCanvasSize) {
        this.svgCanvasSize = new Dimension(svgCanvasSize);
    }

    public final SVGGeneratorContext getGeneratorContext() {
        return this.generatorCtx;
    }

    public final DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    protected final DOMGroupManager getDOMGroupManager() {
        return this.domGroupManager;
    }

    public final Document getDOMFactory() {
        return this.generatorCtx.domFactory;
    }

    public final ImageHandler getImageHandler() {
        return this.generatorCtx.imageHandler;
    }

    public final GenericImageHandler getGenericImageHandler() {
        return this.generatorCtx.genericImageHandler;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.generatorCtx.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorCtx.setExtensionHandler(extensionHandler);
    }

    public SVGGraphics2D(Document domFactory) {
        this(SVGGeneratorContext.createDefault(domFactory), false);
    }

    public SVGGraphics2D(Document domFactory, ImageHandler imageHandler, ExtensionHandler extensionHandler, boolean textAsShapes) {
        this(SVGGraphics2D.buildSVGGeneratorContext(domFactory, imageHandler, extensionHandler), textAsShapes);
    }

    public static SVGGeneratorContext buildSVGGeneratorContext(Document domFactory, ImageHandler imageHandler, ExtensionHandler extensionHandler) {
        SVGGeneratorContext generatorCtx = new SVGGeneratorContext(domFactory);
        generatorCtx.setIDGenerator(new SVGIDGenerator());
        generatorCtx.setExtensionHandler(extensionHandler);
        generatorCtx.setImageHandler(imageHandler);
        generatorCtx.setStyleHandler(new DefaultStyleHandler());
        generatorCtx.setComment("Generated by the Batik Graphics2D SVG Generator");
        generatorCtx.setErrorHandler(new DefaultErrorHandler());
        return generatorCtx;
    }

    public SVGGraphics2D(SVGGeneratorContext generatorCtx, boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        if (generatorCtx == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.setGeneratorContext(generatorCtx);
    }

    private void setGeneratorContext(SVGGeneratorContext generatorCtx) {
        this.generatorCtx = generatorCtx;
        this.gc = new GraphicContext(new AffineTransform());
        SVGGeneratorContext.GraphicContextDefaults gcDefaults = generatorCtx.getGraphicContextDefaults();
        if (gcDefaults != null) {
            if (gcDefaults.getPaint() != null) {
                this.gc.setPaint(gcDefaults.getPaint());
            }
            if (gcDefaults.getStroke() != null) {
                this.gc.setStroke(gcDefaults.getStroke());
            }
            if (gcDefaults.getComposite() != null) {
                this.gc.setComposite(gcDefaults.getComposite());
            }
            if (gcDefaults.getClip() != null) {
                this.gc.setClip(gcDefaults.getClip());
            }
            if (gcDefaults.getRenderingHints() != null) {
                this.gc.setRenderingHints(gcDefaults.getRenderingHints());
            }
            if (gcDefaults.getFont() != null) {
                this.gc.setFont(gcDefaults.getFont());
            }
            if (gcDefaults.getBackground() != null) {
                this.gc.setBackground(gcDefaults.getBackground());
            }
        }
        this.shapeConverter = new SVGShape(generatorCtx);
        this.domTreeManager = new DOMTreeManager(this.gc, generatorCtx, 3);
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        generatorCtx.genericImageHandler.setDOMTreeManager(this.domTreeManager);
    }

    public SVGGraphics2D(SVGGraphics2D g) {
        super(g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.generatorCtx = g.generatorCtx;
        this.gc.validateTransformStack();
        this.shapeConverter = g.shapeConverter;
        this.domTreeManager = g.domTreeManager;
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
    }

    public void stream(String svgFileName) throws SVGGraphics2DIOException {
        this.stream(svgFileName, false);
    }

    public void stream(String svgFileName, boolean useCss) throws SVGGraphics2DIOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(svgFileName), DEFAULT_XML_ENCODING);
            this.stream(writer, useCss);
            writer.flush();
            writer.close();
        }
        catch (SVGGraphics2DIOException io) {
            throw io;
        }
        catch (IOException e) {
            this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(e));
        }
    }

    public void stream(Writer writer) throws SVGGraphics2DIOException {
        this.stream(writer, false);
    }

    public void stream(Writer writer, boolean useCss) throws SVGGraphics2DIOException {
        Element svgRoot = this.getRoot();
        this.stream(svgRoot, writer, useCss);
    }

    public void stream(Element svgRoot, Writer writer) throws SVGGraphics2DIOException {
        this.stream(svgRoot, writer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(Element svgRoot, Writer writer, boolean useCss) throws SVGGraphics2DIOException {
        Node rootParent = svgRoot.getParentNode();
        Node nextSibling = svgRoot.getNextSibling();
        try {
            svgRoot.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
            svgRoot.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
            DocumentFragment svgDocument = svgRoot.getOwnerDocument().createDocumentFragment();
            svgDocument.appendChild(svgRoot);
            if (useCss) {
                SVGCSSStyler.style(svgDocument);
            }
            XmlWriter.writeXml(svgDocument, writer);
            writer.flush();
        }
        catch (SVGGraphics2DIOException e) {
            this.generatorCtx.errorHandler.handleError(e);
        }
        catch (IOException io) {
            this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(io));
        }
        finally {
            if (rootParent != null) {
                if (nextSibling == null) {
                    rootParent.appendChild(svgRoot);
                } else {
                    rootParent.insertBefore(svgRoot, nextSibling);
                }
            }
        }
    }

    public List getDefinitionSet() {
        return this.domTreeManager.getDefinitionSet();
    }

    public Element getTopLevelGroup() {
        return this.getTopLevelGroup(true);
    }

    public Element getTopLevelGroup(boolean includeDefinitionSet) {
        return this.domTreeManager.getTopLevelGroup(includeDefinitionSet);
    }

    public void setTopLevelGroup(Element topLevelGroup) {
        this.domTreeManager.setTopLevelGroup(topLevelGroup);
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element svgRoot) {
        svgRoot = this.domTreeManager.getRoot(svgRoot);
        if (this.svgCanvasSize != null) {
            svgRoot.setAttributeNS(null, "width", "" + this.svgCanvasSize.width);
            svgRoot.setAttributeNS(null, "height", "" + this.svgCanvasSize.height);
        }
        return svgRoot;
    }

    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    public void setXORMode(Color c1) {
        this.generatorCtx.errorHandler.handleError(new SVGGraphics2DRuntimeException("XOR Mode is not supported by Graphics2D SVG Generator"));
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        Element imageElement = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform xform = this.getGenericImageHandler().handleImage(img, imageElement, x, y, img.getWidth(null), img.getHeight(null), this.getGeneratorContext());
        if (xform == null) {
            this.domGroupManager.addElement(imageElement);
        } else {
            AffineTransform inverseTransform = null;
            try {
                inverseTransform = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(xform);
            this.domGroupManager.addElement(imageElement);
            this.gc.transform(inverseTransform);
        }
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        Element imageElement = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform xform = this.getGenericImageHandler().handleImage(img, imageElement, x, y, width, height, this.getGeneratorContext());
        if (xform == null) {
            this.domGroupManager.addElement(imageElement);
        } else {
            AffineTransform inverseTransform = null;
            try {
                inverseTransform = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(xform);
            this.domGroupManager.addElement(imageElement);
            this.gc.transform(inverseTransform);
        }
        return true;
    }

    public void dispose() {
        this.domTreeManager.removeGroupManager(this.domGroupManager);
    }

    public void draw(Shape s) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element svgShape = this.shapeConverter.toSVG(s);
            if (svgShape != null) {
                this.domGroupManager.addElement(svgShape, (short)1);
            }
        } else {
            Shape strokedShape = stroke.createStrokedShape(s);
            this.fill(strokedShape);
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        boolean retVal = true;
        if (xform == null) {
            retVal = this.drawImage(img, 0, 0, null);
        } else if (xform.getDeterminant() != 0.0) {
            AffineTransform inverseTransform = null;
            try {
                inverseTransform = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(xform);
            retVal = this.drawImage(img, 0, 0, null);
            this.gc.transform(inverseTransform);
        } else {
            AffineTransform savTransform = new AffineTransform(this.gc.getTransform());
            this.gc.transform(xform);
            retVal = this.drawImage(img, 0, 0, null);
            this.gc.setTransform(savTransform);
        }
        return retVal;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        img = op.filter(img, null);
        this.drawImage((Image)img, x, y, null);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform trans2) {
        AffineTransform xform;
        Element image = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform trans1 = this.getGenericImageHandler().handleImage(img, image, img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight(), this.getGeneratorContext());
        if (trans2 == null) {
            xform = trans1;
        } else if (trans1 == null) {
            xform = trans2;
        } else {
            xform = new AffineTransform(trans2);
            xform.concatenate(trans1);
        }
        if (xform == null) {
            this.domGroupManager.addElement(image);
        } else if (xform.getDeterminant() != 0.0) {
            AffineTransform inverseTransform = null;
            try {
                inverseTransform = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(xform);
            this.domGroupManager.addElement(image);
            this.gc.transform(inverseTransform);
        } else {
            AffineTransform savTransform = new AffineTransform(this.gc.getTransform());
            this.gc.transform(xform);
            this.domGroupManager.addElement(image);
            this.gc.setTransform(savTransform);
        }
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform trans2) {
        AffineTransform xform;
        Element image = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform trans1 = this.getGenericImageHandler().handleImage(img, image, img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight(), this.getGeneratorContext());
        if (trans2 == null) {
            xform = trans1;
        } else if (trans1 == null) {
            xform = trans2;
        } else {
            xform = new AffineTransform(trans2);
            xform.concatenate(trans1);
        }
        if (xform == null) {
            this.domGroupManager.addElement(image);
        } else if (xform.getDeterminant() != 0.0) {
            AffineTransform inverseTransform = null;
            try {
                inverseTransform = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(xform);
            this.domGroupManager.addElement(image);
            this.gc.transform(inverseTransform);
        } else {
            AffineTransform savTransform = new AffineTransform(this.gc.getTransform());
            this.gc.transform(xform);
            this.domGroupManager.addElement(image);
            this.gc.setTransform(savTransform);
        }
    }

    public void drawString(String s, float x, float y) {
        if (!this.textAsShapes) {
            if (this.generatorCtx.svgFont) {
                this.domTreeManager.gcConverter.getFontConverter().recordFontUsage(s, this.getFont());
            }
            Font font = this.getFont();
            AffineTransform txtTxf = null;
            AffineTransform savTxf = this.getTransform();
            if (font != null) {
                txtTxf = font.getTransform();
                if (txtTxf != null && !txtTxf.isIdentity()) {
                    AffineTransform t = new AffineTransform();
                    t.translate(x, y);
                    t.concatenate(txtTxf);
                    t.translate(-x, -y);
                    this.transform(t);
                } else {
                    txtTxf = null;
                }
            }
            Element text = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
            text.setAttributeNS(null, "x", this.generatorCtx.doubleString(x));
            text.setAttributeNS(null, "y", this.generatorCtx.doubleString(y));
            text.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
            text.appendChild(this.getDOMFactory().createTextNode(s));
            this.domGroupManager.addElement(text, (short)16);
            if (txtTxf != null) {
                this.setTransform(savTxf);
            }
        } else {
            GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), s);
            this.drawGlyphVector(gv, x, y);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    public void fill(Shape s) {
        Element svgShape = this.shapeConverter.toSVG(s);
        if (svgShape != null) {
            this.domGroupManager.addElement(svgShape, (short)16);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }
}

