/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsParserIOdef
implements Comparable<PdsParserIOdef> {
    static Map<String, String> g_sTypeAliases = new HashMap<String, String>();
    private final String m_sDataType;
    private final int m_nSize;
    private final VAL_TYPE m_outType;

    public PdsParserIOdef(String sDataType, int nSize, VAL_TYPE outType) throws IllegalArgumentException {
        if (sDataType.startsWith("ASCII_")) {
            this.m_nSize = 1;
        } else {
            switch (nSize) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: {
                    this.m_nSize = nSize;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only ASCII types may be " + nSize + " bytes long.");
                }
            }
        }
        this.m_outType = outType;
        this.m_sDataType = g_sTypeAliases.get(sDataType);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdsParserIOdef)) {
            return false;
        }
        PdsParserIOdef other = (PdsParserIOdef)o;
        if (this.m_nSize != other.m_nSize) {
            return false;
        }
        if (this.m_outType == null) {
            if (other.m_outType != null) {
                return false;
            }
            if (!this.m_outType.equals((Object)other.m_outType)) {
                return false;
            }
        }
        return this.m_sDataType.equals(other.m_sDataType);
    }

    public int hashCode() {
        int result = 7;
        result = this.m_outType == null ? 37 * result : 37 * result + this.m_outType.ordinal() + 1;
        result = 37 * result + this.m_nSize;
        result = 37 * result + this.m_sDataType.hashCode();
        return result;
    }

    public String toString() {
        if (this.m_outType == null) {
            return this.m_sDataType + ":" + this.m_nSize + ", any";
        }
        return this.m_sDataType + ":" + this.m_nSize + ", " + this.m_outType.toString();
    }

    @Override
    public int compareTo(PdsParserIOdef o) {
        PdsParserIOdef other = o;
        int n = this.m_sDataType.compareTo(other.m_sDataType);
        if (n != 0) {
            return n;
        }
        if (this.m_nSize < other.m_nSize) {
            return -1;
        }
        if (this.m_nSize > other.m_nSize) {
            return 1;
        }
        if (this.m_outType == null || other.m_outType == null) {
            if (this.m_outType == null && other.m_outType == null) {
                return 0;
            }
            if (other.m_outType == null) {
                return -1;
            }
            return 1;
        }
        return this.m_outType.ordinal() - other.m_outType.ordinal();
    }

    public String getPdsType() {
        return this.m_sDataType;
    }

    public int getPdsTypeSize() {
        return this.m_nSize;
    }

    public VAL_TYPE getOutType() {
        return this.m_outType;
    }

    static {
        g_sTypeAliases.put("ASCII_INTEGER", "ASCII_INTEGER");
        g_sTypeAliases.put("ASCII_REAL", "ASCII_REAL");
        g_sTypeAliases.put("ASCII_COMPLEX", "ASCII_COMPLEX");
        g_sTypeAliases.put("MSB_INTEGER", "MSB_INTEGER");
        g_sTypeAliases.put("INTEGER", "MSB_INTEGER");
        g_sTypeAliases.put("MAC_INTEGER", "MSB_INTEGER");
        g_sTypeAliases.put("SUN_INTEGER", "MSB_INTEGER");
        g_sTypeAliases.put("MSB_UNSIGNED_INTEGER", "MSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("UNSIGNED_INTEGER", "MSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("MAC_UNSIGNED_INTEGER", "MSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("SUN_UNSIGNED_INTEGER", "MSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("LSB_INTEGER", "LSB_INTEGER");
        g_sTypeAliases.put("PC_INTEGER", "LSB_INTEGER");
        g_sTypeAliases.put("VAX_INTEGER", "LSB_INTEGER");
        g_sTypeAliases.put("LSB_UNSIGNED_INTEGER", "LSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("PC_UNSIGNED_INTEGER", "LSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("VAX_UNSIGNED_INTEGER", "LSB_UNSIGNED_INTEGER");
        g_sTypeAliases.put("IEEE_REAL", "IEEE_REAL");
        g_sTypeAliases.put("FLOAT", "IEEE_REAL");
        g_sTypeAliases.put("REAL", "IEEE_REAL");
        g_sTypeAliases.put("MAC_REAL", "IEEE_REAL");
        g_sTypeAliases.put("SUN_REAL", "IEEE_REAL");
        g_sTypeAliases.put("IEEE_COMPLEX", "IEEE_COMPLEX");
        g_sTypeAliases.put("COMPLEX", "IEEE_COMPLEX");
        g_sTypeAliases.put("MAC_COMPLEX", "IEEE_COMPLEX");
        g_sTypeAliases.put("SUN_COMPLEX", "IEEE_COMPLEX");
        g_sTypeAliases.put("PC_REAL", "PC_REAL");
        g_sTypeAliases.put("PC_COMPLEX", "PC_COMPLEX");
        g_sTypeAliases.put("VAX_REAL", "VAX_REAL");
        g_sTypeAliases.put("VAXG_REAL", "VAXG_REAL");
        g_sTypeAliases.put("VAX_COMPLEX", "VAX_COMPLEX");
        g_sTypeAliases.put("VAXG_COMPLEX", "VAXG_COMPLEX");
        g_sTypeAliases.put("MSB_BIT_STRING", "MSB_BIT_STRING");
        g_sTypeAliases.put("LSB_BIT_STRING", "LSB_BIT_STRING");
    }
}

