/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.base.TwoNum;
import edu.uiowa.physics.pw.pds.conv.PdsAdapterCreator;
import edu.uiowa.physics.pw.pds.conv.PdsAdapterIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsValParser;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.math.BigDecimal;
import pds.label.PDSException;

public class PdsCbd2fAdapter
extends PdsValAdapter {
    static Creator creator = new Creator();
    public static PdsAdapterIOdef ioDef = new PdsAdapterIOdef(VAL_TYPE.COMP_BIG_DEC, VAL_TYPE.FLOAT);

    public PdsCbd2fAdapter(PdsValParser parser) throws IllegalArgumentException {
        super(VAL_TYPE.COMP_BIG_DEC, parser);
    }

    public Object get(byte[] b) throws PdsRangeException, IndexOutOfBoundsException, PDSException {
        TwoNum in = (TwoNum)this.m_parser.get(b);
        if (((BigDecimal)in.two).compareTo(BIG_DEC_ZERO) != 0) {
            throw new PdsRangeException("Conversion to float impossible, non-zero complex component.");
        }
        float fReal = ((BigDecimal)in.one).floatValue();
        if (fReal == Float.POSITIVE_INFINITY || fReal == Float.NEGATIVE_INFINITY) {
            throw new PdsRangeException("Real component exceeds float value exponent range.");
        }
        return new Float(fReal);
    }

    static class Creator
    implements PdsAdapterCreator {
        Creator() {
        }

        public PdsValAdapter create(PdsValParser parser) throws IllegalArgumentException {
            return new PdsCbd2fAdapter(parser);
        }
    }
}

