/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.base.TwoNum;
import edu.uiowa.physics.pw.pds.conv.PdsParserCreator;
import edu.uiowa.physics.pw.pds.conv.PdsParserIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValParser;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.math.BigDecimal;
import java.math.BigInteger;
import pds.label.PDSException;

public class PdsAi2cbdParser
extends PdsValParser {
    static Creator creator = new Creator();
    public static PdsParserIOdef ioDef = new PdsParserIOdef("ASCII_INTEGER", 1, VAL_TYPE.COMP_BIG_DEC);

    public PdsAi2cbdParser(PdsParserIOdef ioDef) {
        super(ioDef);
        if (ioDef.getOutType() != VAL_TYPE.COMP_BIG_DEC || !ioDef.getPdsType().equals("ASCII_INTEGER")) {
            throw new IllegalArgumentException("Inproper output type specification for parser PdsAi2cbdParser.");
        }
    }

    public Object get(byte[] b) throws PdsRangeException, IndexOutOfBoundsException, PDSException {
        BigInteger biReal;
        try {
            biReal = new BigInteger(this.bytes2Str(b));
        }
        catch (NumberFormatException e) {
            throw new PDSException(e.getMessage());
        }
        return new TwoNum<BigDecimal>(new BigDecimal(biReal), BIG_DEC_ZERO);
    }

    static class Creator
    implements PdsParserCreator {
        Creator() {
        }

        public PdsValParser create(PdsParserIOdef ioDef) {
            return new PdsAi2cbdParser(ioDef);
        }
    }
}

