/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.base.TwoNum;
import edu.uiowa.physics.pw.pds.conv.PdsParserCreator;
import edu.uiowa.physics.pw.pds.conv.PdsParserIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValParser;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.math.BigDecimal;
import pds.label.PDSException;

public class PdsAc2cbdParser
extends PdsValParser {
    static Creator creator = new Creator();
    public static PdsParserIOdef ioDef = new PdsParserIOdef("ASCII_COMPLEX", 1, VAL_TYPE.COMP_BIG_DEC);

    public PdsAc2cbdParser(PdsParserIOdef ioDef) {
        super(ioDef);
        if (ioDef.getOutType() != VAL_TYPE.COMP_BIG_DEC || !ioDef.getPdsType().equals("ASCII_COMPLEX")) {
            throw new IllegalArgumentException("Inproper output type specification for parser PdsAc2cbdParser.");
        }
    }

    public Object get(byte[] b) throws PdsRangeException, IndexOutOfBoundsException, PDSException {
        BigDecimal bdComp;
        BigDecimal bdReal;
        try {
            bdReal = new BigDecimal(this.bytes2Str(b));
            bdComp = new BigDecimal(this.bytes2Str(b));
        }
        catch (NumberFormatException e) {
            throw new PDSException(e.getMessage());
        }
        return new TwoNum<BigDecimal>(bdReal, bdComp);
    }

    static class Creator
    implements PdsParserCreator {
        Creator() {
        }

        public PdsValParser create(PdsParserIOdef ioDef) {
            return new PdsAc2cbdParser(ioDef);
        }
    }
}

