/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.catalog;

import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.catalog.PdsTarget;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSElement;
import pds.label.PDSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsTargetInformation
extends PdsChildObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();

    protected PdsTargetInformation(String sType, PdsObj parent) throws PDSException {
        super(sType, parent);
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public boolean addElement(PDSElement el) throws PDSException {
        if (!super.addElement(el)) {
            return false;
        }
        String sKey = el.mKeyword;
        if (sKey.equals("TARGET_TYPE")) {
            this.m_sName = el.value(0);
        }
        return true;
    }

    static {
        g_reqElements.add("ORBIT_DIRECTION");
        g_reqElements.add("PRIMARY_BODY_NAME");
        g_reqElements.add("ROTATION_DIRECTION");
        g_reqElements.add("TARGET_DESC");
        g_reqElements.add("TARGET_TYPE");
        g_allowedElements.addAll(g_reqElements);
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsTarget) {
                return new PdsTargetInformation("TARGET_INFORMATION", parent);
            }
            throw new PDSException("The parent of a TARGET_INFORMATION object must be a type of TARGET not a " + parent.getType());
        }
    }
}

