/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.catalog;

import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.catalog.PdsMission;
import edu.uiowa.physics.pw.pds.catalog.PdsMissionTarget;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsMissionHost
extends PdsChildObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();

    protected PdsMissionHost(String sType, PdsObj parent) throws PDSException {
        super(sType, parent);
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public boolean addElement(PDSElement el) throws PDSException {
        if (!super.addElement(el)) {
            return false;
        }
        String sKey = el.mKeyword;
        if (sKey.equals("INSTRUMENT_HOST_ID")) {
            this.m_sName = el.value(0);
        }
        return true;
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        String sTargName = (String)this.childNameSet().toArray()[0];
        this.m_sName = this.m_sName + "," + sTargName;
        return ret;
    }

    static {
        g_reqElements.add("INSTRUMENT_HOST_ID");
        g_allowedElements.addAll(g_reqElements);
        g_reqObjects.add(PdsMissionTarget.class);
        g_allowedObjects.addAll(g_reqObjects);
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsMission) {
                return new PdsMissionHost("MISSION_HOST", parent);
            }
            throw new PDSException("The parent of a MISSION_HOST object must be a type of MISSION not a " + parent.getType());
        }
    }
}

