/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.base;

import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import java.io.IOException;
import pds.label.PDSException;

public abstract class PdsDataObj
extends PdsChildObj {
    protected int m_nBaseOffset = 0;
    protected int m_nPrefixSize = 0;
    protected int m_nStepSize = 0;
    protected int m_nItemSize = 0;
    protected int m_iMaxIndex = 0;
    protected int m_iCurIndex = 0;
    protected PdsFile m_file = null;

    public PdsDataObj(String sType, PdsObj parent) throws PDSException {
        super(sType, parent);
        PdsObj obj = parent;
        while (!(obj instanceof PdsFile)) {
            if (obj instanceof PdsChildObj) {
                obj = ((PdsChildObj)parent).getParent();
                continue;
            }
            throw new PDSException("Ultimate parent of " + sType + " must be a PdsFile");
        }
        this.m_file = (PdsFile)obj;
    }

    public void setBaseOffset(int nOffset) throws IllegalArgumentException, IOException, PDSException {
        if (nOffset < 0) {
            throw new IllegalArgumentException("usage error: offsets cannot be negative!");
        }
        this.m_nBaseOffset = nOffset;
        this.setItem(this.m_iCurIndex);
    }

    public int getNumDimensions() {
        if (this.m_iMaxIndex > 0) {
            return 1;
        }
        return 0;
    }

    public int getBaseOffset() {
        return this.m_nBaseOffset;
    }

    public boolean getIndexable() {
        return this.m_iMaxIndex > 0;
    }

    public int size() {
        return this.m_iMaxIndex + 1;
    }

    public int getItemSize() {
        return this.m_nItemSize;
    }

    public void setItem(int iItem) throws ArrayIndexOutOfBoundsException, IOException, PDSException {
        if (iItem > this.m_iMaxIndex || iItem < 0) {
            throw new ArrayIndexOutOfBoundsException("Index " + iItem + "does not exist in " + "object " + this.m_sName + ".  Valid range is 0 to " + this.m_iMaxIndex + ".");
        }
        this.m_iCurIndex = iItem;
        for (PdsChildObj childObj : this.m_objects.values()) {
            if (!(childObj instanceof PdsDataObj)) continue;
            PdsDataObj obj = (PdsDataObj)childObj;
            obj.setBaseOffset(this.readPoint());
        }
    }

    public int getItem() {
        return this.m_iCurIndex;
    }

    public void setRow(int iItem) throws PDSException, IOException {
        this.setItem(iItem);
    }

    public int getRow() {
        return this.m_iCurIndex;
    }

    protected int readPoint() {
        return this.m_nBaseOffset + this.m_nPrefixSize + this.m_nStepSize * this.m_iCurIndex;
    }

    public byte[] getBytes() throws IOException, PDSException {
        return this.m_file.getBytes(this.readPoint(), this.getItemSize());
    }

    public String getString(String sCharset) throws IOException, PDSException {
        return new String(this.getBytes(), sCharset);
    }

    public String getString() throws IOException, PDSException {
        return this.getString("US-ASCII");
    }
}

