/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.PdsIndexTable;
import edu.uiowa.physics.pw.pds.PdsProduct;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.catalog.PdsCatalog;
import edu.uiowa.physics.pw.pds.catalog.PdsDataProducer;
import edu.uiowa.physics.pw.pds.catalog.PdsDataSupplier;
import edu.uiowa.physics.pw.pds.search.PDS_SEARCH_TYPE;
import edu.uiowa.physics.pw.pds.search.PdsRowList;
import edu.uiowa.physics.pw.pds.search.PdsTblSearcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;
import pds.util.PPITime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsVolume
extends PdsObj {
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();
    protected String m_sLblRelDir = "";
    protected String m_sLblBasename = "VOLDESC.CAT";
    protected URL m_urlRoot = null;
    protected FileSystem m_fsRoot = null;
    protected String m_sLocalRoot = null;
    protected List<String> m_dataSets = new ArrayList<String>();
    protected PdsProduct m_indexProd;
    protected PdsIndexTable m_indexTbl;
    protected PdsTblSearcher m_searcher;
    Map<String, PDS_SEARCH_TYPE> m_searchCols;

    @Override
    public PdsVolume getVolume() {
        return this;
    }

    @Override
    public String getLabelRelDir() {
        return this.m_sLblRelDir;
    }

    @Override
    public String getLabelBasename() {
        return this.m_sLblBasename;
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    public PdsVolume(String sVolRoot, ProgressMonitor prog) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(new URL(sVolRoot), prog);
    }

    public PdsVolume(String sVolRoot) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(new URL(sVolRoot), "INDEX/INDEX.LBL", "VOLDESC.CAT", null);
    }

    public PdsVolume(URL volRoot) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(volRoot, "INDEX/INDEX.LBL", "VOLDESC.CAT", null);
    }

    public PdsVolume(URL volRoot, ProgressMonitor prog) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(volRoot, "INDEX/INDEX.LBL", "VOLDESC.CAT", prog);
    }

    public PdsVolume(String sVolRoot, String sIndexPath) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(new URL(sVolRoot), sIndexPath, "VOLDESC.CAT", null);
    }

    public PdsVolume(URL volRoot, String sIndexPath) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        this(volRoot, sIndexPath, "VOLDESC.CAT", null);
    }

    public PdsVolume(URL volRoot, String sIndexPath, String sDescPath, ProgressMonitor prog) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException {
        super("VOLUME");
        String sTmp = volRoot.toExternalForm();
        if (sTmp.length() < 1) {
            throw new MalformedURLException("URL empty!");
        }
        if (sTmp.charAt(sTmp.length() - 1) != '/') {
            throw new MalformedURLException("URL must end in /: " + sTmp);
        }
        if (volRoot.getRef() != null) {
            throw new MalformedURLException("Reference sections not allows in URL");
        }
        this.m_urlRoot = volRoot;
        this.m_fsRoot = FileSystem.create(this.m_urlRoot);
        this.m_sLocalRoot = this.m_fsRoot.getLocalRoot().getAbsolutePath();
        if (prog == null) {
            prog = new NullProgressMonitor();
        }
        this.readVolDesc(sDescPath, prog);
        this.m_indexProd = new PdsProduct(this, sIndexPath, prog);
        if (!this.m_indexProd.m_elements.containsKey("DATA_SET_ID")) {
            this.m_indexProd.pdsExcept("DATA_SET_ID missing.");
        }
        for (int i = 0; i < this.m_indexProd.m_elements.get("DATA_SET_ID").valueSize(); ++i) {
            this.m_dataSets.add(this.m_indexProd.m_elements.get("DATA_SET_ID").value(i));
        }
        PdsFile file = this.m_indexProd.getFile();
        file.mkLocal(prog);
        this.m_indexTbl = (PdsIndexTable)file.sub("INDEX_TABLE");
    }

    protected void readVolDesc(String sDescPath, ProgressMonitor prog) throws FileNotFoundException, IOException, PDSException {
        File fnTmp = new File(sDescPath);
        this.m_sLblBasename = fnTmp.getName();
        this.m_sLblRelDir = fnTmp.getParent();
        this.m_sLblRelDir = this.m_sLblRelDir == null ? "" : this.m_sLblRelDir.replaceAll("\\\\", "/");
        String sLocalPath = this.localFileName(this.getLabelRelPath(), prog);
        PDSLabel label = new PDSLabel();
        PDSElement element = null;
        label.parse(sLocalPath);
        PDSItem item = label.findObject("VOLUME");
        if (item == null && !item.isValid()) {
            this.pdsExcept("does not contain a VOLUME object.");
        }
        if (!(item = label.findItem("PDS_VERSION_ID")).isValid()) {
            this.pdsExcept("doesn't contain PDS_VERSION_ID, is this really a label?");
        }
        this.expandCatalog(label);
        String sKey = null;
        boolean bInsideVolume = false;
        while (item.isValid()) {
            element = label.getElement(item);
            if (element.mType == 4 || element.mType == 3) {
                item = label.nextItem(item);
                continue;
            }
            sKey = element.mKeyword;
            if (sKey.equals("OBJECT") && element.value(0).equals("VOLUME")) {
                bInsideVolume = true;
                item = label.nextItem(item);
                continue;
            }
            if (!bInsideVolume) {
                item = label.nextItem(item);
                continue;
            }
            if (element.mKeyword.equals("OBJECT")) {
                item = this.parseSubObject(label, item);
                continue;
            }
            item = label.nextItem(item);
            if (this.addElement(element)) continue;
            break;
        }
    }

    private void expandCatalog(PDSLabel label) throws FileNotFoundException, PDSException, IOException {
        PDSItem searchItem;
        while ((searchItem = label.findItem("^*CATALOG")).isValid()) {
            for (int i = 0; i < label.getElement(searchItem).valueSize(); ++i) {
                String sLocalCatFilePath;
                String sFile = label.getElement(searchItem).value(i);
                try {
                    sLocalCatFilePath = this.getVolume().localFileName(this.m_sLblRelDir + "/" + sFile);
                }
                catch (FileNotFoundException e) {
                    sLocalCatFilePath = this.getVolume().localFileName("CATALOG/" + sFile);
                }
                PDSLabel catLabel = new PDSLabel();
                try {
                    catLabel.parse(sLocalCatFilePath);
                }
                catch (PDSException e) {
                    throw new PDSException("FILE: " + sLocalCatFilePath + "  " + e.toString());
                }
                PDSItem rmItem = catLabel.findItem("PDS_VERSION_ID");
                while (rmItem.isValid()) {
                    catLabel.remove(rmItem);
                    rmItem = catLabel.findItem("PDS_VERSION_ID");
                }
                rmItem = catLabel.findItem("RECORD_TYPE");
                while (rmItem.isValid()) {
                    catLabel.remove(rmItem);
                    rmItem = catLabel.findItem("RECORD_TYPE");
                }
                rmItem = catLabel.findItem("RECORD_BYTES");
                while (rmItem.isValid()) {
                    catLabel.remove(rmItem);
                    rmItem = catLabel.findItem("RECORD_BYTES");
                }
                rmItem = catLabel.findItem("LABEL_REVISION_NOTE");
                while (rmItem.isValid()) {
                    catLabel.remove(rmItem);
                    rmItem = catLabel.findItem("LABEL_REVISION_NOTE");
                }
                label.insertAfter(searchItem, catLabel);
            }
            label.remove(searchItem);
        }
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        return ret;
    }

    public URL getRoot() {
        return this.m_urlRoot;
    }

    public URL fileURL(String sRelPath) throws MalformedURLException {
        URL url = new URL(this.m_urlRoot.toExternalForm() + sRelPath);
        return url;
    }

    public String localFileName(String sRelPath) throws FileNotFoundException, IOException {
        return this.localFileName(sRelPath, new NullProgressMonitor());
    }

    public String localFileName(String sRelPath, ProgressMonitor progMon) throws FileNotFoundException, IOException {
        return this.m_fsRoot.getFileObject(sRelPath).getFile(progMon).getPath();
    }

    public boolean isLocalFile(String sRelPath) {
        return true;
    }

    public void mkLocal(String sRelPath, ProgressMonitor progMon) throws FileNotFoundException, IOException {
        if (!this.isLocalFile(sRelPath)) {
            this.m_fsRoot.getFileObject(sRelPath).getFile(progMon);
        }
    }

    public void mkLocal(String sRelPath) throws FileNotFoundException, IOException {
        if (!this.isLocalFile(sRelPath)) {
            this.m_fsRoot.getFileObject(sRelPath).getFile();
        }
    }

    public FileChannel getChannel(String sRelPath) throws FileNotFoundException, IOException {
        FileObject fileObj = this.m_fsRoot.getFileObject(sRelPath);
        return (FileChannel)fileObj.getChannel();
    }

    public List<String> getProdByTimeRng(String sBegin, String sEnd) throws PDSException, IOException, IllegalArgumentException {
        if (this.m_dataSets.size() != 1) {
            throw new PDSException("Library usage error: can not use this function on multi-dataset volumes.");
        }
        if (this.m_searcher == null) {
            this.m_searcher = this.m_indexTbl.getSearcher();
            this.m_searchCols = this.m_searcher.getSearchCols();
        }
        if (!this.m_searchCols.containsKey("START_TIME")) {
            throw new UnsupportedOperationException("Index file does not have a start time column, can not get prod by time range.");
        }
        PPITime tStart = new PPITime();
        PPITime tEnd = new PPITime();
        if (!tStart.convert("T", sBegin)) {
            throw new IllegalArgumentException("Could not convert " + sBegin + " to a timestamp.");
        }
        if (!tEnd.convert("T", sEnd)) {
            throw new IllegalArgumentException("Could not convert " + sEnd + " to a timestamp.");
        }
        PdsRowList rl = this.m_searcher.findGtEq("START_TIME", tStart).AND(this.m_searcher.findLt("START_TIME", tEnd));
        if (this.m_searchCols.containsKey("STOP_TIME")) {
            PdsRowList rlEnd = this.m_searcher.findGt("STOP_TIME", tStart).AND(this.m_searcher.findLtEq("STOP_TIME", tEnd));
            rl.OR(rlEnd);
            rlEnd = this.m_searcher.findLt("START_TIME", tStart).AND(this.m_searcher.findGtEq("STOP_TIME", tEnd));
            rl.OR(rlEnd);
        }
        return this.m_indexTbl.getProducts(rl);
    }

    public PdsIndexTable getIndexTable() {
        return this.m_indexTbl;
    }

    public PdsProduct getProduct(String sRelPath, ProgressMonitor mon) throws FileNotFoundException, PDSException, IOException {
        return new PdsProduct(this, sRelPath, mon);
    }

    public PdsProduct getProduct(String sRelPath) throws FileNotFoundException, PDSException, IOException {
        return this.getProduct(sRelPath, new NullProgressMonitor());
    }

    public String getRootStr() {
        return this.m_urlRoot.toExternalForm();
    }

    static {
        g_reqElements.add("DATA_SET_ID");
        g_reqElements.add("DESCRIPTION");
        g_reqElements.add("MEDIUM_TYPE");
        g_reqElements.add("PUBLICATION_DATE");
        g_reqElements.add("VOLUME_FORMAT");
        g_reqElements.add("VOLUME_ID");
        g_reqElements.add("VOLUME_NAME");
        g_reqElements.add("VOLUME_SERIES_NAME");
        g_reqElements.add("VOLUME_SET_NAME");
        g_reqElements.add("VOLUME_SET_ID");
        g_reqElements.add("VOLUME_VERSION_ID");
        g_reqElements.add("VOLUMES");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("BLOCK_BYTES");
        g_allowedElements.add("DATA_SET_COLLECTION_ID");
        g_allowedElements.add("DD_VERSION_ID");
        g_allowedElements.add("DESCRIPTION");
        g_allowedElements.add("FILES");
        g_allowedElements.add("HARDWARE_MODEL_ID");
        g_allowedElements.add("LOGICAL_VOLUME_PATH_NAME");
        g_allowedElements.add("LOGICAL_VOLUMES");
        g_allowedElements.add("MEDIUM_FORMAT");
        g_allowedElements.add("NOTE");
        g_allowedElements.add("OPERATING_SYSTEM_ID");
        g_allowedElements.add("PRODUCT_TYPE");
        g_allowedElements.add("TRANSFER_COMMAND_TEXT");
        g_allowedElements.add("VOLUME_INSERT_TEXT");
        g_reqObjects.add(PdsCatalog.class);
        g_reqObjects.add(PdsDataProducer.class);
        g_allowedObjects.addAll(g_reqObjects);
        g_allowedObjects.add(PdsDataSupplier.class);
    }
}

