/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.PdsContainer;
import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsTable
extends PdsDataObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> m_allowedElements = new ArrayList<String>();
    public static List<String> m_reqElements = new ArrayList<String>();
    public static List<Class> m_allowedObjects = new ArrayList<Class>();
    public static List<Class> m_reqObjects = new ArrayList<Class>();

    public PdsTable(String sType, PdsFile parent) throws PDSException {
        super(sType, parent);
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return m_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return m_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return m_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return m_reqObjects;
    }

    @Override
    public void validate() throws PDSException {
        super.validate();
        if (!this.singleVal("INTERCHANGE_FORMAT").equals("ASCII") && !this.singleVal("INTERCHANGE_FORMAT").equals("BINARY")) {
            this.pdsExcept("INTERCHANGE_FORMAT must be ASCII or BINARY");
        }
        if (this.hasKeyword("TABLE_STORAGE_TYPE") && !this.singleVal("TABLE_STORAGE_TYPE").equals("ROW MAJOR")) {
            throw new UnsupportedOperationException("Column major tables are not currently supported.");
        }
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        if (this.hasKeyword("ROW_PREFIX_BYTES")) {
            this.m_nPrefixSize = this.positiveSingleVal("ROW_PREFIX_BYTES");
        }
        this.m_nItemSize = this.positiveSingleVal("ROW_BYTES");
        this.m_nStepSize = this.m_nPrefixSize + this.m_nItemSize;
        if (this.hasKeyword("ROW_SUFFIX_BYTES")) {
            int nInc = this.intSingleVal("ROW_SUFFIX_BYTES");
            if (nInc < 0) {
                this.pdsExcept("Value ROW_SUFFIX_BYTES in " + this + " is less than 0.");
            }
            this.m_nStepSize += nInc;
        }
        this.m_iMaxIndex = this.positiveSingleVal("ROWS") - 1;
        return ret;
    }

    public PdsColumn subCol(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsColumn)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of COLUMN");
        }
        return (PdsColumn)obj;
    }

    static {
        m_reqElements.add("INTERCHANGE_FORMAT");
        m_reqElements.add("ROWS");
        m_reqElements.add("COLUMNS");
        m_reqElements.add("ROW_BYTES");
        m_allowedElements.addAll(m_reqElements);
        m_allowedElements.add("NAME");
        m_allowedElements.add("DESCRIPTION");
        m_allowedElements.add("ROW_PREFIX_BYTES");
        m_allowedElements.add("ROW_SUFFIX_BYTES");
        m_allowedElements.add("TABLE_STORAGE_TYPE");
        m_reqObjects.add(PdsColumn.class);
        m_allowedObjects.addAll(m_reqObjects);
        m_allowedObjects.add(PdsContainer.class);
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsFile) {
                return new PdsTable("TABLE", (PdsFile)parent);
            }
            throw new PDSException("The parent of a TABLE object must be a FILE not a " + parent.getType());
        }
    }
}

