/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsField;
import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.search.PdsSimpleTblSearcher;
import edu.uiowa.physics.pw.pds.search.PdsTblSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsSpreadsheet
extends PdsDataObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> m_allowedElements = new ArrayList<String>();
    public static List<String> m_reqElements = new ArrayList<String>();
    public static List<Class> m_allowedObjects = new ArrayList<Class>();
    public static List<Class> m_reqObjects = new ArrayList<Class>();
    protected static byte[] m_CRLF = new byte[2];
    protected Vector<RowOffsets> m_vRowPos = null;
    protected PdsField[] m_fieldsAry = null;
    protected char m_cDelim = '\u0000';
    private PdsTblSearcher m_searcher = null;
    protected int m_nMaxRowLen = 0;

    public PdsSpreadsheet(String sType, PdsFile parent) throws PDSException {
        super(sType, parent);
        this.m_nItemSize = -1;
        this.m_nStepSize = -1;
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return m_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return m_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return m_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return m_reqObjects;
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        String sDelim;
        PDSItem ret = super.parse(label, item);
        int nRows = this.positiveSingleVal("ROWS");
        if (nRows < 1) {
            this.pdsExcept("ROWS value for " + this.m_sType + " " + this.m_sName + " must be greater than 0.");
        }
        this.m_iMaxIndex = nRows - 1;
        this.m_vRowPos = new Vector();
        this.m_nMaxRowLen = this.positiveSingleVal("ROW_BYTES");
        if (this.m_nMaxRowLen < 3) {
            this.pdsExcept("ROW_BYTES cannot be less than 3 for a valid SPREADSHEET object.");
        }
        if ((sDelim = this.singleVal("FIELD_DELIMITER")).equals("COMMA")) {
            this.m_cDelim = (char)44;
        } else if (sDelim.equals("SEMICOLON")) {
            this.m_cDelim = (char)59;
        } else if (sDelim.equals("TAB")) {
            this.m_cDelim = (char)9;
        } else if (sDelim.equals("VERTICAL_BAR")) {
            this.m_cDelim = (char)124;
        } else {
            this.pdsExcept("Unrecoginzed FIELD_DELIMITER value '" + sDelim + "'.");
        }
        this.m_fieldsAry = new PdsField[this.m_objects.size()];
        for (int i = 0; i < this.m_fieldsAry.length; ++i) {
            this.m_fieldsAry[i] = null;
        }
        for (PdsChildObj childObj : this.m_objects.values()) {
            PdsField field;
            int i;
            if (!(childObj instanceof PdsField)) {
                this.pdsExcept("SPREADSHEETs expect child objects to be FIELDs not " + childObj.getName() + "s");
            }
            if ((i = (field = (PdsField)childObj).positiveSingleVal("FIELD_NUMBER") - 1) > this.m_iMaxIndex || i < 0) {
                this.pdsExcept("field " + field.getName() + "'s FIELD_NUMBER is out of range.");
            }
            if (this.m_fieldsAry[i] == null) {
                this.m_fieldsAry[i] = field;
                continue;
            }
            this.pdsExcept("FIELDs " + field.getName() + " and " + this.m_fieldsAry[i].getName() + " have the same FIELD_NUMBER.");
        }
        this.m_iCurIndex = 0;
        return ret;
    }

    @Override
    public void setItem(int iItem) throws ArrayIndexOutOfBoundsException, IOException, PDSException {
        int i;
        if (iItem > this.m_iMaxIndex || iItem < 0) {
            throw new ArrayIndexOutOfBoundsException("Index " + iItem + "does not exist in " + "object " + this.m_sName + ".  Valid range is 0 to " + this.m_iMaxIndex + ".");
        }
        this.m_iCurIndex = iItem;
        this.updateRowOffsetsTo(iItem);
        char[] cRow = this.getString().toCharArray();
        boolean bEscaped = false;
        this.m_fieldsAry[0].setBaseOffset(this.readPoint());
        int iField = 0;
        int iRemainingSubFields = 0;
        for (i = 0; i < cRow.length; ++i) {
            if (cRow[i] == '\"') {
                boolean bl = bEscaped = !bEscaped;
            }
            if (bEscaped || cRow[i] != this.m_cDelim) continue;
            if (iRemainingSubFields != 0) {
                --iRemainingSubFields;
                continue;
            }
            if (iField >= this.m_fieldsAry.length - 1) {
                throw new PDSException(this.m_file.getDataRelPath() + ": Too many FIELDs in row" + (iItem + 1) + " of " + this.getName() + ".");
            }
            if (++iField > 0) {
                this.m_fieldsAry[iField - 1].setEndOffset(this.readPoint() + i - 1, this.m_cDelim);
            }
            this.m_fieldsAry[iField].setBaseOffset(this.readPoint() + i + 1);
            iRemainingSubFields = this.m_fieldsAry[iField].size() - 1;
        }
        this.m_fieldsAry[iField].setEndOffset(this.readPoint() + i - 1, this.m_cDelim);
        if (iField != this.m_fieldsAry.length - 1) {
            throw new PDSException(this.m_file.getDataRelPath() + ": Missing FIELDs in row " + (iItem + 1) + " of " + this.getType() + " " + this.getName() + ".  Could be a missing comma or quote, " + "or the object pointer in the label could be off.");
        }
    }

    @Override
    protected int readPoint() {
        return this.m_nBaseOffset + this.m_vRowPos.get((int)this.m_iCurIndex).iStart;
    }

    @Override
    public int getItemSize() {
        return this.m_vRowPos.get(this.m_iCurIndex).rowSize();
    }

    protected void updateRowOffsetsTo(int iItem) throws IOException, PDSException {
        int nSize;
        if (iItem > this.m_iMaxIndex) {
            throw new ArrayIndexOutOfBoundsException("Item index " + iItem + " out of range" + " 0 to " + this.m_iMaxIndex);
        }
        if (this.m_vRowPos.size() == 0) {
            RowOffsets ro = new RowOffsets(0, 0);
            nSize = this.m_file.getSizeUntil(this.m_nBaseOffset, m_CRLF, this.m_nMaxRowLen);
            ro.iEnd = nSize - 1;
            this.m_vRowPos.add(ro);
        }
        for (int i = this.m_vRowPos.size(); i <= iItem; ++i) {
            int iStart = this.m_vRowPos.get((int)(i - 1)).iEnd + 3;
            nSize = this.m_file.getSizeUntil(this.m_nBaseOffset + iStart, m_CRLF, this.m_nMaxRowLen);
            RowOffsets ro = new RowOffsets(iStart, iStart + nSize - 1);
            this.m_vRowPos.add(ro);
        }
    }

    public PdsField subField(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsField)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of FIELD");
        }
        return (PdsField)obj;
    }

    public PdsTblSearcher getSearcher(ArrayList<String> exclude) {
        if (this.m_searcher == null) {
            this.m_searcher = new PdsSimpleTblSearcher(this, exclude);
        }
        return this.m_searcher;
    }

    public PdsTblSearcher getSearcher() {
        ArrayList<String> exclude = new ArrayList<String>();
        for (PdsChildObj child : this.m_objects.values()) {
            PdsField field;
            if (!(child instanceof PdsField) || (field = (PdsField)child).size() <= 1) continue;
            exclude.add(field.getName());
        }
        if (this.m_searcher == null) {
            this.m_searcher = new PdsSimpleTblSearcher(this, exclude);
        }
        return this.m_searcher;
    }

    static {
        m_reqElements.add("ROWS");
        m_reqElements.add("ROW_BYTES");
        m_reqElements.add("FIELDS");
        m_reqElements.add("FIELD_DELIMITER");
        m_allowedElements.addAll(m_reqElements);
        m_allowedElements.add("NAME");
        m_allowedElements.add("DESCRIPTION");
        m_allowedElements.add("PSDD");
        m_reqObjects.add(PdsField.class);
        m_allowedObjects.addAll(m_reqObjects);
        PdsSpreadsheet.m_CRLF[0] = 13;
        PdsSpreadsheet.m_CRLF[1] = 10;
    }

    protected class RowOffsets {
        public int iStart = 0;
        public int iEnd = 0;

        public RowOffsets(int start, int end) {
            this.iStart = start;
            this.iEnd = end;
        }

        public int rowSize() {
            return this.iEnd - this.iStart + 1;
        }
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsFile) {
                return new PdsSpreadsheet("SPREADSHEET", (PdsFile)parent);
            }
            throw new PDSException("The parent of a SPREADSHEET object must be a FILE not a " + parent.getType());
        }
    }
}

