/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsIndexTable;
import edu.uiowa.physics.pw.pds.PdsSeries;
import edu.uiowa.physics.pw.pds.PdsSpreadsheet;
import edu.uiowa.physics.pw.pds.PdsTable;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsFile
extends PdsChildObj {
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    protected String m_sDataRelDir = null;
    protected String m_sDataBasename = null;
    protected boolean m_bAttachedFile = false;
    protected FileChannel m_channel = null;
    protected MappedByteBuffer m_buffer = null;
    protected PdsFileParseState m_parseState = null;

    public String getDataBasename() {
        return this.m_sDataBasename;
    }

    public String getDataRelDir() {
        return this.m_sDataRelDir;
    }

    public String getDataRelPath() {
        if (this.getDataRelDir() == "") {
            return this.getDataBasename();
        }
        return this.getDataRelDir() + "/" + this.getDataBasename();
    }

    protected PdsFile(PdsObj parent) throws PDSException {
        super("FILE", parent);
    }

    @Override
    public String getLabelRelPath() {
        return this.m_parent.getLabelRelPath();
    }

    @Override
    public boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    public boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return new ArrayList<Class>();
    }

    public void pdsDataExcept(String sMsg) throws PDSException {
        throw new PDSException(this.getDataRelPath() + ":  " + sMsg);
    }

    protected void parseSetup() {
        this.m_parseState = new PdsFileParseState();
    }

    protected ParseElementOrObject_ret parseElementOrObject(PDSLabel label, PDSItem item) throws PDSException {
        PDSElement element = label.getElement(item);
        String sKey = element.mKeyword;
        if (sKey.equals("OBJECT")) {
            return new ParseElementOrObject_ret(this.parseSubObject(label, item), true);
        }
        if (sKey.charAt(0) == '^' && PdsFile.ptrType(sKey) == PdsObj.PdsPtrType.DATA) {
            String sPtrName = sKey.substring(1);
            if (this.m_parseState.sSubNames.contains(sPtrName)) {
                this.pdsExcept("Duplicate pointer name " + sPtrName + " encountered");
            }
            this.m_parseState.sSubNames.add(sPtrName);
            if (element.valueSize() > 1) {
                this.m_sDataBasename = element.value(0);
                this.m_bAttachedFile = false;
                int nVal = Integer.parseInt(element.value(1));
                this.m_parseState.nSubOffsets.add(nVal - 1);
                if (element.units(1).equals("BYTES")) {
                    this.m_parseState.bSubOffsetInRecs.add(false);
                } else {
                    this.m_parseState.bSubOffsetInRecs.add(true);
                }
            } else {
                String sVal = element.value(0);
                boolean bIsInt = true;
                for (int i = 0; i < sVal.length(); ++i) {
                    if (Character.isDigit(sVal.charAt(i))) continue;
                    bIsInt = false;
                    break;
                }
                if (bIsInt || sVal.endsWith("<BYTES>")) {
                    this.m_sDataBasename = this.getLabelBasename();
                    this.m_bAttachedFile = true;
                    if (bIsInt) {
                        this.m_parseState.nSubOffsets.add(Integer.parseInt(sVal));
                        this.m_parseState.bSubOffsetInRecs.add(false);
                    } else {
                        String sTmp = sVal.substring(0, sVal.lastIndexOf(60));
                        this.m_parseState.nSubOffsets.add(Integer.parseInt(sTmp));
                        this.m_parseState.bSubOffsetInRecs.add(true);
                    }
                } else {
                    this.m_sDataBasename = element.value(0);
                    this.m_bAttachedFile = false;
                    this.m_parseState.nSubOffsets.add(0);
                    this.m_parseState.bSubOffsetInRecs.add(false);
                }
            }
            this.m_sDataRelDir = this.m_parent.getLabelRelDir();
            return new ParseElementOrObject_ret(label.nextItem(item), true);
        }
        if (this.addElement(element)) {
            return new ParseElementOrObject_ret(label.nextItem(item), true);
        }
        return new ParseElementOrObject_ret(label.nextItem(item), false);
    }

    protected void parseFinish() throws PDSException {
        if (PdsObj.g_bValidate) {
            this.validate();
        }
        for (Map.Entry entry : this.m_objects.entrySet()) {
            String sName = (String)entry.getKey();
            PdsDataObj obj = (PdsDataObj)entry.getValue();
            int i = this.m_parseState.sSubNames.indexOf(sName);
            if (i == -1) {
                int nTmp = 0;
                for (PdsChildObj objCheck : this.m_objects.values()) {
                    if (!obj.getClass().isInstance(objCheck)) continue;
                    ++nTmp;
                }
                if (nTmp > 1) {
                    this.pdsExcept("Ambiguous " + obj.getType() + " pointer, use the form NAME_TYPE " + "for the pointer name.");
                }
                if ((i = this.m_parseState.sSubNames.indexOf(obj.getType())) == -1) {
                    this.pdsExcept("Couldn't find data file pointer for " + obj.getType() + " " + sName);
                }
            }
            int nOffset = this.m_parseState.nSubOffsets.get(i);
            if (this.m_parseState.bSubOffsetInRecs.get(i).booleanValue() && nOffset != 0) {
                nOffset *= Integer.parseInt(((PDSElement)this.m_elements.get("RECORD_BYTES")).value(0));
            }
            try {
                obj.setBaseOffset(nOffset);
            }
            catch (IOException ex) {
                this.pdsExcept(ex.toString());
            }
        }
        this.m_parseState = null;
    }

    public boolean isAttached() {
        return this.m_bAttachedFile;
    }

    protected void _checkReqHelper(String sKey, String sType) throws PDSException {
        if (!this.m_elements.containsKey(sKey)) {
            this.pdsExcept("Files of type " + sType + " require the " + sKey + " keyword");
        }
    }

    protected void _checkReqHelper_na(String sKey, String sType) throws PDSException {
        if (this.m_elements.containsKey(sKey)) {
            this.pdsExcept("For files of type " + sType + " the keyword" + sKey + " is not applicable");
        }
    }

    @Override
    public void validate() throws PDSException {
        String sVal;
        if (!this.m_elements.containsKey("RECORD_TYPE")) {
            this.pdsExcept("Missing required keyword RECORD_TYPE");
        }
        if ((sVal = ((PDSElement)this.m_elements.get("RECORD_TYPE")).value(0)).equals("FIXED_LENGTH")) {
            this._checkReqHelper("RECORD_BYTES", sVal);
            this._checkReqHelper("FILE_RECORDS", sVal);
            if (this.m_bAttachedFile) {
                this._checkReqHelper("LABEL_RECORDS", sVal);
            } else {
                this._checkReqHelper_na("LABEL_RECORDS", sVal);
            }
            return;
        }
        if (sVal.equals("VARIABLE_LENGTH")) {
            this._checkReqHelper("RECORD_BYTES", sVal);
            this._checkReqHelper("FILE_RECORDS", sVal);
            if (this.m_bAttachedFile) {
                this._checkReqHelper("LABEL_RECORDS", sVal);
            } else {
                this._checkReqHelper_na("LABEL_RECORDS", sVal);
            }
            return;
        }
        if (sVal.equals("STREAM") && !this.m_bAttachedFile) {
            this._checkReqHelper_na("RECORD_BYTES", sVal);
            this._checkReqHelper_na("LABEL_RECORDS", sVal);
            return;
        }
        if (sVal.equals("UNDEFINED")) {
            this._checkReqHelper_na("RECORD_BYTES", sVal);
            this._checkReqHelper_na("FILE_RECORDS", sVal);
            this._checkReqHelper_na("LABEL_RECORDS", sVal);
            return;
        }
        this.pdsExcept("invalid RECORD_TYPE " + sVal);
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        this.parseSetup();
        while (item.isValid()) {
            PDSElement element = label.getElement(item);
            if (element.mType < 3) {
                item = label.nextItem(item);
                continue;
            }
            ParseElementOrObject_ret tup = this.parseElementOrObject(label, item);
            item = tup.item;
            if (tup.more) continue;
        }
        this.parseFinish();
        return item;
    }

    public byte[] getBytes(int iOffset, int nSize) throws IOException, PDSException {
        try {
            this.open();
            this.m_buffer.position(iOffset);
            byte[] dest = new byte[nSize];
            this.m_buffer.get(dest);
            return dest;
        }
        catch (IllegalArgumentException ex) {
            IllegalArgumentException ex2 = new IllegalArgumentException(this.getDataRelPath() + ": Error accessing file data");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public int getSizeUntil(int iOffset, byte[] stopBytes, int nLimit) throws IOException, PDSException {
        this.open();
        if (stopBytes == null || stopBytes.length < 1) {
            throw new IllegalArgumentException("stopBytes null or length is 0");
        }
        if (nLimit < 2) {
            throw new IllegalArgumentException("nLimit must be >= 2");
        }
        byte[] test = new byte[stopBytes.length];
        this.m_buffer.position(iOffset);
        int nSize = 0;
        try {
            this.m_buffer.get(test);
            while (!Arrays.equals(test, stopBytes)) {
                if (nSize + stopBytes.length > nLimit) {
                    this.pdsDataExcept("Pattern '" + stopBytes + "' not found within " + nLimit + "bytes starting at index " + iOffset);
                }
                this.m_buffer.position(iOffset + nSize + 1);
                ++nSize;
                this.m_buffer.get(test);
            }
        }
        catch (BufferUnderflowException ex) {
            this.pdsDataExcept("Pattern '" + stopBytes + "' not found before the end of the file.");
        }
        catch (IllegalArgumentException ex) {
            this.pdsDataExcept("Pattern '" + stopBytes + "' not found before the end of the file.");
        }
        return nSize;
    }

    public int getSizeUntilOrEnd(int iOffset, byte[] stopBytes, int nLimit) throws IOException, PDSException, IllegalArgumentException {
        int nSize;
        this.open();
        if (stopBytes == null || stopBytes.length < 1) {
            throw new IllegalArgumentException("stopBytes null or length is 0");
        }
        if (nLimit < 2) {
            throw new IllegalArgumentException("nLimit must be >= 2");
        }
        byte[] test = new byte[stopBytes.length];
        this.m_buffer.position(iOffset);
        try {
            this.m_buffer.get(test);
            for (nSize = 0; !Arrays.equals(test, stopBytes) && nSize <= nLimit; ++nSize) {
                this.m_buffer.position(iOffset + nSize + 1);
                this.m_buffer.get(test);
            }
        }
        catch (BufferUnderflowException ex) {
            nSize += stopBytes.length - 1;
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        return nSize;
    }

    public boolean isLocal() throws PDSException {
        return this.getVolume().isLocalFile(this.getDataRelPath());
    }

    public void mkLocal() throws FileNotFoundException, IOException, PDSException {
        this.mkLocal(new NullProgressMonitor());
    }

    public void mkLocal(ProgressMonitor prog) throws FileNotFoundException, IOException, PDSException {
        this.getVolume().mkLocal(this.getDataRelPath(), prog);
    }

    public void open() throws IOException, PDSException {
        if (this.m_channel == null) {
            this.m_channel = this.getVolume().getChannel(this.getDataRelPath());
            long lSz = 0L;
            long lChSz = 0L;
            if (this.hasKeyword("FILE_RECORDS") && this.hasKeyword("RECORD_BYTES")) {
                lSz = this.positiveSingleVal("FILE_RECORDS") * this.positiveSingleVal("RECORD_BYTES");
                lChSz = this.m_channel.size();
                if (lChSz != lSz) {
                    this.pdsExcept("This file is " + lChSz + " bytes long, but FILE_RECORDS * " + "RECORD_BYTES = " + lSz + " bytes!");
                }
            }
            this.m_buffer = this.m_channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.m_channel.size());
        }
    }

    public void close() throws IOException {
        if (this.m_channel != null) {
            this.m_buffer = null;
            this.m_channel.close();
            this.m_channel = null;
        }
    }

    public PdsTable subTbl(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsTable)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of TABLE");
        }
        return (PdsTable)obj;
    }

    public PdsSeries subSeries(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsSeries)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of SERIES");
        }
        return (PdsSeries)obj;
    }

    public PdsSpreadsheet subSpreadsheet(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsSpreadsheet)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of SPREADSHEET");
        }
        return (PdsSpreadsheet)obj;
    }

    static {
        g_reqElements.add("RECORD_TYPE");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("RECORD_BYTES");
        g_allowedElements.add("FILE_RECORDS");
        g_allowedElements.add("LABEL_RECORDS");
        g_allowedElements.add("DESCRIPTION");
        g_allowedElements.add("ENCODING_TYPE");
        g_allowedElements.add("FILE_NAME");
        g_allowedElements.add("INTERCHANGE_FORMAT");
        g_allowedElements.add("REQUIRED_STORAGE_BYTES");
        g_allowedElements.add("SEQUENCE_NUMBER");
        g_allowedElements.add("UNCOMPRESSED_FILE_NAME");
        g_allowedObjects.add(PdsIndexTable.class);
        g_allowedObjects.add(PdsSeries.class);
        g_allowedObjects.add(PdsSpreadsheet.class);
        g_allowedObjects.add(PdsTable.class);
    }

    public class ParseElementOrObject_ret {
        public PDSItem item;
        public boolean more;

        public ParseElementOrObject_ret(PDSItem one, boolean two) {
            this.item = one;
            this.more = two;
        }
    }

    protected class PdsFileParseState {
        protected List<String> sSubNames = new ArrayList<String>();
        protected List<Integer> nSubOffsets = new ArrayList<Integer>();
        protected List<Boolean> bSubOffsetInRecs = new ArrayList<Boolean>();

        protected PdsFileParseState() {
        }
    }
}

