/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsAlias;
import edu.uiowa.physics.pw.pds.PdsBitColumn;
import edu.uiowa.physics.pw.pds.PdsContainer;
import edu.uiowa.physics.pw.pds.PdsTable;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsNumericObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsColumn
extends PdsNumericObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();

    public PdsColumn(String sType, PdsDataObj parent) throws PDSException {
        super(sType, parent);
        if (!(parent instanceof PdsTable) && !(parent instanceof PdsContainer)) {
            throw new PDSException("COLUMNs expect to children of TABLEs or CONTAINERS not " + parent.getType());
        }
    }

    @Override
    public boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    public boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    public void validate() throws PDSException {
        super.validate();
        if (!this.hasKeyword("BYTES") && !this.hasKeyword("ITEM_BYTES")) {
            this.pdsExcept("either BYTES or ITEM_BYTES must be specified");
        }
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        this.m_sDataType = this.singleVal("DATA_TYPE");
        this.m_nPrefixSize = this.positiveSingleVal("START_BYTE") - 1;
        if (this.hasKeyword("ITEMS")) {
            this.m_iMaxIndex = this.positiveSingleVal("ITEMS") - 1;
            if (this.hasKeyword("ITEM_BYTES")) {
                this.m_nItemSize = this.positiveSingleVal("ITEM_BYTES");
            } else {
                if (!this.hasKeyword("BYTES")) {
                    this.pdsExcept("At lease one of BYTES or ITEM_BYTES must be specifiedin " + this.m_sType + " " + this.m_sName);
                }
                this.m_nItemSize = this.positiveSingleVal("BYTES") / this.positiveSingleVal("ITEMS");
            }
            this.m_nStepSize = this.hasKeyword("ITEM_OFFSET") ? this.positiveSingleVal("ITEM_OFFSET") : this.m_nItemSize;
        } else {
            this.m_nItemSize = this.positiveSingleVal("BYTES");
        }
        this.m_iCurIndex = 0;
        return ret;
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    public PdsBitColumn subBitCol(String sObj) throws PDSException {
        PdsChildObj obj = this.sub(sObj);
        if (!(obj instanceof PdsBitColumn)) {
            this.pdsExcept(sObj + " is a " + obj.getType() + " which is not a type of BIT_COLUMN");
        }
        return (PdsBitColumn)obj;
    }

    public void adjStartByte(int i) {
        this.m_nPrefixSize += i;
    }

    static {
        g_reqElements.add("NAME");
        g_reqElements.add("DATA_TYPE");
        g_reqElements.add("START_BYTE");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("BIT_MASK");
        g_allowedElements.add("BYTES");
        g_allowedElements.add("COLUMN_NUMBER");
        g_allowedElements.add("DERIVED_MAXIMUM");
        g_allowedElements.add("DESCRIPTION");
        g_allowedElements.add("FORMAT");
        g_allowedElements.add("INVALID_CONSTANT");
        g_allowedElements.add("ITEM_BYTES");
        g_allowedElements.add("ITEM_OFFSET");
        g_allowedElements.add("ITEMS");
        g_allowedElements.add("MAXIMUM");
        g_allowedElements.add("MAXIMUM_SAMPLING_PARAMETER");
        g_allowedElements.add("MINIMUM");
        g_allowedElements.add("MINIMUM_SAMPLING_PARAMETER");
        g_allowedElements.add("MISSING_CONSTANT");
        g_allowedElements.add("OFFSET");
        g_allowedElements.add("SAMPLING_PARAMETER_INTERVAL");
        g_allowedElements.add("SAMPLING_PARAMETER_NAME");
        g_allowedElements.add("SAMPLING_PARAMETER_UNIT");
        g_allowedElements.add("SCALING_FACTOR");
        g_allowedElements.add("UNIT");
        g_allowedElements.add("VALID_MAXIMUM");
        g_allowedElements.add("VALID_MINIMUM");
        g_allowedObjects.add(PdsBitColumn.class);
        g_allowedObjects.add(PdsAlias.class);
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsContainer || parent instanceof PdsTable) {
                return new PdsColumn("COLUMN", (PdsDataObj)parent);
            }
            throw new PDSException("The parent of a COLUMN object must be a type of TABLE or CONTAINER not a " + parent.getType());
        }
    }
}

