/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws_hr.HROptionsPanel;
import edu.uiowa.physics.pw.apps.vgpws_hr.HighRateSlicer;
import edu.uiowa.physics.pw.apps.vgpws_hr.IndexTool;
import edu.uiowa.physics.pw.apps.vgpws_hr.IndexedDensityFileDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws_hr.LocalFileReaderPanel;
import edu.uiowa.physics.pw.apps.vgpws_hr.MagDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws_hr.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.DasTimeRangeSelector;
import org.das2.components.TearoffTabbedPane;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.DataPointSelectorMouseModule;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Legend;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.graph.TimeRangeLabel;
import org.das2.util.ArgumentList;
import org.das2.util.DasExceptionHandler;
import org.das2.util.FileUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class VoyagerHighRate {
    DasCanvas canvas;
    SpectrogramRenderer renderer;
    SymbolLineRenderer cycloRenderer;
    SymbolLineRenderer indexedRenderer;
    MagDataSetDescriptor fceDsd;
    IndexTool indexTool;
    DasPlot plot;
    HighRateSlicer slicer;
    HROptionsPanel optionsPanel;
    HashMap overlayRenderers = new HashMap();
    HashMap overlayLabels = new HashMap();
    Legend legend;
    LocalFileReaderPanel localReaderPanel;
    boolean localOnly = false;
    DataSetUpdateListener indexListener = new DataSetUpdateListener(){

        public void dataSetUpdated(DataSetUpdateEvent e) {
            VoyagerHighRate.this.updateIndexed();
        }
    };
    float lastHue = -0.07f;
    private boolean addedCycloToLegend = false;

    protected void updateIndexed() {
        VectorDataSet indexDs = this.indexTool.getRecorder().getDataSet();
        String voyString = this.optionsPanel.isVoyager1() ? "1" : "2";
        IndexedDensityFileDataSetDescriptor dsd = new IndexedDensityFileDataSetDescriptor(voyString, DensityFileDataSetDescriptor.FCE_PLANE_TYPE, indexDs);
        this.indexedRenderer.setDataSetDescriptor(dsd);
    }

    VoyagerHighRate(boolean localOnly, JFrame frame) {
        this.localOnly = localOnly;
        CanvasPanel canvasPanel = new CanvasPanel();
        this.optionsPanel = new HROptionsPanel(this);
        this.localReaderPanel = new LocalFileReaderPanel(this);
        TearoffTabbedPane pane = new TearoffTabbedPane();
        pane.setOpaque(true);
        pane.addTab("plot", canvasPanel.getPanel());
        if (!localOnly) {
            pane.addTab("options", this.optionsPanel);
        }
        pane.addTab("local", this.localReaderPanel);
        if (frame == null) {
            frame = DasApplication.getDefaultApplication().createMainFrame("Voyager High Rate", pane);
        } else {
            frame.getContentPane().add(pane);
        }
        if (!localOnly) {
            this.indexTool = new IndexTool(this.plot, frame);
            pane.addTab("index", this.indexTool.getRecorder());
            this.indexTool.getRecorder().addDataSetUpdateListener(this.indexListener);
            this.update();
        } else {
            this.localReaderPanel.setUseLocal(true);
            this.renderer.setDataSetLoader(this.localReaderPanel.loader);
        }
    }

    protected void update() {
        try {
            this.renderer.setDataSetID(this.optionsPanel.getSpectrogramDataSetID());
            String dsdClass = "class:edu.uiowa.physics.pw.apps.vgpws.DensityFileDataSetDescriptor";
            if (this.optionsPanel.isVoyager1()) {
                this.plot.setTitle("Voyager 1 Wideband");
            } else {
                this.plot.setTitle("Voyager 2 Wideband");
            }
            this.fceDsd = new MagDataSetDescriptor(this.optionsPanel.isVoyager1() ? Spacecraft.voyager1 : Spacecraft.voyager2, true);
            this.cycloRenderer.setDataSetDescriptor(this.fceDsd);
        }
        catch (DasException e) {
            DasExceptionHandler.handle(e);
        }
        catch (FileSystem.FileSystemOfflineException e) {
            DasExceptionHandler.handle(e);
        }
    }

    Color getNextNonColorbarColor() {
        this.lastHue += 0.07f;
        return Color.getHSBColor(this.lastHue, 0.8f, 0.8f);
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                Runnable run = new Runnable(){

                    public void run() {
                        VoyagerHighRate.this.update();
                    }
                };
                new Thread(run).start();
            }
        };
    }

    protected void setLocalFile(final File[] files) {
        this.renderer.setActive(true);
        if (this.renderer.getDataLoader() != this.localReaderPanel.loader) {
            this.renderer.setDataSetLoader(this.localReaderPanel.loader);
        }
        Runnable run = new Runnable(){

            public void run() {
                ProgressMonitor monitor = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(VoyagerHighRate.this.renderer.getParent(), "Loading data set", "high rate dataloader");
                try {
                    TableDataSet tds = VoyagerHighRate.this.localReaderPanel.loader.loadFiles(files, monitor);
                    VoyagerHighRate.this.renderer.setDataSet(tds);
                    VoyagerHighRate.this.renderer.getParent().getXAxis().setDatumRange(DataSetUtil.xRange(tds));
                    VoyagerHighRate.this.updateLocalFileSC();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    DasExceptionHandler.handle(ex);
                }
            }
        };
        new Thread(run, "load datafile").start();
    }

    private void updateLocalFileSC() {
        if (this.localReaderPanel.loader.getFiles() == null) {
            return;
        }
        int sc = this.localReaderPanel.loader.getVoyagerSpacecraftNum();
        if (sc == 1) {
            this.plot.setTitle("Voyager 1 Wideband");
        } else {
            this.plot.setTitle("Voyager 2 Wideband");
        }
    }

    protected void setUseLocal(boolean useLocal) {
        if (useLocal) {
            this.renderer.setActive(true);
            this.renderer.setDataSetLoader(this.localReaderPanel.loader);
            this.updateLocalFileSC();
        }
    }

    public DasPlot getPlot() {
        return this.plot;
    }

    public static void main(String[] args) {
        ArgumentList alm = new ArgumentList("voyagerHighrate");
        alm.addBooleanSwitchArgument("localOnly", "lo", "localOnly", "don't provide server option");
        alm.process(args);
        File cache = FileSystem.settings().getLocalCacheDir().getAbsoluteFile();
        FileUtil.deleteFileTree(cache);
        boolean localOnly = alm.getBooleanValue("localOnly");
        new VoyagerHighRate(localOnly, null);
    }

    class CanvasPanel {
        JPanel panel;

        JPanel getPanel() {
            return this.panel;
        }

        CanvasPanel() {
            VoyagerHighRate.this.canvas = new DasCanvas(800, 600);
            DasRow row = new DasRow(VoyagerHighRate.this.canvas, null, 0.0, 1.0, 4.0, -4.0, 0, 0);
            DasColumn column = new DasColumn(VoyagerHighRate.this.canvas, null, 0.0, 1.0, 5.0, -8.0, 0, 0);
            DatumRange timeRange = DatumRangeUtil.parseTimeRangeValid("1979-060 12:25:50 to 1979-060 12:28:00");
            DatumRange freqRange = new DatumRange(0.04, 12.0, Units.kiloHertz);
            DatumRange ampRange = new DatumRange(1.0E-5, 0.1, Units.dimensionless);
            VoyagerHighRate.this.plot = DasPlot.createPlot(timeRange, freqRange);
            VoyagerHighRate.this.plot.getYAxis().setLabel("frequency (kHz)");
            VoyagerHighRate.this.canvas.add(VoyagerHighRate.this.plot, row, column);
            DasColorBar colorbar = new DasColorBar(ampRange.min(), ampRange.max(), true);
            colorbar.setLabel("relative power spectral density");
            VoyagerHighRate.this.renderer = new SpectrogramRenderer(null, colorbar);
            VoyagerHighRate.this.renderer.setActive(false);
            VoyagerHighRate.this.plot.addRenderer(VoyagerHighRate.this.renderer);
            try {
                VoyagerHighRate.this.fceDsd = new MagDataSetDescriptor(Spacecraft.voyager1, true);
            }
            catch (FileSystem.FileSystemOfflineException ex) {
                DasExceptionHandler.handle(ex);
            }
            VoyagerHighRate.this.cycloRenderer = new SymbolLineRenderer();
            VoyagerHighRate.this.cycloRenderer.setDataSetDescriptor(VoyagerHighRate.this.fceDsd);
            VoyagerHighRate.this.cycloRenderer.setActive(false);
            VoyagerHighRate.this.indexedRenderer = new SymbolLineRenderer();
            VoyagerHighRate.this.indexedRenderer.setColor(Color.LIGHT_GRAY);
            VoyagerHighRate.this.indexedRenderer.setSymSize(1.0);
            VoyagerHighRate.this.indexedRenderer.setActive(false);
            VoyagerHighRate.this.plot.addRenderer(VoyagerHighRate.this.renderer);
            VoyagerHighRate.this.plot.addRenderer(VoyagerHighRate.this.cycloRenderer);
            VoyagerHighRate.this.plot.addRenderer(VoyagerHighRate.this.indexedRenderer);
            VoyagerHighRate.this.legend = new Legend();
            VoyagerHighRate.this.canvas.add(VoyagerHighRate.this.legend, row.createAttachedRow(0.02, 0.3), column.createAttachedColumn(0.82, 0.99));
            VoyagerHighRate.this.slicer = new HighRateSlicer(VoyagerHighRate.this.plot);
            DataPointSelectorMouseModule waveformSlicer = new DataPointSelectorMouseModule(VoyagerHighRate.this.plot, VoyagerHighRate.this.renderer, new VerticalSliceSelectionRenderer(VoyagerHighRate.this.plot), "waveform");
            waveformSlicer.addDataPointSelectionListener(VoyagerHighRate.this.slicer);
            VoyagerHighRate.this.plot.addMouseModule(waveformSlicer);
            if (VoyagerHighRate.this.localOnly) {
                VoyagerHighRate.this.renderer.setException(new Exception("(Use local tab to select data files)"));
                VoyagerHighRate.this.renderer.setActive(true);
                VoyagerHighRate.this.plot.getMouseAdapter().setPrimaryModule(waveformSlicer);
            }
            VoyagerHighRate.this.canvas.add(new TimeRangeLabel(VoyagerHighRate.this.plot.getXAxis().getDataRange()), row, column);
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)VoyagerHighRate.this.canvas, "Center");
            if (!VoyagerHighRate.this.localOnly) {
                DasTimeRangeSelector tsel = new DasTimeRangeSelector(timeRange);
                this.panel.add((Component)tsel, "South");
                tsel.addTimeRangeSelectionListener(VoyagerHighRate.this.plot.getXAxis());
                VoyagerHighRate.this.plot.getXAxis().addTimeRangeSelectionListener(tsel);
            }
        }
    }
}

