/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileDataSetDescriptor;
import edu.uiowa.physics.pw.pds.PdsField;
import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.PdsIndexTable;
import edu.uiowa.physics.pw.pds.PdsProduct;
import edu.uiowa.physics.pw.pds.PdsSpreadsheet;
import edu.uiowa.physics.pw.pds.PdsVolume;
import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.search.PdsRowList;
import edu.uiowa.physics.pw.pds.search.PdsTblSearcher;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.das2.CancelledOperationException;
import org.das2.DasException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.util.TimeParser;
import org.das2.util.monitor.ProgressMonitor;
import pds.label.PDSException;
import pds.util.PPITime;

public class VgDensDataDSD
extends DataSetDescriptor {
    protected String m_sPdsDataSet;
    protected PdsVolume g_vol;
    protected TimeParser m_tpDOY_US2K = TimeParser.create("%Y-%jT%H:%M:%S.%{milli}");
    protected TimeDatumFormatter m_tfUS2K_DOY;
    protected PdsRowList m_rlDataSet;
    private String column;

    public VgDensDataDSD(PdsVolume vol, int nVgr, DensityFileDataSetDescriptor.PlaneType plane) throws DasException, PDSException {
        super("class://vgdenspltr.VgDensDataDSD?root=" + vol.getRootStr() + "&data_set_id=" + "VG" + nVgr + "-J-PWS-5-DDR-PLASMA-DENSITY-1S-V1.0");
        try {
            this.m_tfUS2K_DOY = new TimeDatumFormatter("%Y-%jT%H:%M:%S.%{milli}");
        }
        catch (ParseException ex) {
            throw new DasException(ex);
        }
        if (nVgr < 1 || nVgr > 2) {
            throw new IllegalArgumentException("nVgr must be 1 or 2");
        }
        this.m_sPdsDataSet = "VG" + nVgr + "-J-PWS-5-DDR-PLASMA-DENSITY-1S-V1.0";
        this.g_vol = vol;
        try {
            this.m_rlDataSet = this.g_vol.getIndexTable().getSearcher().findEq("DATA_SET_ID", this.m_sPdsDataSet);
        }
        catch (IOException ex) {
            throw new DasException(ex);
        }
        if (plane == DensityFileDataSetDescriptor.FCE_PLANE_TYPE) {
            this.column = "FCE";
        } else if (plane == DensityFileDataSetDescriptor.FL_PLANE_TYPE) {
            this.column = "L_FREQ";
        } else if (plane == DensityFileDataSetDescriptor.FR_PLANE_TYPE) {
            this.column = "R_FREQ";
        } else if (plane == DensityFileDataSetDescriptor.FPE_PLANE_TYPE) {
            this.column = "PLASMA_FREQ";
        } else if (plane == DensityFileDataSetDescriptor.FUH_PLANE_TYPE) {
            this.column = "UH_FREQ";
        }
    }

    public int getVgr() {
        if (this.m_sPdsDataSet.startsWith("VG1")) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        String sStart = this.m_tfUS2K_DOY.format(start, Units.us2000);
        String sEnd = this.m_tfUS2K_DOY.format(end, Units.us2000);
        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.us2000, Units.hertz);
        if (monitor.isCancelled()) {
            throw new CancelledOperationException();
        }
        monitor.setLabel("Loading Data");
        if (monitor.isCancelled()) {
            throw new CancelledOperationException();
        }
        monitor.setProgressMessage("Finding Products");
        if (monitor.isCancelled()) {
            throw new CancelledOperationException();
        }
        monitor.started();
        try {
            PPITime tStart = new PPITime();
            if (!tStart.convert("T", sStart)) {
                throw new IllegalArgumentException("Could not convert " + sStart + " to a timestamp.");
            }
            PPITime tEnd = new PPITime();
            if (!tEnd.convert("T", sEnd)) {
                throw new IllegalArgumentException("Could not convert " + sEnd + " to a timestamp.");
            }
            PdsIndexTable idx = this.g_vol.getIndexTable();
            List<String> prodAry = null;
            PdsIndexTable pdsIndexTable = idx;
            synchronized (pdsIndexTable) {
                PdsTblSearcher searcher = idx.getSearcher();
                PdsRowList rl = searcher.findGtEq("START_TIME", tStart).AND(searcher.findLt("START_TIME", tEnd));
                PdsRowList rlNext = searcher.findGt("STOP_TIME", tStart).AND(searcher.findLtEq("STOP_TIME", tEnd));
                rl.OR(rlNext);
                rlNext = searcher.findLt("START_TIME", tStart).AND(searcher.findGtEq("STOP_TIME", tEnd));
                rl.OR(rlNext);
                rl.AND(this.m_rlDataSet);
                prodAry = idx.getProducts(rl);
            }
            if (prodAry.isEmpty()) {
                throw new NoDataInIntervalException("");
            }
            if (monitor.isCancelled()) {
                throw new CancelledOperationException();
            }
            monitor.setTaskSize(prodAry.size() * 100);
            int iSheet = -1;
            block9: for (String sRelPath : prodAry) {
                monitor.setProgressMessage("Reading " + sRelPath);
                ++iSheet;
                if (monitor.isCancelled()) {
                    throw new CancelledOperationException();
                }
                monitor.setTaskProgress(iSheet * 100);
                PdsProduct prod = this.g_vol.getProduct(sRelPath);
                PdsFile file = prod.getFile();
                PdsSpreadsheet sheet = file.subSpreadsheet("DENSITY");
                PdsField fldDate = sheet.subField("SCET");
                PdsField fldDens = sheet.subField(this.column);
                int nRowFrac = 100 / sheet.size();
                for (int i = 0; i < sheet.size(); ++i) {
                    sheet.setRow(i);
                    String sDate = fldDate.getString();
                    if (sDate.compareTo(sEnd) > 0) continue block9;
                    if (sDate.compareTo(sStart) >= 0 && fldDens.getItemSize() > 0) {
                        double dDens = fldDens.doubleVal();
                        double dTime = this.m_tpDOY_US2K.parse(sDate).getTime(Units.us2000);
                        Units.us2000.createDatum(dTime);
                        builder.insertY(dTime, dDens);
                    }
                    if (monitor.isCancelled()) {
                        throw new CancelledOperationException();
                    }
                    monitor.setTaskProgress(iSheet * 100 + (i + 1) * nRowFrac);
                }
            }
        }
        catch (PDSException ex) {
            throw new DasException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new DasException(ex);
        }
        catch (IOException ex) {
            throw new DasException(ex);
        }
        catch (ParseException pe) {
            throw new DasException(pe);
        }
        catch (PdsRangeException ex) {
            throw new DasException(ex);
        }
        builder.setProperty("cacheTag", new CacheTag(start, end, null));
        builder.setProperty("xTagWidth", Units.seconds.createDatum(20));
        if (monitor.isCancelled()) {
            throw new CancelledOperationException();
        }
        monitor.finished();
        return builder.toVectorDataSet();
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public void requestDataSet(Datum start, Datum end, Datum resolution, ProgressMonitor monitor, Object lockObject) {
        super.requestDataSet(start, end, resolution, monitor, lockObject);
    }
}

