/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.HighRateFilesDataLoader;
import edu.uiowa.physics.pw.apps.vgpws_hr.VoyagerHighRate;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class LocalFileReaderPanel
extends JPanel {
    VoyagerHighRate app;
    HighRateFilesDataLoader loader;
    private JComboBox datasetSelect;
    private JButton jButton1;
    private JLabel jLabel1;
    private JButton updateButton;
    private JCheckBox useLocalCB;

    public LocalFileReaderPanel(VoyagerHighRate app) {
        this.app = app;
        this.initComponents();
        this.loader = new HighRateFilesDataLoader(app.renderer);
    }

    private void initComponents() {
        this.useLocalCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.datasetSelect = new JComboBox();
        this.jButton1 = new JButton();
        this.updateButton = new JButton();
        this.useLocalCB.setText("Use local reader");
        this.useLocalCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useLocalCB.setMargin(new Insets(0, 0, 0, 0));
        this.useLocalCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalFileReaderPanel.this.useLocalCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("High Rate Spectrogram Options:");
        this.datasetSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"-fft3x512av", "-fft3x512", "-fft1600"}));
        this.datasetSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalFileReaderPanel.this.datasetSelectActionPerformed(evt);
            }
        });
        this.jButton1.setText("Choose files...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalFileReaderPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.updateButton.setText("Load Data");
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalFileReaderPanel.this.updateButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(10, 10, 10).add(this.datasetSelect, -2, -1, -2)).add(this.jButton1).add(this.useLocalCB).add(this.jLabel1).add(this.updateButton)).addContainerGap(235, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.useLocalCB).addPreferredGap(0).add(this.jButton1).addPreferredGap(0).add(this.jLabel1).addPreferredGap(0).add(this.datasetSelect, -2, -1, -2).addPreferredGap(0).add(this.updateButton).addContainerGap(168, Short.MAX_VALUE)));
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.loader.doLoad();
    }

    private void datasetSelectActionPerformed(ActionEvent evt) {
        HighRateFilesDataLoader.FftAvg[] mm = new HighRateFilesDataLoader.FftAvg[]{HighRateFilesDataLoader.FftAvg.fft512x3av, HighRateFilesDataLoader.FftAvg.fft512x3, HighRateFilesDataLoader.FftAvg.fft1600};
        this.loader.setFftMethod(mm[this.datasetSelect.getSelectedIndex()]);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.useLocalCB.setSelected(true);
        this.useLocalCB.setEnabled(false);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String currentDirectoryPath = prefs.get("loadRoot", new File("").getAbsolutePath().toString());
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".DAT");
            }

            public String getDescription() {
                return "*.DAT";
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            prefs.put("loadRoot", chooser.getCurrentDirectory().toString());
            File[] files = chooser.getSelectedFiles();
            this.loader.setFiles(files);
            this.app.setUseLocal(true);
        }
    }

    private void useLocalCBActionPerformed(ActionEvent evt) {
        if (this.useLocalCB.isSelected()) {
            this.useLocalCB.setEnabled(false);
            this.app.setUseLocal(true);
        }
    }

    void setUseLocal(boolean b) {
        if (!b) {
            throw new IllegalArgumentException("only true supported--sorry");
        }
        this.useLocalCB.setSelected(true);
        this.useLocalCB.setEnabled(false);
    }
}

