/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.HighRateFilesDataLoader;
import edu.uiowa.physics.pw.apps.vgpws_hr.HighRateReader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.das2.DasException;
import org.das2.client.StreamDataSetDescriptor;
import org.das2.client.WebStandardDataStreamSource;
import org.das2.components.ComponentsUtil;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DataLoader;
import org.das2.graph.SymbolLineRenderer;
import org.das2.graph.XAxisDataLoader;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;

public class HighRateSlicer
implements DataPointSelectionListener {
    SymbolLineRenderer waveformRenderer;
    SymbolLineRenderer fftRenderer;
    DasPlot parentPlot;
    DasPlot plot1;
    JDialog popup = null;
    boolean popupLoaded = false;
    DasAxis xaxis;
    DataLoader parentLoader;
    Strategy strategy;
    int currentRecordIndex = 0;

    HighRateSlicer(DasPlot parent) {
        this.parentPlot = parent;
    }

    public DasPlot createPlot() {
        DatumRange xdr = new DatumRange(0.0, 60.0, Units.milliseconds);
        DatumRange ydr = new DatumRange(-8.0, 8.0, Units.dimensionless);
        this.xaxis = new DasAxis(xdr, 2){

            public void scanPrevious() {
                HighRateSlicer.this.strategy.previousRecord();
            }

            public void scanNext() {
                HighRateSlicer.this.strategy.nextRecord();
            }
        };
        DasAxis yaxis = new DasAxis(ydr, 3);
        this.plot1 = new DasPlot(this.xaxis, yaxis);
        this.xaxis = this.plot1.getXAxis();
        this.xaxis.setAnimated(false);
        this.plot1.getYAxis().setLabel("4 bit waveform");
        this.waveformRenderer = new SymbolLineRenderer();
        this.waveformRenderer.setLineWidth(1.0f);
        this.waveformRenderer.setException(new Exception("(Click on the spectrogram for waveform)"));
        this.plot1.addRenderer(this.waveformRenderer);
        return this.plot1;
    }

    private void createPopup() {
        DasCanvas canvas = ComponentsUtil.createPopupCanvas(this.parentPlot, "Waveform Slicer", 800, 200);
        this.popup = (JDialog)SwingUtilities.getWindowAncestor(canvas);
        DasRow row1 = new DasRow(canvas, null, 0.0, 1.0, 3.0, -3.0, 0, 0);
        this.createPlot();
        DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 6.0, -3.0, 0, 0);
        canvas.add(this.plot1, row1, col);
        this.popupLoaded = true;
    }

    private void showPopup() {
        if (this.popupLoaded) {
            return;
        }
        if (this.popup == null) {
            this.createPopup();
        }
        this.popup.setVisible(true);
    }

    public void setDisplayer(DasCanvas canvas) {
        this.popupLoaded = true;
    }

    private boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    public void dataPointSelected(DataPointSelectionEvent e) {
        DataLoader loader = this.parentPlot.getRenderer(0).getDataLoader();
        if (loader != this.parentLoader) {
            if (loader instanceof HighRateFilesDataLoader) {
                this.strategy = new LocalHRFileStrategy((HighRateFilesDataLoader)loader);
            } else if (loader instanceof XAxisDataLoader) {
                XAxisDataLoader xloader = (XAxisDataLoader)loader;
                this.strategy = new Das2ServerStrategy(xloader);
            }
            this.parentLoader = loader;
        }
        this.showPopup();
        this.strategy.getWaveDataSet(e.getX());
        this.strategy.describeDataSet();
    }

    void setLoader(HighRateFilesDataLoader loader) {
    }

    class LocalHRFileStrategy
    implements Strategy {
        File file = null;
        DatumRange fileTimeRange = null;
        HighRateReader reader = null;
        int line;
        int currentRecordIndex;
        HighRateFilesDataLoader hrLoader;

        LocalHRFileStrategy(HighRateFilesDataLoader hrLoader) {
            this.hrLoader = hrLoader;
        }

        private void updateFile(Datum time) {
            try {
                File file = this.hrLoader.getFileContaining(time);
                if (file == null) {
                    this.reader = null;
                    this.fileTimeRange = null;
                } else {
                    this.fileTimeRange = this.hrLoader.getRangeForFile(file);
                    this.reader = new HighRateReader(file);
                }
            }
            catch (IOException ex) {
                DasExceptionHandler.handle(ex);
            }
        }

        public void getWaveDataSet(Datum time) {
            int line;
            if (this.reader == null || !this.fileTimeRange.contains(time)) {
                this.updateFile(time);
            }
            if (this.reader == null) {
                return;
            }
            this.currentRecordIndex = line = this.reader.getLineContainingTime(time.add(Units.milliseconds.createDatum(30)));
            VectorDataSet lineDs = this.reader.readRecord(line);
            HighRateSlicer.this.waveformRenderer.setDataSet(lineDs);
        }

        public void describeDataSet() {
            if (this.reader == null) {
                HighRateSlicer.this.plot1.setTitle("reader is null, switch frames");
                return;
            }
            DecimalFormat df = new DecimalFormat("000");
            HighRateSlicer.this.plot1.setTitle(" " + this.reader.getFileTitle() + ":" + df.format(this.reader.getLineCounter(this.currentRecordIndex)) + " waveform");
        }

        public void nextRecord() {
            ++this.currentRecordIndex;
            if (this.currentRecordIndex == this.reader.recordCount()) {
                this.currentRecordIndex = this.reader.recordCount() - 1;
            }
            VectorDataSet vds = this.reader.readRecord(this.currentRecordIndex);
            HighRateSlicer.this.waveformRenderer.setDataSet(vds);
            this.describeDataSet();
        }

        public void previousRecord() {
            --this.currentRecordIndex;
            if (this.currentRecordIndex == -1) {
                this.currentRecordIndex = 0;
            }
            VectorDataSet vds = this.reader.readRecord(this.currentRecordIndex);
            HighRateSlicer.this.waveformRenderer.setDataSet(vds);
            this.describeDataSet();
        }
    }

    class Das2ServerStrategy
    implements Strategy {
        StreamDataSetDescriptor waveDsd = null;
        TableDataSet waveTable = null;
        Exception loadException = null;
        DatumRange loadedRange = null;
        DataSetUpdateListener listener;
        Datum pendingTime = null;
        int currentRecordIndex;
        String parentDsId;

        Das2ServerStrategy(XAxisDataLoader loader) {
            this.parentDsId = loader.getDataSetDescriptor().getDataSetID();
            this.resetDataSetDescriptor();
        }

        private void resetDataSetDescriptor() {
            int i = this.parentDsId.indexOf("pws/wf-");
            String waveId = this.parentDsId.substring(0, i + "pws/wf-".length()) + "waveform2";
            try {
                this.waveDsd = (StreamDataSetDescriptor)DataSetDescriptor.create(waveId);
                ((WebStandardDataStreamSource)this.waveDsd.getStandardDataStreamSource()).setCompress(true);
                ((WebStandardDataStreamSource)this.waveDsd.getStandardDataStreamSource()).setDevel("jbf");
            }
            catch (DasException ex) {
                throw new RuntimeException(ex);
            }
        }

        public synchronized void getWaveDataSet(Datum time) {
            if (this.parentDsId != ((XAxisDataLoader)HighRateSlicer.this.parentLoader).getDataSetDescriptor().getDataSetID()) {
                this.parentDsId = ((XAxisDataLoader)HighRateSlicer.this.parentLoader).getDataSetDescriptor().getDataSetID();
                this.resetDataSetDescriptor();
            }
            if (this.loadedRange == null || !this.loadedRange.contains(time) && !this.loadedRange.max().equals(time)) {
                this.waveTable = null;
                if (this.pendingTime != null) {
                    this.pendingTime = time;
                    return;
                }
                this.listener = new DataSetUpdateListener(){

                    public void dataSetUpdated(DataSetUpdateEvent e) {
                        Das2ServerStrategy.this.waveTable = (TableDataSet)e.getDataSet();
                        if (Das2ServerStrategy.this.waveTable == null) {
                            Das2ServerStrategy.this.loadException = e.getException();
                            Das2ServerStrategy.this.pendingTime = null;
                            HighRateSlicer.this.waveformRenderer.setException(Das2ServerStrategy.this.loadException);
                            HighRateSlicer.this.waveformRenderer.setDataSet(null);
                        } else {
                            Das2ServerStrategy.this.loadedRange = DataSetUtil.xRange(Das2ServerStrategy.this.waveTable);
                            Das2ServerStrategy.this.loadedRange.include(Das2ServerStrategy.this.pendingTime);
                            Das2ServerStrategy.this.getWaveDataSet(Das2ServerStrategy.this.pendingTime);
                            Das2ServerStrategy.this.describeDataSet();
                            Das2ServerStrategy.this.pendingTime = null;
                        }
                    }
                };
                this.pendingTime = time;
                DatumRange range = new DatumRange(time, time.add(1.0, Units.milliseconds));
                ProgressMonitor mon = HighRateSlicer.this.plot1.getCanvas().getApplication().getMonitorFactory().getMonitor(HighRateSlicer.this.plot1, "loading waveform data", "loading waveform data " + range);
                this.waveDsd.requestDataSet(range.min(), range.max(), null, mon, HighRateSlicer.this.plot1.getCanvas(), this.listener);
                return;
            }
            if (this.waveTable != null) {
                int i;
                this.currentRecordIndex = i = DataSetUtil.closestColumn(this.waveTable, time);
                VectorDataSet vds = this.waveTable.getXSlice(i);
                HighRateSlicer.this.waveformRenderer.setDataSet(vds);
            } else {
                HighRateSlicer.this.waveformRenderer.setException(this.loadException);
                HighRateSlicer.this.waveformRenderer.setDataSet(null);
            }
        }

        public void describeDataSet() {
            if (this.waveTable == null) {
                HighRateSlicer.this.plot1.setTitle("loading");
            } else {
                Datum time = TimeUtil.createValid((String)this.waveTable.getProperty("scet"));
                Datum offset = this.waveTable.getXTagDatum(this.currentRecordIndex).subtract(time);
                int line = (int)Math.round(offset.doubleValue(Units.milliseconds) / 60.0);
                DecimalFormat df = new DecimalFormat("000");
                String d = "das2Server: " + this.waveTable.getProperty("spacecraft") + " " + this.waveTable.getProperty("instrument_id") + " " + this.waveTable.getProperty("sclk") + ":" + df.format(line) + " waveform" + "!c" + this.waveTable.getXTagDatum(this.currentRecordIndex);
                HighRateSlicer.this.plot1.setTitle(d);
            }
        }

        public void nextRecord() {
            ++this.currentRecordIndex;
            if (this.currentRecordIndex == this.waveTable.getXLength()) {
                this.currentRecordIndex = this.waveTable.getXLength() - 1;
            }
            VectorDataSet vds = this.waveTable.getXSlice(this.currentRecordIndex);
            HighRateSlicer.this.waveformRenderer.setDataSet(vds);
            this.describeDataSet();
        }

        public void previousRecord() {
            --this.currentRecordIndex;
            if (this.currentRecordIndex == -1) {
                this.currentRecordIndex = 0;
            }
            VectorDataSet vds = this.waveTable.getXSlice(this.currentRecordIndex);
            HighRateSlicer.this.waveformRenderer.setDataSet(vds);
            this.describeDataSet();
        }
    }

    static interface Strategy {
        public void getWaveDataSet(Datum var1);

        public void describeDataSet();

        public void nextRecord();

        public void previousRecord();
    }
}

