/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.HighRateReader;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dataset.ClippedVectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.graph.DataLoader;
import org.das2.graph.Renderer;
import org.das2.math.fft.FFTUtil;
import org.das2.math.fft.GeneralFFT;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;

public class HighRateFilesDataLoader
extends DataLoader {
    static Logger logger = DasLogger.getLogger();
    File[] files;
    DatumRange[] fileRanges;
    FftAvg fftAvg = FftAvg.fft512x3av;

    public void setFftMethod(FftAvg fftAvg) {
        this.fftAvg = fftAvg;
    }

    public FftAvg getFftMethod() {
        return this.fftAvg;
    }

    public HighRateFilesDataLoader(Renderer r) {
        super(r);
    }

    public void update() {
    }

    public void doLoad() {
        if (this.files == null) {
            return;
        }
        Runnable run = new Runnable(){

            public void run() {
                try {
                    TableDataSet tds = HighRateFilesDataLoader.this.loadFiles(HighRateFilesDataLoader.this.files, HighRateFilesDataLoader.this.getMonitor("reading high rate data"));
                    HighRateFilesDataLoader.this.getRenderer().setDataSet(tds);
                    HighRateFilesDataLoader.this.getRenderer().getParent().getXAxis().setDatumRange(DataSetUtil.xRange(tds));
                }
                catch (IOException ex) {
                    DasExceptionHandler.handle(ex);
                }
            }
        };
        new Thread(run, "loadHighRateFiles").start();
    }

    private static DatumVector getXTags(DataSet ds) {
        Units u = ds.getXUnits();
        double[] d = new double[ds.getXLength()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ds.getXTagDouble(i, u);
        }
        return DatumVector.newDatumVector(d, u);
    }

    private static DatumVector getYValues(VectorDataSet ds) {
        Units u = ds.getYUnits();
        double[] d = new double[ds.getXLength()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ds.getDouble(i, u);
        }
        return DatumVector.newDatumVector(d, u);
    }

    public TableDataSet loadFiles(File[] files, ProgressMonitor mon) throws IOException {
        Datum xTagWidth = Units.milliseconds.createDatum(60);
        DatumRange[] fileRanges_ = new DatumRange[files.length];
        TableDataSetBuilder builder = new TableDataSetBuilder(Units.us2000, Units.kiloHertz, Units.dimensionless);
        builder.setProperty("xTagWidth", xTagWidth);
        Object ytags = null;
        mon.setTaskSize(files.length * 800);
        mon.started();
        for (int i = 0; i < files.length; ++i) {
            HighRateReader reader = new HighRateReader(files[i]);
            Datum min = null;
            Datum max = null;
            for (int j = 0; j < reader.recordCount(); ++j) {
                VectorDataSet ds = reader.readRecord(j);
                if (j == 0) {
                    min = (Datum)ds.getProperty("baseTime");
                } else if (j == reader.recordCount() - 1) {
                    max = ((Datum)ds.getProperty("baseTime")).add(xTagWidth);
                }
                boolean nonZero = ds.getDouble(0, Units.dimensionless) > 0.0;
                for (int k = 0; !nonZero && k < 1600; ++k) {
                    if (!(ds.getDouble(k, Units.dimensionless) > 0.0)) continue;
                    nonZero = true;
                }
                if (nonZero) {
                    this.fftAvg.doFftAvg(ds, builder);
                }
                mon.setTaskProgress(i * 800 + j);
                Thread.currentThread();
                Thread.yield();
                if (mon.isCancelled()) break;
            }
            fileRanges_[i] = new DatumRange(min, max);
        }
        mon.finished();
        TableDataSet spectrum = builder.toTableDataSet();
        logger.info("loaded " + DataSetUtil.xRange(spectrum));
        this.fileRanges = fileRanges_;
        this.files = files;
        return spectrum;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public File getFileContaining(Datum time) {
        if (this.fileRanges == null) {
            return null;
        }
        File result = null;
        for (int i = 0; i < this.fileRanges.length; ++i) {
            if (!this.fileRanges[i].contains(time)) continue;
            result = this.files[i];
            break;
        }
        return result;
    }

    public DatumRange getRangeForFile(File file) {
        if (this.fileRanges == null) {
            return null;
        }
        DatumRange result = null;
        for (int i = 0; i < this.fileRanges.length; ++i) {
            if (!this.files[i].equals(file)) continue;
            result = this.fileRanges[i];
            break;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        long t0 = System.currentTimeMillis();
        HighRateFilesDataLoader loader = new HighRateFilesDataLoader(null);
        File[] f = new File[]{new File("B:/voyager/web/data/VGPW_2005/DATA/WFRM/P2/V20503/C4407635.DAT")};
        TableDataSet tds = loader.loadFiles(f, DasProgressPanel.createFramed("reading high rate files"));
        System.err.println(tds);
        System.err.println(DataSetUtil.xRange(tds));
        System.err.println("load took " + (System.currentTimeMillis() - t0) + " millis");
    }

    int getVoyagerSpacecraftNum() {
        String f = this.files[0].toString();
        String snum = "" + f.charAt(f.length() - 18);
        return Integer.parseInt(snum);
    }

    protected File[] getFiles() {
        return this.files;
    }

    static final class Fft1600
    extends FftAvg {
        Fft1600() {
            this.fft = new GeneralFFT(1600, true, true);
            this.weights = FFTUtil.getWindow10PercentEdgeCosine(1600);
        }

        public void doFftAvg(VectorDataSet ds, TableDataSetBuilder builder) {
            VectorDataSet powDs = FFTUtil.fftPower(this.fft, ds, this.weights);
            if (this.ytags == null) {
                this.ytags = HighRateFilesDataLoader.getXTags(powDs);
            }
            builder.insertYScan(ds.getXTagDatum(0), this.ytags, HighRateFilesDataLoader.getYValues(powDs));
        }

        String getListLabel() {
            return "FFT 1600";
        }
    }

    static final class Fft512x3av
    extends FftAvg {
        double[] s;

        Fft512x3av() {
            this.fft = new GeneralFFT(512, true, true);
            this.weights = FFTUtil.getWindow10PercentEdgeCosine(512);
            this.s = new double[256];
        }

        public void doFftAvg(VectorDataSet ds, TableDataSetBuilder builder) {
            int ii = 64;
            for (int i = 0; i < 256; ++i) {
                this.s[0] = 0.0;
            }
            VectorDataSet powDs1 = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii, 512), this.weights);
            VectorDataSet powDs2 = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii += 512, 512), this.weights);
            VectorDataSet powDs3 = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii += 512, 512), this.weights);
            if (this.ytags == null) {
                this.ytags = HighRateFilesDataLoader.getXTags(powDs1);
            }
            int i = 0;
            while (i < 256) {
                this.s[i] = powDs1.getDouble(i, Units.dimensionless) + powDs2.getDouble(i, Units.dimensionless) + powDs3.getDouble(i, Units.dimensionless);
                int n = i++;
                this.s[n] = this.s[n] / 3.0;
            }
            builder.insertYScan((Datum)ds.getProperty("baseTime"), this.ytags, DatumVector.newDatumVector(this.s, Units.dimensionless));
        }

        String getListLabel() {
            return "FFT 512x3 avg";
        }
    }

    static final class Fft512x3
    extends FftAvg {
        Fft512x3() {
            this.fft = new GeneralFFT(512, true, true);
            this.weights = FFTUtil.getWindow10PercentEdgeCosine(512);
        }

        public void doFftAvg(VectorDataSet ds, TableDataSetBuilder builder) {
            int ii = 64;
            VectorDataSet powDs = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii, 512), this.weights);
            if (this.ytags == null) {
                this.ytags = HighRateFilesDataLoader.getXTags(powDs);
            }
            builder.insertYScan(ds.getXTagDatum(ii), this.ytags, HighRateFilesDataLoader.getYValues(powDs));
            powDs = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii += 512, 512), this.weights);
            builder.insertYScan(ds.getXTagDatum(ii), this.ytags, HighRateFilesDataLoader.getYValues(powDs));
            powDs = FFTUtil.fftPower(this.fft, new ClippedVectorDataSet(ds, ii += 512, 512), this.weights);
            builder.insertYScan(ds.getXTagDatum(ii), this.ytags, HighRateFilesDataLoader.getYValues(powDs));
        }

        String getListLabel() {
            return "FFT 512x3";
        }
    }

    static abstract class FftAvg
    implements Enumeration {
        GeneralFFT fft;
        public static final FftAvg fft512x3 = new Fft512x3();
        public static final FftAvg fft512x3av = new Fft512x3av();
        public static final FftAvg fft1600 = new Fft1600();
        DatumVector ytags;
        VectorDataSet weights;

        FftAvg() {
        }

        abstract void doFftAvg(VectorDataSet var1, TableDataSetBuilder var2);

        abstract String getListLabel();

        public Icon getListIcon() {
            return null;
        }
    }
}

