/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DDCrossHairMouseModule;
import edu.uiowa.physics.pw.apps.vgpws_hr.IndexTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.das2.DasException;
import org.das2.components.DasTimeRangeSelector;
import org.das2.components.DataPointRecorder;
import org.das2.components.TearoffTabbedPane;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.CutoffMouseModule;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;

public class CutoffDigitizerDemo {
    CutoffMouseModule testModule;
    DasCanvas canvas;
    DasPlot plot;
    SpectrogramRenderer renderer;
    DataPointRecorder recorder;
    TearoffTabbedPane tabpane;
    JFrame jframe;
    static final String DATASET = "http://www-pw.physics.uiowa.edu/das/das2Server?/das2_1/cassini/WFRew&1";
    static final DatumRange ZRANGE = new DatumRange(Datum.create(1.0E-14), Datum.create(1.0E-10));
    static final DatumRange YRANGE = new DatumRange(0.0, 5000.0, Units.hertz);
    static final DatumRange XRANGE = DatumRangeUtil.parseTimeRangeValid("2006-12-02T15:00 to 21:00");
    static final Datum XRESOLUTION = Units.milliseconds.createDatum(33000);
    static final Datum CUTOFF_LEVEL = Units.dimensionless.createDatum(-12);
    static final Datum SLOPE_LEVEL = Units.dimensionless.createDatum(0);
    static final boolean LOWCUTOFF = false;

    private void createComponents() throws DasException {
        this.canvas = new DasCanvas(640, 480);
        DasRow row = DasRow.create(this.canvas);
        DasColumn col = DasColumn.create(this.canvas);
        DasAxis xAxis = new DasAxis(XRANGE, 2);
        DasAxis yAxis = new DasAxis(YRANGE, 3);
        this.plot = new DasPlot(xAxis, yAxis);
        this.canvas.add(this.plot, row, col);
        DataSetDescriptor dsd = DataSetDescriptor.create(DATASET);
        DasColorBar colorBar = new DasColorBar(ZRANGE.min(), ZRANGE.max(), true);
        this.canvas.add(colorBar, this.plot.getRow(), DasColorBar.getColorBarColumn(this.plot.getColumn()));
        this.renderer = new SpectrogramRenderer(dsd, colorBar);
        this.renderer.setSliceRebinnedData(false);
        this.renderer.setRebinner(SpectrogramRenderer.RebinnerEnum.nearestNeighbor);
        this.plot.addRenderer(this.renderer);
        final SymbolLineRenderer digitizedRenderer = new SymbolLineRenderer();
        final SymbolLineRenderer selectedRenderer = new SymbolLineRenderer();
        selectedRenderer.setPsymConnector(PsymConnector.NONE);
        selectedRenderer.setPsym(Psym.DOTS);
        selectedRenderer.setSymSize(8.0);
        selectedRenderer.setColor(Color.PINK);
        this.plot.addRenderer(selectedRenderer);
        digitizedRenderer.setColor(Color.white);
        this.plot.addRenderer(digitizedRenderer);
        DDCrossHairMouseModule mm = new DDCrossHairMouseModule(this.plot, this.renderer, this.plot.getXAxis(), this.plot.getYAxis());
        this.plot.getMouseAdapter().addMouseModule(mm);
        this.plot.getMouseAdapter().setPrimaryModule(mm);
        this.plot.getMouseAdapter().setSecondaryModule(this.plot.getMouseAdapter().getModuleByLabel("Zoom X"));
        this.tabpane = new TearoffTabbedPane();
        this.jframe = new JFrame("digitizer");
        Container contentPane = this.jframe.getContentPane();
        JSplitPane pane = new JSplitPane(1);
        pane.add(this.canvas);
        JPanel crPane = new JPanel();
        crPane.setLayout(new BorderLayout());
        this.recorder = new DataPointRecorder();
        crPane.add((Component)this.recorder, "Center");
        DasTimeRangeSelector tr = new DasTimeRangeSelector(xAxis.getDatumRange());
        tr.addTimeRangeSelectionListener(xAxis);
        crPane.add((Component)tr, "South");
        pane.add(crPane);
        this.tabpane.add("Plot", pane);
        contentPane.add(this.tabpane);
        mm.addDataPointSelectionListener(this.recorder);
        this.recorder.addDataSetUpdateListener(new DataSetUpdateListener(){

            public void dataSetUpdated(DataSetUpdateEvent e) {
                digitizedRenderer.setDataSet(CutoffDigitizerDemo.this.recorder.getDataSet());
            }
        });
        this.recorder.addSelectedDataSetUpdateListener(new DataSetUpdateListener(){

            public void dataSetUpdated(DataSetUpdateEvent e) {
                selectedRenderer.setDataSet(CutoffDigitizerDemo.this.recorder.getSelectedDataSet());
            }
        });
        this.jframe.setVisible(true);
        this.jframe.pack();
        this.jframe.setDefaultCloseOperation(3);
    }

    public CutoffDigitizerDemo() throws Exception {
        this.createComponents();
        DasPlot p = this.plot;
        IndexTool indt = new IndexTool(p, this.jframe);
        this.tabpane.add("index", indt.getRecorder());
        this.testModule = new CutoffMouseModule(p, this.renderer);
        this.testModule.setKeyEvents(true);
        this.testModule.setReleaseEvents(false);
        this.testModule.setXResolution(XRESOLUTION);
        this.testModule.setLowCutoff(false);
        this.testModule.setSlopeMin(SLOPE_LEVEL);
        this.testModule.setLevelMin(CUTOFF_LEVEL);
        p.addMouseModule(this.testModule);
        p.getMouseAdapter().setPrimaryModule(this.testModule);
        this.recorder.setXTagWidth(XRESOLUTION);
        this.testModule.addDataSetUpdateListener(this.recorder.getAppendDataSetUpListener());
        VerticalSlicerMouseModule mm = new VerticalSlicerMouseModule(p, this.renderer, p.getXAxis(), p.getYAxis());
        mm.setLabel("cutoff slice");
        DataPointSelectionListener slicer = this.testModule.getSlicer(p, this.renderer);
        mm.addDataPointSelectionListener(slicer);
        p.addMouseModule(mm);
        this.recorder.addDataPointSelectionListener(slicer);
        BoxSelectorMouseModule mm2 = new BoxSelectorMouseModule(p, p.getXAxis(), p.getYAxis(), this.renderer, new BoxRenderer(p, true), "Recorder Select");
        mm2.addBoxSelectionListener(new BoxSelectionListener(){

            public void BoxSelected(BoxSelectionEvent event) {
                CutoffDigitizerDemo.this.recorder.select(event.getXRange(), event.getYRange());
            }
        });
        p.addMouseModule(mm2);
        p.getMouseAdapter().setSecondaryModule(mm2);
        this.plot.getXAxis().addToFavorites(DatumRangeUtil.parseTimeRangeValid("1979-3-1 20:05 to 20:06"));
        this.plot.getXAxis().addToFavorites(DatumRangeUtil.parseTimeRangeValid("1979-3-1 20:06 to 20:07"));
    }

    public static void main(String[] args) throws Exception {
        new CutoffDigitizerDemo();
    }
}

