/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.TimeParser;

public class AsciiColumnFileParser {
    private TimeParser timeParser;
    private List columnList = new ArrayList();
    private int timeStartColumn;
    private int timeEndColumn;
    private int primaryColumn;
    private int columnCount = 0;
    private Map properties = new HashMap();

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void addTimeColumn(TimeParser timeParser, int startColumn, int endColumn) {
        this.timeParser = timeParser;
        this.timeStartColumn = startColumn;
        this.timeEndColumn = endColumn;
    }

    public void addColumn(int startColumn, int endColumn, Units units) {
        this.addColumn("", startColumn, endColumn, units);
    }

    public void addColumn(String planeId, int startColumn, int endColumn, Units units) {
        if (planeId.equals("")) {
            this.primaryColumn = this.columnCount;
        }
        Column column = new Column();
        column.planeId = planeId;
        column.startColumn = startColumn;
        column.endColumn = endColumn;
        column.units = units;
        column.fill = -1.0E31;
        this.columnList.add(column);
        ++this.columnCount;
    }

    private int columnIndex(String planeId) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (!((Column)this.columnList.get((int)i)).planeId.equals(planeId)) continue;
            return i;
        }
        throw new IllegalArgumentException("plane not found");
    }

    public void setColumnFill(String planeId, double fillValue) {
        int i = this.columnIndex(planeId);
        ((Column)this.columnList.get((int)i)).fill = fillValue;
    }

    public VectorDataSetBuilder createDataSetBuilder() {
        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.us2000, ((Column)this.columnList.get((int)this.primaryColumn)).units);
        for (int i = 0; i < this.columnCount; ++i) {
            Column col = (Column)this.columnList.get(i);
            if (i == this.primaryColumn) continue;
            builder.addPlane(col.planeId, col.units);
        }
        return builder;
    }

    public void parseLine(String line, VectorDataSetBuilder builder) throws ParseException {
        this.timeParser.parse(line.substring(this.timeStartColumn, this.timeEndColumn));
        Datum x = this.timeParser.getTimeDatum();
        for (int i = 0; i < this.columnCount; ++i) {
            Column col = (Column)this.columnList.get(i);
            Datum y = col.units.parse(line.substring(col.startColumn, col.endColumn).trim());
            builder.insertY(x, y, col.planeId);
        }
    }

    public DataSet parse(BufferedReader reader) throws IOException, ParseException {
        VectorDataSetBuilder builder = this.createDataSetBuilder();
        int lineNum = 0;
        String line = reader.readLine();
        while (line != null) {
            ++lineNum;
            this.parseLine(line, builder);
            line = reader.readLine();
        }
        builder.addProperties(this.properties);
        return builder.toVectorDataSet();
    }

    class Column {
        String planeId;
        Units units;
        double fill;
        int startColumn;
        int endColumn;

        Column() {
        }
    }
}

