<!-- requires launcher.js -->

function mapClick( part, npart, pngFileName, root ) {
   partString= ""+part+" of "+npart;   
   launchApp( pngFileName, partString, root );
}

function uniqCode( pngFileName ) {
   hash="";
   for ( i=0; i<pngFileName.length; i++ ) {
     if ( pngFileName.charAt(i)>='0' && pngFileName.charAt(i)<='9' ) {
        hash= hash + pngFileName.charAt(i);
     }
   }   
   return hash;
}

<!--  -->
<!--     document is the DOM document object  -->
<!--     pngFile  name is the name of the png to display that will be parsed to get the timerange.  -->
<!--              it must be in the format VG1/1977/T770829_770908.PNG  -->
<!--     root is the root of the cdrom  -->
<!--     pngRoot is the root of the thumbnails  -->
<!--  -->
function makeLauncherMap( document, pngFileName, root, pngRoot ) {
    d= document;

    ulx= 120;
    uly= 29;
    lrx= 819;
    lry= 255;
    ndiv= 10;

    uniq= "foo"+uniqCode(pngFileName);  // this is unique on the page

    d.writeln("  <image name=\"mapImage"+uniq+"\" src=\"\" usemap=\"#"+uniq+"\"/>  ");
    d.writeln("  <script language=\"javascript\">");
    d.writeln("      document.mapImage"+uniq+".src=\""+pngRoot+pngFileName+"\";");
    d.writeln("  </script>");
    d.writeln("     ");
    d.writeln(" ");
    d.writeln("  <map name=\""+uniq+"\">");
    for ( i=0; i<ndiv; i++ ) {
      ulx_= ulx + ( lrx - ulx ) * i / ndiv;
      lrx_= ulx + ( lrx - ulx ) * ( i+1 ) / ndiv;
      coords= "" + ulx_ + "," + uly + "," + lrx_ + "," +lry;  
      d.writeln("          <area shape=\"rect\" coords=\""+coords+"\" href=\"javascript:void(0);\" onclick=\"mapClick("+i+","+ndiv+",'"+pngFileName+"', '"+root+"');\">");
    }

    d.writeln("       </map>");

    d.writeln("  ");
}

