/*
 * VgpwsOptionsPanel.java
 *
 * Created on May 17, 2006, 1:58 PM
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.util.DasExceptionHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author  Jeremy
 */
public class VgpwsOptionsPanel extends javax.swing.JPanel {
    public static final String OPTION_NOISEFILTEROPTIONSMEDIANOFTHREE = "noiseFilterOptionsMedianOfThree";
    public static final String OPTION_NOISEFILTEROPTIONSNOISEBURST = "noiseFilterOptionsNoiseBurst";
    public static final String OPTION_NOISEFILTEROPTIONSTHRESHOLD = "noiseFilterOptionsThreshold";
    
    Vg1pws vg1pws;
    TCAComboBoxModel tcaModel;
    
    // local root
    private URL root;
    
    URL SERVER_EVENTS_URL; {
        try {
            SERVER_EVENTS_URL= new URL( "http://www-pw.physics.uiowa.edu/voyager/local1/" );
        } catch ( MalformedURLException e ) { throw new RuntimeException(e); }
    }
    
    /** Creates new form VgpwsOptionsPanel */
    public VgpwsOptionsPanel( Vg1pws vg1pws ) {
        this.vg1pws= vg1pws;
        tcaModel=  new TCAComboBoxModel(vg1pws,Spacecraft.voyager1) ;
        initComponents();
        prefs= vg1pws.prefs;
        if ( !vg1pws.localOnly ) readPrefs();
        if ( vg1pws.localOnly ) {
            setNetworkOptionsEnabled(false);
        } else {
            networkOptionsLabel.setVisible(false);
            enableNetworkOptionsCB.setVisible(false);
        }
        removeBackgroundCB.setVisible(false);  // not used any more.
    }
    
    /**
     * 
     * @param b 
     */
    protected void setRemovePLSInterference( boolean b ) {
        this.removePlsCB.setSelected(b);
    }
    
    protected void setRemoveSCEvents( boolean b ) {
        this.removeSCEventsCB.setSelected(b);
    }
    
    private void setNetworkOptionsEnabled( boolean b ) {
        if ( !b ) {
            tcaModel.setSelectedItem("No Trajectory Parameters"); // danger
            das2ServerSourceRB.setEnabled(false);
            localSourceRB.setSelected(true);
            das2ServerSourceRB.setToolTipText("Network required for this option");
            tcaComboBox.setEnabled(false);
            tcaComboBox.setToolTipText("Network required for this option");
            tcaLabel.setEnabled(false);
            tcaLabel.setToolTipText("Network required for this option");
            fceCheckBox.setVisible(false);
            localEventsCB.setSelected(true);
            localEventsCB.setEnabled(false);
            localEventsCB.setToolTipText("Network required for this option");
        } else {
            das2ServerSourceRB.setEnabled(true);
            das2ServerSourceRB.setToolTipText(null);
            tcaComboBox.setEnabled(true);
            tcaComboBox.setToolTipText(null);
            tcaLabel.setEnabled(true);
            tcaLabel.setToolTipText(null);
            //fceCheckBox.setVisible(false);
            localEventsCB.setEnabled(true);
            localEventsCB.setToolTipText(null);
        }
    }
    
    private static String toURLArgsString( Map optionsMap ) {
        try {
            StringBuffer result=null;
            for ( Iterator i= optionsMap.keySet().iterator(); i.hasNext(); ) {
                Object key= i.next();
                Object value= optionsMap.get(key);
                if ( result==null ) {
                    result= new StringBuffer( ""+key+"="+URLEncoder.encode((String)value,"US-ASCII") );
                } else {
                    System.err.println(""+key+"="+value);
                    result.append( "&"+key+"="+URLEncoder.encode((String)value,"US-ASCII") );
                }
            }
            return result.toString();
        } catch ( UnsupportedEncodingException e ) {
            throw new RuntimeException(e);
        }
    }
    
    protected void setSpacecraft( Spacecraft sc ) {
        tcaModel.setSpacecraft(sc);
        voyagerSelector.setSelectedIndex( sc.toInt()-1 );
        tcaComboBox.setSelectedIndex(0);
    }
    
    protected void setOverlayFce( boolean overlayFce ) {
        fceCheckBox.setSelected(overlayFce);
    }
    
    protected void setUseLocalFileSystem() {
        this.localSourceRB.setSelected(true);
    }

    protected boolean filterOptionsNoiseBurst = true;
    
    public boolean isFilterOptionsNoiseBurst() {
        return filterOptionsNoiseBurst;
    }

    public void setFilterOptionsNoiseBurst(boolean filterOptionsNoiseBurst) {
        this.filterOptionsNoiseBurst = filterOptionsNoiseBurst;
    }

    protected boolean filterOptionsMedianOfThree = true;

    public boolean isFilterOptionsMedianOfThree() {
        return filterOptionsMedianOfThree;
    }

    public void setFilterOptionsMedianOfThree(boolean filterOptionsMediaOfThree) {
        this.filterOptionsMedianOfThree = filterOptionsMediaOfThree;
    }

    protected boolean filterOptionsThresholdFilter = true;

    public boolean isFilterOptionsThresholdFilter() {
        return filterOptionsThresholdFilter;
    }

    public void setFilterOptionsThresholdFilter(boolean filterOptionsThresholdFilter) {
        this.filterOptionsThresholdFilter = filterOptionsThresholdFilter;
    }


    private static Map toMap( String urlArgsString ) {
        try {
            String[] s= urlArgsString.split( "&" );
            HashMap result= new HashMap();
            for ( int i=0; i<s.length; i++ ) {
                String[] ss= s[i].split("=");
                String key= ss[0];
                String value= URLDecoder.decode(ss[1],"US_ASCII");
                result.put(key,value);
            }
            return result;
        } catch ( UnsupportedEncodingException e ) {
            throw new RuntimeException(e);
        }
    }
    
    
    private Map getOptionsMap() {
        Map optionsMap= new HashMap();
        optionsMap.put("filterPLS", this.removePlsCB.isSelected() ? "true" : "false" );
        optionsMap.put( "units", this.unitsComboBox.getSelectedItem() );
        optionsMap.put("filterSpacecraftEvents", removeSCEventsCB.isSelected() ? "true" : "false" );
        optionsMap.put("noiseFilter", noiseFilterCB.isSelected() ? "true" : "false" );
        if ( isFilterOptionsMedianOfThree()==false ) optionsMap.put(OPTION_NOISEFILTEROPTIONSMEDIANOFTHREE,"false");
        if ( isFilterOptionsNoiseBurst()==false ) optionsMap.put(OPTION_NOISEFILTEROPTIONSNOISEBURST,"false");
        if ( isFilterOptionsThresholdFilter()==false ) optionsMap.put(OPTION_NOISEFILTEROPTIONSTHRESHOLD,"false");

        optionsMap.put("removeBackground", removeBackgroundCB.isSelected() ? "true" : "false" );
        return optionsMap;
    }
    
    private void setOptionsMap( Map optionsMap ) {
        this.removePlsCB.setSelected(  "true".equals(optionsMap.get("filterPLS"))  );
        this.removeSCEventsCB.setSelected(  "true".equals(optionsMap.get("filterSpacecraftEvents"))  );
        this.unitsComboBox.setSelectedItem( optionsMap.get( "units" ) );
        this.noiseFilterCB.setSelected( "true".equals(optionsMap.get("noiseFilter") ) );
        this.setFilterOptionsMedianOfThree( !( "false".equals(optionsMap.get(OPTION_NOISEFILTEROPTIONSMEDIANOFTHREE)) ) );
        this.setFilterOptionsNoiseBurst( !( "false".equals(optionsMap.get(OPTION_NOISEFILTEROPTIONSNOISEBURST)) ) );
        this.setFilterOptionsThresholdFilter( !( "false".equals(optionsMap.get(OPTION_NOISEFILTEROPTIONSTHRESHOLD)) ) );
        //this.removeBackgroundCB.setSelected( "true".equals(optionsMap.get("removeBackground" ) ) );
        this.removeBackgroundCB.setSelected( false );
    }
    
    private DataSetDescriptor getDataSetDescriptor( Spacecraft spacecraft, Map optionsMap ) throws UnsupportedEncodingException, DasException {
        String id;
        if ( localSourceRB.isSelected() ) {
         //   try {
                //root= new URL( "http://www-pw.physics.uiowa.edu/voyager/local1/");
          //  } catch (MalformedURLException ex) {
            //    ex.printStackTrace();
          //  }
            id= "class:edu.uiowa.physics.pw.apps.vgpws.Vg1pwsDataSetDescriptor?"+
                    "spacecraft="+spacecraft.toInt()+"&root="+URLEncoder.encode(root.toString(),"US-ASCII")+"&"+toURLArgsString(optionsMap);
        } else if ( das2ServerSourceRB.isSelected() ) {
            String units= "pf";
            String s;
            if  ((s=(String)optionsMap.get("units" ) ) !=null ) {
               if ( s.equals("Electric Field" ) ) {
                   units="ef";
               } else if ( s.equals("Spectral Density" ) ) {
                   units="sd";
               } else if ( s.equals("Power Flux" ) ) {
                   units= "pf";
               }
            }
            id= "http://www-pw.physics.uiowa.edu/das/das2Server?das2_1/voyager"+spacecraft.toInt()+"/pws/sa-4s-"+units+".new";
        } else {
            throw new RuntimeException("source not selected");
        }
        DataSetDescriptor dsd= DataSetDescriptor.create( id );
        return dsd;
    }
    
    
    protected Spacecraft getSpacecraft() {
        Spacecraft sc= Spacecraft.getByInt(voyagerSelector.getSelectedIndex()+1);
        return sc;
    }
    
    private URL getEventsURL() throws MalformedURLException {
        if ( localSourceRB.isSelected() ) {
            if ( localEventsCB.isSelected() ) {
                return root;
            } else {
                return SERVER_EVENTS_URL;
            }
        } else if ( das2ServerSourceRB.isSelected() ) {
            return SERVER_EVENTS_URL;
        } else {
            throw new RuntimeException("not selected");
        }
    }
    
    public void setFileSystemRoot( String surl ) throws MalformedURLException {
        this.root= getURL( surl );
        this.localRootTextField.setText(root.toString());
    }
    
    public void setLocalFileSystemRoot( File root ) {
        try {
            this.root= root.toURI().toURL();
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        this.localRootTextField.setText(root.toString());
    }
    
    protected void update() {
        try {
            Spacecraft sc= getSpacecraft();
            Map optionsMap= getOptionsMap();
            
            Vg1pwsEventsDataSetDescriptor eventsDsd= new Vg1pwsEventsDataSetDescriptor( getEventsURL(), sc );
            
            Vg1pwsReaderNew.DataUnit unit=null;
            String s= (String) unitsComboBox.getSelectedItem();

            if ( s==null ) {
                s= "Electric Field";
                unitsComboBox.setSelectedItem(s);
            }

            if ( s.equals( "Spectral Density" ) ) {
                unit= Vg1pwsReaderNew.DataUnit.SpectralDensity;
            } else if ( s.equals( "Electric Field" )  ) {
                unit= Vg1pwsReaderNew.DataUnit.ElectricField;
            }
            optionsMap.put( "units", s );
            vg1pws.setDataUnits( unit  );
                            
            DataSetDescriptor dsd= getDataSetDescriptor( sc, optionsMap );
            if ( dsd instanceof Vg1pwsDataSetDescriptor ) {
                ((Vg1pwsDataSetDescriptor)dsd).setEventsDataSetDescriptor( eventsDsd );
            }
            
            vg1pws.setDataSetDescriptor( dsd );
            vg1pws.setEventsDataSetDescriptor( eventsDsd );
            
            vg1pws.setFceRendererActive( fceCheckBox.isSelected() );
            
            setTCA();
            
            if ( !vg1pws.localOnly ) writePrefs();
        } catch ( Exception e ) {
            throw new RuntimeException(e);
        }
    }
    
    private void setTCA() {
        String tcaDataSetId= tcaModel.getTCADataSetId();
        if ( vg1pws.isUpdating() ) {
            if ( tcaDataSetId.equals("") ) {
                vg1pws.getTimeAxis().setDrawTca(false);
            } else {
                vg1pws.getTimeAxis().setDataPath(tcaDataSetId);
                vg1pws.getTimeAxis().setDrawTca(true);
            }
        }
    }
    
    private void pickRoot(  ) {
        JFileChooser j= new JFileChooser();
        j.setCurrentDirectory(new File( root.getFile()) );
        j.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int i= j.showOpenDialog(VgpwsOptionsPanel.this);
        if ( i==JFileChooser.APPROVE_OPTION ) {
            String rootString;
            try {
                root= j.getSelectedFile().toURL();
            } catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            if ( root==null ) {
                rootString= "<html><i>directory not correctly specified</i></html>";
            } else {
                rootString= root.toString();
            }
            localRootTextField.setText(rootString);
        }
        
    }
    
    static Preferences prefs;
    static String CURRENT_DIRECTORY_KEY= "currentDirectory";
    static String CURRENT_SPACECRAFT_KEY= "spacecraft";
    static String CURRENT_DATASOURCE_KEY= "dataSource";
    static String CURRENT_OPTIONS_KEY= "options";
    static String CURRENT_TCA_KEY= "tca";
    static String LOCAL_EVENTS_KEY= "localEvents";
    
    private void writePrefs() throws BackingStoreException {
        prefs.put( LOCAL_EVENTS_KEY, localEventsCB.isSelected() ? "true" : "false" );
        prefs.put( CURRENT_DIRECTORY_KEY, root.toString() );
        prefs.put( CURRENT_OPTIONS_KEY, toURLArgsString( getOptionsMap() ) );
        prefs.put( CURRENT_SPACECRAFT_KEY, getSpacecraft().toString() );
        prefs.put( CURRENT_TCA_KEY,  (String)tcaModel.getSelectedItem() );
        prefs.flush();
    }
    
    private void readPrefs()  {
        String initialString=  prefs.get(CURRENT_DATASOURCE_KEY,"Das2Server");
        if ( initialString.equals("Das2Server") ) {
            das2ServerSourceRB.setSelected(true);
        } else {
            localSourceRB.setSelected(true);
        }
        try {
            root= getURL( prefs.get(CURRENT_DIRECTORY_KEY, "" ) );
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        setSpacecraft( Spacecraft.getByName( prefs.get(CURRENT_SPACECRAFT_KEY, Spacecraft.voyager1.toString() ) ) );
        localEventsCB.setSelected( prefs.get( LOCAL_EVENTS_KEY, "false" ).equals("true") );
        String optionsString= prefs.get( CURRENT_OPTIONS_KEY, "filterPLS=true&filterSpacecraftEvents=true&noiseFilter=false&removeBackground=false" );
        setOptionsMap( toMap(optionsString) );
        
        tcaModel.setSelectedItem( prefs.get( CURRENT_TCA_KEY, "" ) );
    }
    
    /**
     * canonical method for getting the URL.  If no protocol is specified, then file:// is
     * used.
     */
    public static URL getURL( String surl ) throws MalformedURLException {
        if ( surl.equals("") ) return new File("").toURL();
        boolean isUrl= surl.contains(":") && surl.indexOf(':')>1; // allow windows C:
        if ( !isUrl ) {
            if ( surl.startsWith("/") ) {
                surl= "file://"+surl;
            } else {
                File f= new File( surl );
                try {
                    surl= "file://"+f.getCanonicalPath();
                } catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if ( surl.endsWith( "://" ) ) surl+= "/";
        return new URL( surl );
    }

    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sourceButtonGroup = new javax.swing.ButtonGroup();
        voyagerSelector = new javax.swing.JComboBox();
        localSourceRB = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        chooseLocalFSButton = new javax.swing.JButton();
        das2ServerSourceRB = new javax.swing.JRadioButton();
        localEventsCB = new javax.swing.JCheckBox();
        removePlsCB = new javax.swing.JCheckBox();
        removeSCEventsCB = new javax.swing.JCheckBox();
        noiseFilterCB = new javax.swing.JCheckBox();
        removeBackgroundCB = new javax.swing.JCheckBox();
        tcaComboBox = new javax.swing.JComboBox();
        tcaLabel = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        fceCheckBox = new javax.swing.JCheckBox();
        networkOptionsLabel = new javax.swing.JLabel();
        enableNetworkOptionsCB = new javax.swing.JCheckBox();
        unitsComboBox = new javax.swing.JComboBox();
        localRootTextField = new javax.swing.JTextField();
        fileterOptionsButton = new javax.swing.JButton();

        sourceButtonGroup.add( das2ServerSourceRB );
        sourceButtonGroup.add( localSourceRB );

        voyagerSelector.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Voyager 1", "Voyager 2" }));
        voyagerSelector.setAction(new AbstractAction() {
            public void actionPerformed( ActionEvent e ) {
                Spacecraft sc= Spacecraft.getByInt(voyagerSelector.getSelectedIndex()+1);
                setSpacecraft(sc);
            }
        }
    );

    localSourceRB.setText("Local");
    localSourceRB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    jLabel1.setText("Data Source Selector:");

    chooseLocalFSButton.setAction(new AbstractAction("Choose Root...") {
        public void actionPerformed(ActionEvent ev ) {
            pickRoot();
        }
    });
    chooseLocalFSButton.setText("Choose Root...");

    das2ServerSourceRB.setSelected(true);
    das2ServerSourceRB.setText("Das2 Server");
    das2ServerSourceRB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    localEventsCB.setText("use local events file");
    localEventsCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    removePlsCB.setSelected(true);
    removePlsCB.setText("remove PLS interference");
    removePlsCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    removeSCEventsCB.setSelected(true);
    removeSCEventsCB.setText("remove S/C events interference");
    removeSCEventsCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    noiseFilterCB.setText("include noise filter");
    noiseFilterCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    removeBackgroundCB.setText("remove background");
    removeBackgroundCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

    tcaComboBox.setModel(tcaModel);
    tcaComboBox.setSelectedIndex(0);

    tcaLabel.setText("Time Axis Annotations:");

    jButton1.setText("Update");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            jButton1ActionPerformed(evt);
        }
    });

    fceCheckBox.setText("Overlay fce");
    fceCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    fceCheckBox.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            fceCheckBoxActionPerformed(evt);
        }
    });

    networkOptionsLabel.setText("<html>Network options are initially disabled in this application.  If you have network access, and would like to have time axis annotations, enabling network options will allow for this. </html>");
    networkOptionsLabel.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);

    enableNetworkOptionsCB.setText("Enable Network options");
    enableNetworkOptionsCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    enableNetworkOptionsCB.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            enableNetworkOptionsCBActionPerformed(evt);
        }
    });

    unitsComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Electric Field", "Spectral Density" }));
    unitsComboBox.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            unitsComboBoxActionPerformed(evt);
        }
    });

    localRootTextField.setText("[Moment...]");
    localRootTextField.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            localRootTextFieldActionPerformed(evt);
        }
    });

    fileterOptionsButton.setText("filter options");
    fileterOptionsButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            fileterOptionsButtonActionPerformed(evt);
        }
    });

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
            .addContainerGap()
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(tcaLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(92, 92, 92))
                            .add(layout.createSequentialGroup()
                                .add(tcaComboBox, 0, 226, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                            .add(voyagerSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(layout.createSequentialGroup()
                                .add(unitsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 184, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                        .add(layout.createSequentialGroup()
                            .add(fceCheckBox)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, das2ServerSourceRB)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel1)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(localSourceRB)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(chooseLocalFSButton))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                            .add(17, 17, 17)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(removePlsCB)
                                .add(localEventsCB)
                                .add(removeSCEventsCB, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE)
                                .add(localRootTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE)
                                .add(removeBackgroundCB)
                                .add(layout.createSequentialGroup()
                                    .add(noiseFilterCB)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(fileterOptionsButton))))))
                .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createSequentialGroup()
                            .add(10, 10, 10)
                            .add(enableNetworkOptionsCB))
                        .add(networkOptionsLabel, 0, 0, Short.MAX_VALUE))
                    .add(17, 17, 17)
                    .add(jButton1)))
            .addContainerGap())
    );
    layout.setVerticalGroup(
        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(layout.createSequentialGroup()
                    .add(jLabel1)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(das2ServerSourceRB)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(localSourceRB)
                        .add(chooseLocalFSButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(localRootTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                .add(layout.createSequentialGroup()
                    .add(voyagerSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(unitsComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(tcaLabel)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(tcaComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(layout.createSequentialGroup()
                    .add(19, 19, 19)
                    .add(fceCheckBox))
                .add(layout.createSequentialGroup()
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(localEventsCB)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(removePlsCB)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(removeSCEventsCB)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(removeBackgroundCB)))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(noiseFilterCB)
                .add(fileterOptionsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 27, Short.MAX_VALUE)
            .add(networkOptionsLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 53, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(enableNetworkOptionsCB)
                .add(jButton1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 24, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .addContainerGap())
    );
    }// </editor-fold>//GEN-END:initComponents

    private void localRootTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_localRootTextFieldActionPerformed
        try {
            this.root= new URL( localRootTextField.getText() );
        } catch ( MalformedURLException e ) {
            DasExceptionHandler.handle(e);
        }
    }//GEN-LAST:event_localRootTextFieldActionPerformed

    private void unitsComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unitsComboBoxActionPerformed
        
    }//GEN-LAST:event_unitsComboBoxActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        update();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void enableNetworkOptionsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableNetworkOptionsCBActionPerformed
        setNetworkOptionsEnabled( enableNetworkOptionsCB.isSelected() );
        if ( enableNetworkOptionsCB.isSelected()==false ) update();
    }//GEN-LAST:event_enableNetworkOptionsCBActionPerformed
    
    private void fceCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fceCheckBoxActionPerformed
        vg1pws.setFceRendererActive(fceCheckBox.isSelected());
    }//GEN-LAST:event_fceCheckBoxActionPerformed

    private void fileterOptionsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileterOptionsButtonActionPerformed
        NoiseFilterOptionsPanel p= new NoiseFilterOptionsPanel();
        
        p.getNoiseBurstCB().setSelected( isFilterOptionsNoiseBurst() );
        p.getMediaOfThreeCB().setSelected( isFilterOptionsMedianOfThree() );
        p.getMaximumThresholdCB().setSelected( isFilterOptionsThresholdFilter() );
        if ( JOptionPane.OK_OPTION==JOptionPane.showConfirmDialog( this, p, "filter options", JOptionPane.OK_OPTION ) ) {
            setFilterOptionsNoiseBurst( p.getNoiseBurstCB().isSelected() );
            setFilterOptionsMedianOfThree( p.getMediaOfThreeCB().isSelected() );
            setFilterOptionsThresholdFilter( p.getMaximumThresholdCB().isSelected() );
        }
        
    }//GEN-LAST:event_fileterOptionsButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton chooseLocalFSButton;
    private javax.swing.JRadioButton das2ServerSourceRB;
    private javax.swing.JCheckBox enableNetworkOptionsCB;
    private javax.swing.JCheckBox fceCheckBox;
    private javax.swing.JButton fileterOptionsButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox localEventsCB;
    private javax.swing.JTextField localRootTextField;
    private javax.swing.JRadioButton localSourceRB;
    private javax.swing.JLabel networkOptionsLabel;
    private javax.swing.JCheckBox noiseFilterCB;
    private javax.swing.JCheckBox removeBackgroundCB;
    private javax.swing.JCheckBox removePlsCB;
    private javax.swing.JCheckBox removeSCEventsCB;
    private javax.swing.ButtonGroup sourceButtonGroup;
    private javax.swing.JComboBox tcaComboBox;
    private javax.swing.JLabel tcaLabel;
    private javax.swing.JComboBox unitsComboBox;
    private javax.swing.JComboBox voyagerSelector;
    // End of variables declaration//GEN-END:variables
    
}
