/*
 * Vg1pwsDas2Stream.java
 *
 * Created on April 22, 2004, 9:22 AM
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.ArgumentList;
import java.io.*;
import java.net.*;
import java.util.logging.*;

/**
 *
 * @author  Jeremy
 */
public class VgpwsDas2StreamSource {
    
    static void createStream( Datum t1, Datum t2, Spacecraft spacecraft, OutputStream out ) {        
        String root= "/opt/project/voyager/";
        
        if ( root.equals("") ) {
            System.err.println("local file system root is not defined in vg1pws preferences.  Run vg1pws and set the " +
            "local file system root.");
            System.exit(-1);
        }
        try {
            URL SERVER_EVENTS_URL;
            SERVER_EVENTS_URL= new URL( "http://www-pw.physics.uiowa.edu/voyager/local1/" );
            String id= "class:edu.uiowa.physics.pw.apps.vg1pws.Vg1pwsDataSetDescriptor?"+
            "spacecraft="+spacecraft.toInt()+"&root="+URLEncoder.encode(root.toString(),"US-ASCII")+"&filterPLS=true&filterSpacecraftEvents=true";                        
            Vg1pwsDataSetDescriptor dsd= (Vg1pwsDataSetDescriptor)DataSetDescriptor.create( id );
            dsd.setEventsDataSetDescriptor( 
              new Vg1pwsEventsDataSetDescriptor( SERVER_EVENTS_URL, spacecraft ) );
            TableDataSet tds= (TableDataSet)dsd.getDataSet( t1, t2, null, null );
            TableUtil.dumpToBinaryStream(tds,out);
        } catch ( UnsupportedEncodingException e ) {
            throw new RuntimeException(e);
        } catch ( DasException e ) {
            DasExceptionHandler.handle(e);
        } catch ( MalformedURLException e ) {
            throw new RuntimeException(e);
        } catch ( org.das2.util.filesystem.FileSystem.FileSystemOfflineException e ) {
            throw new RuntimeException(e);
        }
    }
    
    static void checkArgs( String[] args ) {
        if ( args.length!=3 ) {
            System.err.println("usage: java edu.uiowa.physics.pw.apps.vg1pws.Vg1pwsDas2Stream <startTime> <endTime> <spacecraft>");
            System.exit(-1);
        }
        Spacecraft spacecraft= Spacecraft.getByInt(Integer.parseInt(args[2]));
        if ( spacecraft==null ) {
            System.err.println( "string identifying spacecraft must be \"1\" or \"2\"" );
            System.exit(-1);
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        ArgumentList alm= new ArgumentList("VgpwsDas2StreamSource");
        alm.addPositionArgument(0, "startTime", "start time of stream" );
        alm.addPositionArgument(1, "endTime", "end time of stream" );
        alm.addPositionArgument(2, "spaceCraft", "spacecraft [1|2]" );
        alm.addPositionArgument(3, "units", "[pf]" );
        alm.process(args);

        DasApplication.getDefaultApplication().getLogger().setLevel(Level.ALL);
        
        if ( !alm.getValue("units").equals("pf") ) throw new IllegalArgumentException("units must be pf");
        Datum t1= TimeUtil.createValid(alm.getValue("startTime"));
        Datum t2= TimeUtil.createValid(alm.getValue("endTime"));
        
        Spacecraft spacecraft= Spacecraft.getByInt(Integer.parseInt(alm.getValue("spaceCraft")));
        createStream( t1, t2, spacecraft, System.out );
    }
    
}
