/*
 * Vg1pwsDas2Stream.java
 *
 * Created on April 22, 2004, 9:22 AM
 */

package edu.uiowa.physics.pw.apps.vgpws;

import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.DasException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.ArgumentList;
import java.io.*;
import java.net.*;
import java.util.prefs.*;

/**
 *
 * @author  Jeremy
 */
public class Vg1pwsDas2Stream {
    static String CURRENT_DIRECTORY_KEY= "currentDirectory";
    static void createStream( Datum t1, Datum t2, Spacecraft spacecraft, String options, OutputStream out ) {
        Preferences prefs= Preferences.userNodeForPackage( Vg1pws.class );
        String root= prefs.get( CURRENT_DIRECTORY_KEY, "/opt/project/voyager" );
        if ( root.equals("") ) {
            System.err.println("local file system root is not defined in vg1pws preferences.  Run vg1pws and set the " +
            "local file system root.");
            System.exit(-1);
        }
        try {                        
            String id= "class:edu.uiowa.physics.pw.apps.vg1pws.Vg1pwsDataSetDescriptor?"+
            "spacecraft="+spacecraft.toInt()+"&root="+URLEncoder.encode(root.toString(),"US-ASCII")+"&"+options;                        
            System.err.println("using DataSetDescriptor "+id);
            Vg1pwsDataSetDescriptor dsd= (Vg1pwsDataSetDescriptor)DataSetDescriptor.create( id );
            dsd.setEventsDataSetDescriptor( new Vg1pwsEventsDataSetDescriptor( new File( root ).toURL(), spacecraft ) );
            TableDataSet tds= (TableDataSet)dsd.getDataSet( t1, t2, null, null );
            TableUtil.dumpToBinaryStream(tds,out);
        } catch ( UnsupportedEncodingException e ) {
            throw new RuntimeException(e);
        } catch ( DasException e ) {
            DasExceptionHandler.handle(e);
        } catch ( MalformedURLException e ) {
            DasExceptionHandler.handle(e);
        } catch ( org.das2.util.filesystem.FileSystem.FileSystemOfflineException e ) {
            DasExceptionHandler.handle(e);
        }
    }      
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        ArgumentList al= new ArgumentList("Vg1pwsDas2Stream");
        al.addPositionArgument(0,"startTime", "Start Time");
        al.addPositionArgument(1,"endTime", "End Time");
        al.addPositionArgument(2,"spacecraft", "Spacecraft 1|2");
        al.addOptionalSwitchArgument("options", "o", "options", "filterPLS=true&filterSpacecraftEvents=true&noiseFilter=true&removeBackground=false", "options for local reader" );
        al.process(args);
        
        Datum t1= TimeUtil.createValid(al.getValue("startTime"));
        Datum t2= TimeUtil.createValid(al.getValue("endTime"));
        Spacecraft spacecraft= Spacecraft.getByInt(Integer.parseInt(al.getValue("spacecraft")));
        String options= al.getValue("options");
        createStream( t1, t2, spacecraft, options, System.out );
    }
    
}
